/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.template.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.SpreadConstants;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class SpreadDataModel
extends SpreadActionAdapter {
    private static Log logger = LogFactory.getLog(SpreadDataModel.class);
    private static final String selCols = "selCols";
    private static final String selRows = "selRows";
    private static final String selectCellKey = "selCellKey";
    private String spreadName;
    private static final String METHOD = "method";
    private static final String INDEX = "index";
    private static final String VISIBLE = "visible";
    private String entityTemplate;
    private IPageCache pageCache;

    public SpreadDataModel(AbstractFormPlugin plugin, String spreadName, String entityTemplate) {
        super(plugin);
        this.spreadName = spreadName;
        this.entityTemplate = entityTemplate;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public void selectedSpread(SpreadEvent event) {
        logger.info("\u8c03\u7528SpreadDataModel.selectedSpread()");
        SpreadPostDataInfo postDataInfo = event.getPostData();
        List selColsList = postDataInfo.getSelCols();
        List selRowsList = postDataInfo.getSelRows();
        Map<String, Object> cellParamMap = this.resolveCellKey(event);
        TreeUtils.putCache(this.plugin.getPageCache(), selCols, selColsList);
        TreeUtils.putCache(this.plugin.getPageCache(), selRows, selRowsList);
        TreeUtils.putCache(this.plugin.getPageCache(), selectCellKey, JsonUtil.toJson(cellParamMap));
    }

    public List<Integer> getSelCols() {
        return TreeUtils.getCache(this.plugin.getPageCache(), selCols, List.class);
    }

    public String getSelectedCellKey() {
        logger.info("\u8c03\u7528SpreadDataModel.getSelectedCellKey(),\u8fd4\u56de:{}", (Object)TreeUtils.getCache(this.plugin.getPageCache(), selectCellKey, String.class));
        return TreeUtils.getCache(this.plugin.getPageCache(), selectCellKey, String.class);
    }

    public void updateCellValue(SpreadEvent event) {
        SpreadPostDataInfo postDataInfo = event.getPostData();
        List list = postDataInfo.getValues();
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "updataValue", new Object[]{list});
    }

    public List<Integer> getSelRows() {
        return TreeUtils.getCache(this.plugin.getPageCache(), selRows, List.class);
    }

    public void init() {
        String s = "{}";
        this.setSpreadJson(s);
    }

    public void setCellStyle(List<Map<String, Object>> list) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setCellStyle", new Object[]{list});
    }

    public void updataValue(List<Map<String, Object>> list) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "updataValue", new Object[]{list});
    }

    public void setSpreadJson(String json) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setSpreadJson", new Object[]{json});
    }

    public void getSpreadJson(Map<String, String> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "getSpreadJson", new Object[]{params});
    }

    public void setSpreadParams(Map<String, Object> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setSpreadParams", new Object[]{params});
    }

    public void setFormula(Map<String, Object> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setFormula", new Object[]{params});
    }

    public void setCustomFormulaCell(Map<String, Object> params) {
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "setCustomFormulaCell", new Object[]{params});
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.plugin.getView().getService(IClientViewProxy.class);
    }

    public void askExecute(SpreadEvent event) {
        logger.info("spread custom event");
        LinkedHashMap map = event.getPostData().getInvokeParams();
        logger.debug("invoke params:" + map);
        if (!map.isEmpty()) {
            Object method = map.get(METHOD);
            logger.info("request method:" + method);
            this.executeAction(map);
        }
    }

    public void askExecute(LinkedHashMap<String, Object> map) {
        logger.info("spread custom event");
        logger.debug("invoke params:" + map);
        if (!map.isEmpty()) {
            Object method = map.get(METHOD);
            logger.info("request method:" + method);
            this.executeAction(map);
        }
    }

    private void executeAction(Map<String, Object> params) {
        if (!params.isEmpty()) {
            Object method = params.get(METHOD);
            Map<Object, Object> objectMap = new HashMap(16);
            if (StringUtils.isNotBlank((Object)method)) {
                switch (method.toString()) {
                    case "hideSheet": {
                        objectMap = this.assembleRequestMap(params);
                        objectMap.put(VISIBLE, Boolean.FALSE);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, SpreadConstants.getActionMappings().get(method), new Object[]{objectMap});
                        break;
                    }
                    case "insertSheet": {
                        ArrayList list = new ArrayList(SpreadConstants.getDefaultAddSheetCount());
                        for (int i = 1; i <= SpreadConstants.getDefaultAddSheetCount(); ++i) {
                            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                            itemMap.put(INDEX, Integer.parseInt(params.get(INDEX).toString()) + i);
                            itemMap.put("name", "Sheet" + itemMap.get(INDEX));
                            list.add(itemMap);
                        }
                        objectMap.put("sheets", list);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, SpreadConstants.getActionMappings().get(method), new Object[]{objectMap});
                        break;
                    }
                    case "activeSheetChange": 
                    case "newTab": {
                        if (this.pageCache != null) {
                            this.pageCache.put("currentIndex", String.valueOf(params.get(INDEX)));
                        }
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                        break;
                    }
                    case "deleteSheet": {
                        objectMap = this.assembleRequestMap(params);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, SpreadConstants.getActionMappings().get(method), new Object[]{objectMap});
                        break;
                    }
                    case "deleteRow": 
                    case "deleteCol": {
                        this.reverseIndexArr(params);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                        break;
                    }
                    case "insertRow": 
                    case "insertCol": {
                        this.assembleActionRequestMap(params);
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                        break;
                    }
                    default: {
                        this.getClientViewProxy().invokeControlMethod(this.spreadName, method.toString(), new Object[]{params});
                    }
                }
            }
        }
    }

    private void assembleActionRequestMap(Map<String, Object> params) {
        Object data = params.get("data");
        if (data instanceof Map) {
            Map map = (Map)data;
            int selectIndex = (Integer)map.get("selectIndex");
            int count = (Integer)map.get("count");
            String dir = (String)map.get("dir");
            ArrayList list = Lists.newArrayListWithExpectedSize((int)count);
            for (int i = 0; i < count; ++i) {
                list.add(selectIndex++);
            }
            params.put("data", list);
            if (StringUtils.isNotEmpty((CharSequence)dir)) {
                params.put("dir", dir);
            }
        }
    }

    private Map<String, Object> reverseIndexArr(Map<String, Object> params) {
        List indexs;
        if (params.containsKey("data") && (indexs = (List)params.get("data")) != null) {
            Collections.reverse(indexs);
        }
        return params;
    }

    private Map<String, Object> assembleRequestMap(Map<String, Object> params) {
        Integer index = (Integer)params.get(INDEX);
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        indexList.add(index);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(4);
        requestMap.put(INDEX, indexList);
        return requestMap;
    }

    public void doubleClickLockedCell(int row, int col) {
        ArrayList cells = new ArrayList();
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put("r", row);
        cell.put("c", col);
        cells.add(cell);
        this.getClientViewProxy().invokeControlMethod(this.spreadName, "unlockCell", new Object[]{cells});
    }

    public Map<String, Object> resolveCellKey(SpreadEvent event) {
        logger.info("\u8c03\u7528SpreadDataModel.resolveCellKey");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        SpreadPostDataInfo postDataInfo = event.getPostData();
        Spread spread = (Spread)event.getSource();
        IPageCache pageCache = (IPageCache)spread.getView().getService(IPageCache.class);
        if (null != pageCache) {
            Map cacheAll = pageCache.getAll();
            logger.info("\u8c03\u7528SpreadDataModel.resolveCellKey\uff0ccacheAll={}", (Object)JsonUtil.toJson(cacheAll));
            if (!CollectionUtils.isEmpty((Map)cacheAll) && StringUtils.isNotBlank((CharSequence)((CharSequence)cacheAll.get("controlstates")))) {
                Map spreadmap;
                Map map = (Map)SerializationUtils.fromJsonString((String)((String)cacheAll.get("controlstates")), Map.class);
                List selColsList = postDataInfo.getSelCols();
                List selRowsList = postDataInfo.getSelRows();
                if (!map.isEmpty() && !(spreadmap = (Map)map.get("spreadap")).isEmpty() && null != spreadmap.get("sheetName")) {
                    String sheetName = spreadmap.get("sheetName").toString();
                    String templateIdStr = StringUtils.isEmpty((CharSequence)((CharSequence)cacheAll.get("MUTEX_OBJ_ID"))) ? (String)cacheAll.get("HMUTEX_OBJ_ID") : (String)cacheAll.get("MUTEX_OBJ_ID");
                    templateIdStr = StringUtils.isEmpty((CharSequence)templateIdStr) ? (String)cacheAll.get("templateid") : templateIdStr;
                    logger.info("\u8c03\u7528SpreadDataModel.resolveCellKey templateid:" + templateIdStr);
                    if (StringUtils.isNotBlank((CharSequence)templateIdStr) && !Objects.equals("0", templateIdStr)) {
                        Long templateId = Long.parseLong(templateIdStr);
                        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)this.entityTemplate);
                        Map<String, EntityField> fieldMap = TemplateShowUtils.queryTemplateField(templateId, this.entityTemplate);
                        if (templateObject != null && StringUtils.isNotEmpty((CharSequence)templateObject.getString("content_tag"))) {
                            String jsonString = templateObject.getString("content_tag");
                            List<Sheet> sheets = SpreadUtils.getSheets(jsonString, sheetName);
                            List<Object> columncellList = new ArrayList();
                            if (!sheets.isEmpty()) {
                                List<List<Cell>> rowList = sheets.get(0).getRowList();
                                for (int i = 0; i < rowList.size(); ++i) {
                                    if (i != (Integer)selRowsList.get(0)) continue;
                                    columncellList = rowList.get(i);
                                    break;
                                }
                            }
                            String text = null;
                            String textName = null;
                            for (Cell cell : columncellList) {
                                if (!((Integer)selRowsList.get(0)).equals(cell.getRow()) || !((Integer)selColsList.get(0)).equals(cell.getCol())) continue;
                                text = cell.getText();
                                if (!StringUtils.isNotEmpty((CharSequence)text) || !text.startsWith("${") || !(text = text.replace("${", "").replace("}", "")).endsWith("%")) break;
                                text = text.replace("%", "");
                                break;
                            }
                            for (Map.Entry entry : fieldMap.entrySet()) {
                                if (null == entry.getValue()) continue;
                                String tableName = ((EntityField)entry.getValue()).getEntityId();
                                String ewblxh = ((EntityField)entry.getValue()).getEwblxh();
                                String fieldId = ((EntityField)entry.getValue()).getFieldId();
                                if (!StringUtils.equals((CharSequence)text, (CharSequence)(tableName + "#" + ewblxh + "#" + fieldId))) continue;
                                textName = ((EntityField)entry.getValue()).getEntityName() + "#" + ewblxh + "#" + ((EntityField)entry.getValue()).getFieldName();
                            }
                            paramMap.put("templateId", templateId);
                            paramMap.put("selectCellKey", text);
                            paramMap.put("selectCellName", textName);
                        }
                    }
                }
            } else {
                this.handleSelectedkey(cacheAll, postDataInfo, null, paramMap);
            }
        }
        return paramMap;
    }

    private void handleSelectedkey(Map<String, String> cacheAll, SpreadPostDataInfo postDataInfo, String sheetName, Map<String, Object> paramMap) {
        String templateIdStr;
        List selColsList = postDataInfo.getSelCols();
        List selRowsList = postDataInfo.getSelRows();
        String string = templateIdStr = StringUtils.isEmpty((CharSequence)cacheAll.get("MUTEX_OBJ_ID")) ? cacheAll.get("HMUTEX_OBJ_ID") : cacheAll.get("MUTEX_OBJ_ID");
        if (!CollectionUtils.isEmpty(cacheAll) && StringUtils.isNotEmpty((CharSequence)templateIdStr)) {
            Long templateId = Long.parseLong(templateIdStr);
            logger.info("\u8c03\u7528SpreadDataModel.handleSelectedkey\uff0ctemplateId={}", (Object)templateId);
            DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)this.entityTemplate);
            Map<String, EntityField> fieldMap = TemplateShowUtils.queryTemplateField(templateId, this.entityTemplate);
            if (templateObject != null && StringUtils.isNotEmpty((CharSequence)templateObject.getString("content_tag"))) {
                String jsonString = templateObject.getString("content_tag");
                List<Sheet> sheets = SpreadUtils.getSheets(jsonString, null);
                List<Object> columncellList = new ArrayList();
                if (!sheets.isEmpty()) {
                    List<List<Cell>> rowList = sheets.get(0).getRowList();
                    for (int i = 0; i < rowList.size(); ++i) {
                        if (i != (Integer)selRowsList.get(0)) continue;
                        columncellList = rowList.get(i);
                        break;
                    }
                }
                String text = null;
                String textName = null;
                for (Cell cell : columncellList) {
                    if (!((Integer)selRowsList.get(0)).equals(cell.getRow()) || !((Integer)selColsList.get(0)).equals(cell.getCol())) continue;
                    text = cell.getText();
                    if (!StringUtils.isNotEmpty((CharSequence)text) || !text.startsWith("${") || !(text = text.replace("${", "").replace("}", "")).endsWith("%")) break;
                    text = text.replace("%", "");
                    break;
                }
                for (Map.Entry entry : fieldMap.entrySet()) {
                    if (null == entry.getValue()) continue;
                    String tableName = ((EntityField)entry.getValue()).getEntityId();
                    String ewblxh = ((EntityField)entry.getValue()).getEwblxh();
                    String fieldId = ((EntityField)entry.getValue()).getFieldId();
                    if (!StringUtils.equals((CharSequence)text, (CharSequence)(tableName + "#" + ewblxh + "#" + fieldId))) continue;
                    textName = ((EntityField)entry.getValue()).getEntityName() + "#" + ewblxh + "#" + ((EntityField)entry.getValue()).getFieldName();
                }
                paramMap.put("templateId", templateId);
                paramMap.put("selectCellKey", text);
                paramMap.put("selectCellName", textName);
            }
        }
    }
}

