/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.template.dynamic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.BasePointInfo;

public class PositionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final transient PositionInfo EMPTY = new PositionInfo("NULL", "NULL");
    private String startPosition;
    private String areaRange;
    private String originalStartPosition;
    private String originalAreaRange;
    private boolean isSplit = false;
    private List<BasePointInfo> basePoints = new ArrayList<BasePointInfo>(3);
    private FloatSummaryWay floatSummaryWay;
    private int orgMemColIndex;
    private FloatOrgRange floatOrgRange;
    private FloatMemDisplayPattern floatMemDisplayPattern;

    public PositionInfo(String startPosition, String areaRange) {
        this.startPosition = startPosition;
        this.areaRange = areaRange;
        this.originalAreaRange = areaRange;
        this.originalStartPosition = startPosition;
    }

    public FloatSummaryWay getFloatSummaryWay() {
        return this.floatSummaryWay;
    }

    public boolean isFloatPosition() {
        return !this.basePoints.isEmpty();
    }

    public void setFloatSummaryWay(FloatSummaryWay floatSummaryWay) {
        this.floatSummaryWay = floatSummaryWay;
    }

    public int getOrgMemColIndex() {
        return this.orgMemColIndex;
    }

    public void setOrgMemColIndex(int orgMemColIndex) {
        this.orgMemColIndex = orgMemColIndex;
    }

    public FloatOrgRange getFloatOrgRange() {
        return this.floatOrgRange;
    }

    public void setFloatOrgRange(FloatOrgRange floatOrgRange) {
        this.floatOrgRange = floatOrgRange;
    }

    public FloatMemDisplayPattern getFloatMemDisplayPattern() {
        return this.floatMemDisplayPattern;
    }

    public void setFloatMemDisplayPattern(FloatMemDisplayPattern floatMemDisplayPattern) {
        this.floatMemDisplayPattern = floatMemDisplayPattern;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public String getAreaRange() {
        return this.areaRange;
    }

    public void setAreaRange(String areaRange) {
        this.areaRange = areaRange;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public String getOriginalStartPosition() {
        if (this.originalStartPosition == null) {
            this.originalStartPosition = this.startPosition;
        }
        return this.originalStartPosition;
    }

    public String getOriginalAreaRange() {
        if (this.originalAreaRange == null) {
            this.originalAreaRange = this.areaRange;
        }
        return this.originalAreaRange;
    }

    private Object readResolve() {
        if (this.basePoints == null) {
            this.basePoints = new ArrayList<BasePointInfo>(3);
        }
        return this;
    }

    public static enum FloatMemDisplayPattern {
        NAME(1),
        NAMEANDNUMBER(2),
        NUMBER(3);

        private int index;

        private FloatMemDisplayPattern(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum FloatOrgRange {
        LEAF(1),
        DIRECT(2);

        private int index;

        private FloatOrgRange(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum FloatSummaryWay {
        SUPPORT(1),
        NONSUPPORT(2);

        private int index;

        private FloatSummaryWay(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

