/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.XFSStatusService;

public class DeclareStepsStatusService {
    private static Log LOGGER = LogFactory.getLog(DeclareStepsStatusService.class);

    public static boolean updateStatus(Map<String, Object> customParams, String orgid, String skssqq, String skssqz) {
        Object statusclass = customParams.get("statusclass");
        if (statusclass != null) {
            try {
                IStatusService statusService = (IStatusService)Class.forName((String)statusclass).newInstance();
                String focuspage = (String)customParams.get("focuspage");
                if ("zzsyjskb".equals(customParams.get("templatetype"))) {
                    new PrepayStatusService().updateStatus(orgid, skssqq, skssqz, focuspage, (String)customParams.get("projectid"), (String)customParams.get("declareserialno"));
                } else if (String.valueOf(customParams.get("templatetype")).startsWith("xfs")) {
                    new XFSStatusService().setDeclaretype(customParams.get("templatetype").toString()).updateStatus(orgid, skssqq, skssqz, focuspage);
                } else {
                    statusService.updateStatus(orgid, skssqq, skssqz, focuspage);
                }
                return true;
            }
            catch (Throwable t) {
                LOGGER.error(t);
            }
        }
        return false;
    }

    public static String getStatus(Map<String, Object> customParams, String orgid, String skssqq, String skssqz) {
        Object statusclass = customParams.get("statusclass");
        if (statusclass != null) {
            try {
                if (!String.valueOf(customParams.get("templatetype")).startsWith("xfs")) {
                    IStatusService statusService = (IStatusService)Class.forName((String)statusclass).newInstance();
                    return statusService.getStatus(orgid, skssqq, skssqz);
                }
                new XFSStatusService().setDeclaretype(customParams.get("templatetype").toString()).getStatus(orgid, skssqq, skssqz);
            }
            catch (Throwable t) {
                LOGGER.error(t);
            }
        }
        return "0";
    }

    public static void resetParentSteps(int steps, String focusPage, String status, IFormView view) {
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            return;
        }
        DeclareStepsStatusService.resetSteps(steps, focusPage, status, parentView);
        view.sendFormAction(parentView);
    }

    public static void resetSteps(int steps, String focusPage, String status, IFormView view) {
        for (int step = 1; step <= steps; ++step) {
            DeclareStepsStatusService.setStepStyle(status, focusPage, view, step);
            DeclareStepsStatusService.setStatueStyle(status, view, step);
            DeclareStepsStatusService.setProcess(status, view, step);
        }
    }

    private static void setStepStyle(String status, String focusPage, IFormView view, int step) {
        HashMap<String, Object> colorMap = new HashMap<String, Object>();
        String stepColor = "#CCCCCC";
        String linestyle = "1px_solid_#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            stepColor = "themeColor";
            linestyle = "1px_solid_themeColor";
        }
        if (Integer.parseInt(focusPage) == step) {
            colorMap.put("followTheme", Boolean.TRUE);
        } else {
            colorMap.put("followTheme", Boolean.FALSE);
        }
        colorMap.put("fc", stepColor);
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("t", linestyle);
        border.put("l", linestyle);
        border.put("r", linestyle);
        border.put("b", linestyle);
        style.put("b", border);
        colorMap.put("s", style);
        view.updateControlMetadata("step" + step, colorMap);
    }

    private static void setStatueStyle(String status, IFormView view, int step) {
        String statusColor = "#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            statusColor = "themeColor";
        }
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("fc", statusColor);
        view.updateControlMetadata("status" + step, colorMap);
    }

    private static void setProcess(String status, IFormView view, int step) {
        HashMap propertiesMap = new HashMap();
        HashMap style = new HashMap();
        String linestyle = "1px_dashed_#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            linestyle = "1px_solid_#CCCCCC";
        }
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("t", linestyle);
        border.put("l", linestyle);
        style.put("b", border);
        propertiesMap.put("s", style);
        view.updateControlMetadata("process" + step, propertiesMap);
    }
}

