/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.XFSStatusService;

public class DeclareStepsUtils {
    private static Log LOGGER = LogFactory.getLog(DeclareStepsUtils.class);

    public static void updateStatus(Map<String, Object> customParams, String orgid, String skssqq, String skssqz, IFormView view) {
        String statusclass = (String)customParams.get("statusclass");
        if (statusclass != null) {
            try {
                IStatusService statusService = (IStatusService)Class.forName(statusclass).newInstance();
                Integer totalSteps = (Integer)customParams.get("totalsteps");
                String focuspage = (String)customParams.get("focuspage");
                if ("zzsyjskb".equals(customParams.get("templatetype"))) {
                    new PrepayStatusService().updateStatus(orgid, skssqq, skssqz, focuspage, (String)customParams.get("projectid"), (String)customParams.get("declareserialno"));
                } else if (String.valueOf(customParams.get("templatetype")).startsWith("xfs")) {
                    new XFSStatusService().setDeclaretype(customParams.get("templatetype").toString()).updateStatus(orgid, skssqq, skssqz, focuspage);
                } else if (((String)customParams.get("curruentclass")).contains("PrepayDeclarationPlugin")) {
                    statusService.updateStatus(orgid, skssqq, skssqz, focuspage, (String)customParams.get("projectid"), (String)customParams.get("declareserialno"));
                } else {
                    statusService.updateStatus(orgid, skssqq, skssqz, focuspage);
                }
                if (customParams.get("rootPageId") != null) {
                    IFormView rootView = view.getView((String)customParams.get("rootPageId"));
                    DeclareStepsUtils.resetSteps(totalSteps, focuspage, focuspage, rootView);
                    view.sendFormAction(rootView);
                } else {
                    DeclareStepsUtils.resetSteps(totalSteps, focuspage, focuspage, view);
                }
            }
            catch (Throwable t) {
                LOGGER.error(t);
            }
        }
    }

    public static String getStatus(Map<String, Object> customParams, String orgid, String skssqq, String skssqz) {
        Object statusclass = customParams.get("statusclass");
        if (statusclass != null) {
            try {
                if (!String.valueOf(customParams.get("templatetype")).startsWith("xfs")) {
                    IStatusService statusService = (IStatusService)Class.forName((String)statusclass).newInstance();
                    return statusService.getStatus(orgid, skssqq, skssqz);
                }
                new XFSStatusService().setDeclaretype(customParams.get("templatetype").toString()).getStatus(orgid, skssqq, skssqz);
            }
            catch (Throwable t) {
                LOGGER.error(t);
            }
        }
        return "0";
    }

    public static void resetParentSteps(int steps, String focusPage, String status, IFormView view) {
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            return;
        }
        DeclareStepsUtils.resetSteps(steps, focusPage, status, parentView);
        view.sendFormAction(parentView);
    }

    public static void resetSteps(int steps, String focusPage, String status, IFormView view) {
        for (int step = 1; step <= steps; ++step) {
            DeclareStepsUtils.setStepStyle(status, focusPage, view, step);
            DeclareStepsUtils.setStatueStyle(status, view, step);
            DeclareStepsUtils.setProcess(status, view, step);
        }
    }

    private static void setStepStyle(String status, String focusPage, IFormView view, int step) {
        HashMap<String, String> colorMap = new HashMap<String, String>();
        String stepColor = "#CCCCCC";
        String stepFontWeight = "normal";
        if (Integer.parseInt(status) >= step) {
            stepColor = "themeColor";
        }
        if (Integer.parseInt(focusPage) == step) {
            stepFontWeight = "bold";
        }
        colorMap.put("fc", stepColor);
        colorMap.put("fw", stepFontWeight);
        view.updateControlMetadata("step" + step, colorMap);
    }

    private static void setStatueStyle(String status, IFormView view, int step) {
        String statusColor = "#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            statusColor = "themeColor";
        }
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("fc", statusColor);
        view.updateControlMetadata("status" + step, colorMap);
    }

    private static void setProcess(String status, IFormView view, int step) {
        HashMap propertiesMap = new HashMap();
        HashMap style = new HashMap();
        String linestyle = "1px_dashed_#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            linestyle = "1px_solid_#CCCCCC";
        }
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("t", linestyle);
        style.put("b", border);
        propertiesMap.put("s", style);
        view.updateControlMetadata("process" + step, propertiesMap);
    }
}

