/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class NsrxxValidatorUtils {
    public static void nsrxxReviewed(Long orgId) {
        TaxResult taxcMainByOrgIdAndIsTaxpayer = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgId);
        if (!ObjectUtils.isEmpty((Object)taxcMainByOrgIdAndIsTaxpayer) && TaxcErrorCode.TAXC_BILLSTATUS_CODE.getCode().equalsIgnoreCase(taxcMainByOrgIdAndIsTaxpayer.getCode())) {
            ErrorCode errorCode = new ErrorCode("nsrxxReviewed", taxcMainByOrgIdAndIsTaxpayer.getMessage());
            throw new KDBizException(errorCode, new Object[0]);
        }
    }

    public static void allRequiredFieldValidator(String orgId) {
        DynamicObject taxMain;
        if (StringUtils.isNotBlank((CharSequence)orgId) && (taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData()) != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            String orgname = taxorg.getString("org.name");
            String taxoffice = taxMain.getString("taxoffice.id");
            String registertype = taxMain.getString("registertype.id");
            String registertime = taxMain.getString("registertime");
            String registeraddress = taxMain.getString("registeraddress");
            String codeandname = taxMain.getString("codeandname.id");
            String actualaddress = taxMain.getString("actualaddress");
            String admindivisionObject = taxMain.getString("accountingstandards.id");
            if (StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxDeclarePlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }
}

