/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PrepayStatusService
implements IStatusService {
    private static final String STATUS_ENTITY = "tcvat_project_account";

    @Override
    public String getStatusEntity() {
        return STATUS_ENTITY;
    }

    public String getStatus(String orgid, String startdate, String enddate, String projectid, String serialno) {
        QFilter q1 = null;
        QFilter q2 = null;
        QFilter q3 = null;
        QFilter q4 = null;
        QFilter q5 = null;
        if (null != startdate) {
            q1 = new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst(DateUtils.stringToDate(startdate)));
        }
        if (null != enddate) {
            q2 = new QFilter("enddate", "<=", (Object)DateUtils.getDayLast(DateUtils.stringToDate(enddate)));
        }
        if (!StringUtil.isEmpty((CharSequence)orgid)) {
            q3 = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        }
        if (!StringUtil.isEmpty((CharSequence)projectid)) {
            q4 = new QFilter("projectid", "=", (Object)Long.parseLong(projectid));
        }
        if (!StringUtil.isEmpty((CharSequence)serialno)) {
            q5 = new QFilter("declareserialno", "=", (Object)serialno);
        }
        if (null == q1 && null == q2 && null == q3 && null == q4) {
            return null;
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)this.getStatusEntity(), (String)"id,status", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        String status = "0";
        if (object != null && StringUtil.isNotBlank((CharSequence)object.getString("status"))) {
            status = object.getString("status");
        }
        return status;
    }

    @Override
    public void updateStatus(String orgid, String startdate, String enddate, String status, String projectid, String serialno) {
        QFilter q1 = new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst(DateUtils.stringToDate(startdate)));
        QFilter q2 = new QFilter("enddate", "<=", (Object)DateUtils.getDayLast(DateUtils.stringToDate(enddate)));
        QFilter q3 = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter q4 = new QFilter("projectid", "=", (Object)Long.parseLong(projectid));
        QFilter q5 = new QFilter("declareserialno", "=", (Object)serialno);
        DynamicObject temp = QueryServiceHelper.queryOne((String)this.getStatusEntity(), (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        if (temp != null) {
            String id = temp.getString("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getStatusEntity());
            object.set("status", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    public void delete(String orgid, String startdate, String enddate, String projectid, String serialno) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter startFilter = new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst(DateUtils.stringToDate(startdate)));
        QFilter endFilter = new QFilter("startdate", "<=", (Object)DateUtils.getDayLast(DateUtils.stringToDate(enddate)));
        QFilter q4 = new QFilter("projectid", "=", (Object)Long.parseLong(projectid));
        QFilter q5 = new QFilter("declareserialno", "=", (Object)serialno);
        DeleteServiceHelper.delete((String)this.getStatusEntity(), (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, q4, q5});
    }
}

