/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.draft;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class DraftConstant {
    public static final String DRAFT_PURPOSE_SJJT = "sjjt";
    public static final String DRAFT_PURPOSE_NSSB = "nssb";
    public static final String DRAFT_ENTITY = "tctb_draft_main";
    public static final String DRAFT_SJJT_ENTITY = "tpo_declare_main_tsd";
    private static final Map<String, String> TEMPLATETYPE_DRAFT_PREFIX_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String[]> TAX_DRAFT_TYPE_MAP = new LinkedHashMap<String, String[]>();
    public static final String DRAFT_TYPE_ZZS = "zzs";
    public static final String DRAFT_TYPE_QYSDSJB = "qysdsjb";
    public static final String DRAFT_TYPE_QYSDSNB = "qysdsnb";

    public static String getDraftNumberPrefix(String template) {
        return TEMPLATETYPE_DRAFT_PREFIX_MAP.get(template);
    }

    public static String getTaxByDraftType(String draftType) {
        for (Map.Entry<String, String[]> entry : TAX_DRAFT_TYPE_MAP.entrySet()) {
            if (!Arrays.asList((Object[])entry.getValue()).contains(draftType)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr", "VAT-WP01");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_sjjt", "VAT-WP01");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsxgmnsr", "VAT-WP02");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsxgmnsr_sjjt", "VAT-WP02");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_ybhz", "VAT-WP03");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_ybhz_sjjt", "VAT-WP03");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_yz_zjg", "VAT-WP04");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_yz_zjg_sjjt", "VAT-WP04");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_yz_fzjg", "VAT-WP05");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_yz_fzjg_Sjjt", "VAT-WP05");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_hz_zjg", "VAT-WP06");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_zzsybnsr_hz_zjg_sjjt", "VAT-WP06");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_yhs", "SD-WP01");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_xfs", "CCT-WP");
        TEMPLATETYPE_DRAFT_PREFIX_MAP.put("draft_xfsjypf", "CCT-WP");
        TAX_DRAFT_TYPE_MAP.put(DRAFT_TYPE_ZZS, new String[]{DRAFT_TYPE_ZZS});
        TAX_DRAFT_TYPE_MAP.put("qysds", new String[]{DRAFT_TYPE_QYSDSJB, DRAFT_TYPE_QYSDSNB});
    }
}

