/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.draft;

import java.util.HashMap;
import kd.bos.form.IFormView;

public class DraftStepsUtils {
    public static void resetParentSteps(int steps, String focusPage, String status, IFormView view) {
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            return;
        }
        DraftStepsUtils.resetSteps(steps, focusPage, status, parentView);
        view.sendFormAction(parentView);
    }

    public static void resetSteps(int steps, String focusPage, String status, IFormView view) {
        for (int step = 1; step <= steps; ++step) {
            DraftStepsUtils.setStepStyle(status, focusPage, view, step);
            DraftStepsUtils.setStatueStyle(status, view, step);
            DraftStepsUtils.setProcess(status, view, step);
        }
    }

    private static void setStepStyle(String status, String focusPage, IFormView view, int step) {
        HashMap<String, String> colorMap = new HashMap<String, String>();
        String stepColor = "#CCCCCC";
        String stepFontWeight = "normal";
        if (Integer.parseInt(status) >= step) {
            stepColor = "themeColor";
        }
        if (Integer.parseInt(focusPage) == step) {
            stepFontWeight = "bold";
        }
        colorMap.put("fc", stepColor);
        colorMap.put("fw", stepFontWeight);
        view.updateControlMetadata("step" + step, colorMap);
    }

    private static void setStatueStyle(String status, IFormView view, int step) {
        String statusColor = "#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            statusColor = "themeColor";
        }
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("fc", statusColor);
        view.updateControlMetadata("status" + step, colorMap);
    }

    private static void setProcess(String status, IFormView view, int step) {
        HashMap propertiesMap = new HashMap();
        HashMap style = new HashMap();
        String linestyle = "1px_dashed_#CCCCCC";
        if (Integer.parseInt(status) >= step) {
            linestyle = "1px_solid_#CCCCCC";
        }
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("t", linestyle);
        style.put("b", border);
        propertiesMap.put("s", style);
        view.updateControlMetadata("process" + step, propertiesMap);
    }
}

