/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQSender;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.TsdStatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class StatusUtils {
    private static Log logger = LogFactory.getLog(StatusUtils.class);
    public static final String ENTITY = "tctb_draft_main";
    public static final String SAVE_OPERATION_KEY = "savedraftstatus";
    public static final String STATUS_VAL0 = "0";
    public static final String STATUS_VAL1 = "1";
    public static final String STATUS_VAL2 = "2";
    public static final String STATUS_VAL3 = "3";
    public static final String STATUS_VAL4 = "4";
    public static final String STATUS_VAL5 = "5";
    public static final String STATUS_VAL6 = "6";
    public static final String STATUS_VAL7 = "7";

    public static DynamicObject createStatus(String templatetype, String orgid, String startdate, String enddate, String status, String draftpurpose, String accountorg) {
        if ("sjjt".equals(draftpurpose)) {
            return TsdStatusUtils.createStatus(templatetype, orgid, startdate, enddate, status, draftpurpose, accountorg);
        }
        List<QFilter> list = StatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        DynamicObject temp = QueryServiceHelper.queryOne((String)ENTITY, (String)"id", (QFilter[])list.toArray(new QFilter[0]));
        if (temp == null) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ENTITY);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            Date start = DateUtils.stringToDate(startdate);
            Date end = DateUtils.stringToDate(enddate);
            dynamicObject.set("startdate", (Object)start);
            dynamicObject.set("enddate", (Object)end);
            dynamicObject.set("deadline", (Object)DeclareUtils.convertDate2DeadLine(start, end));
            dynamicObject.set("org", (Object)Long.valueOf(orgid));
            dynamicObject.set("status", (Object)status);
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("templatetype", (Object)templatetype);
            dynamicObject.set("datasource", (Object)"hand");
            dynamicObject.set("ismodified", (Object)STATUS_VAL0);
            dynamicObject.set("drafttype", (Object)StatusUtils.getDrafttype(templatetype));
            if ("nssb".equals(draftpurpose)) {
                String declareBillno = StatusUtils.getDeclareBillno(orgid, startdate, enddate, templatetype);
                dynamicObject.set("sbbno", (Object)declareBillno);
                dynamicObject.set("isdeclare", (Object)(StringUtil.isEmpty((CharSequence)declareBillno) ? STATUS_VAL0 : STATUS_VAL1));
            }
            dynamicObject.set("draftpurpose", (Object)(StringUtils.isEmpty((CharSequence)draftpurpose) ? "nssb" : draftpurpose));
            dynamicObject.set("accountorg", (Object)(StringUtils.isEmpty((CharSequence)accountorg) || "null".equals(accountorg) ? 0L : Long.parseLong(accountorg)));
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
            OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (save.isSuccess()) {
                DraftMQSender.sendMQ(dynamicObject, start, end, DeclareMQType.DRAFT.name(), DeclareMQEvent.SAVE.name());
            }
            return dynamicObject;
        }
        return null;
    }

    private static String getDeclareBillno(String orgid, String startdate, String enddate, String templatetype) {
        String[] declareTemplate = StatusUtils.getDeclareTemplate(templatetype);
        if (declareTemplate == null) {
            return null;
        }
        DynamicObject declare = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid)), new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(startdate)), new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(enddate)), new QFilter("type", "in", (Object)declareTemplate)});
        if (declare == null) {
            return null;
        }
        return declare.getString("billno");
    }

    private static String[] getDeclareTemplate(String templatetype) {
        if ("draft_qysdsjb".equals(templatetype)) {
            return new String[]{"qysdsjb", "qysds_hdzs_jb"};
        }
        if ("draft_qysdsnb".equals(templatetype)) {
            return new String[]{"qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb"};
        }
        if ("draft_zzsybnsr".equals(templatetype)) {
            return new String[]{"zzsybnsr"};
        }
        if ("draft_zzsxgmnsr".equals(templatetype)) {
            return new String[]{"zzsxgmnsr"};
        }
        if ("draft_zzsybnsr_ybhz".equals(templatetype)) {
            return new String[]{"zzsybnsr_ybhz"};
        }
        return null;
    }

    private static String getDrafttype(String templatetype) {
        if ("draft_qysdsjb".equals(templatetype)) {
            return "qysdsjb";
        }
        if ("draft_qysdsnb".equals(templatetype)) {
            return "qysdsnb";
        }
        return "zzs";
    }

    public static void updateStatus(String templatetype, String orgid, String startdate, String enddate, String status, String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            TsdStatusUtils.updateStatus(templatetype, orgid, startdate, enddate, status, draftpurpose);
        } else {
            List<QFilter> list = StatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
            DynamicObject temp = QueryServiceHelper.queryOne((String)ENTITY, (String)"id", (QFilter[])list.toArray(new QFilter[0]));
            if (temp != null) {
                String id = temp.getString("id");
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY);
                object.set("status", (Object)status);
                DeclareServiceHelper.setAccrualPlanId(orgid, startdate, enddate, draftpurpose, object);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    public static String getStatus(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            return TsdStatusUtils.getStatus(templatetype, orgid, startdate, enddate, draftpurpose);
        }
        List<QFilter> list = StatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        DynamicObject object = QueryServiceHelper.queryOne((String)ENTITY, (String)"id,status", (QFilter[])list.toArray(new QFilter[0]));
        String status = STATUS_VAL1;
        if (object != null) {
            status = object.getString("status");
        }
        return status;
    }

    public static DynamicObject queryOne(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            return TsdStatusUtils.queryOne(templatetype, orgid, startdate, enddate, draftpurpose);
        }
        List<QFilter> list = StatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        return QueryServiceHelper.queryOne((String)ENTITY, (String)"id,billno,status,type,billstatus,jtnumber,accrualplan", (QFilter[])list.toArray(new QFilter[0]));
    }

    public static String getDraftNumber(String draftpurpose, String readNumber, String draftNumberPrefix, String draftType) {
        return readNumber.replaceAll("X", "sjjt".equals(draftpurpose) ? (TemplateTypeConstant.TCVAT_SJJT_TYPES.contains(draftType) ? "VATACCURE" : "EITACCURE") : draftNumberPrefix);
    }

    public static DynamicObject queryDeclareReport(String templatetype, String orgid, String startdate, String enddate) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "=", (Object)Long.valueOf(orgid)));
        list.add(new QFilter("type", "=", (Object)templatetype.replace("draft_", "")));
        list.add(new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(startdate)));
        list.add(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(enddate)));
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus", (QFilter[])list.toArray(new QFilter[0]));
    }

    public static void delete(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            TsdStatusUtils.delete(templatetype, orgid, startdate, enddate, draftpurpose);
        } else {
            List<QFilter> list = StatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)ENTITY, (QFilter[])list.toArray(new QFilter[0]), (String)"", (int)10000);
            if (EmptyCheckUtils.isNotEmpty(ids)) {
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY));
                DraftMQSender.sendMQ(Arrays.asList(load), DeclareMQType.DRAFT.name(), DeclareMQEvent.DELETE.name().toLowerCase());
                DeleteServiceHelper.delete((String)ENTITY, (QFilter[])list.toArray(new QFilter[0]));
            }
        }
    }

    public static void deleteDraftByTemplateType(TemplateEnum templateEnum, String orgid, String startdate, String enddate, String draftpurpose) {
        try {
            EngineHandler handler = EngineHandlerFactory.createHandler(templateEnum.getDeclareType());
            EngineModel engineModel = handler.getEngineModel(templateEnum.getDeclareType(), templateEnum.getDeclareType(), orgid, DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate), startdate, enddate);
            engineModel.addCustom("draftpurpose", draftpurpose);
            engineModel.addCustom("taxperiod", startdate.substring(0, 7));
            int diffMonth = DateUtils.getMonthDiff(DateUtils.stringToDate(enddate), DateUtils.stringToDate(startdate));
            engineModel.addCustom("deadLine", diffMonth == 0 ? "aysb" : "ajsb");
            engineModel.addCustom("skssqq", startdate);
            engineModel.addCustom("skssqz", enddate);
            engineModel.addCustom("taxPayerType", templateEnum.getDeclareType());
            handler.getEngineList().forEach(engine -> engine.deleteData(engineModel));
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage());
        }
    }

    private static List<QFilter> buildQFilters(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        String draftpurposePros = StringUtils.isEmpty((CharSequence)draftpurpose) ? "nssb" : draftpurpose;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("templatetype", "=", (Object)templatetype));
        list.add(new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startdate)));
        list.add(new QFilter("enddate", "=", (Object)DateUtils.stringToDate(enddate)));
        list.add(new QFilter("org", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)orgid) ? orgid : STATUS_VAL0)));
        list.add(new QFilter("draftpurpose", "=", (Object)draftpurposePros));
        return list;
    }
}

