/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.draft.fi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.RuleConfigEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BdAccountVO;
import org.apache.commons.collections.CollectionUtils;

public class GetGLBalanceCommonUtil {
    private static final Map<String, String> beginToEndMap = new HashMap<String, String>();
    private static final String GL_BALANCE = "gl_balance";
    private static final String TDM_BALANCE_NEW = "tdm_balance_new";
    private static final String GL_VOUCHER = "gl_voucher";
    private static final String TDM_RECORDING_VOUCHER_NEW = "tdm_recording_voucher_new";

    public static boolean tdmBalanceNew(String fieldsubname, String amountField) {
        if (!StringUtil.equals((CharSequence)TDM_BALANCE_NEW, (CharSequence)fieldsubname)) {
            return false;
        }
        return StringUtil.equals((CharSequence)"openingamount", (CharSequence)amountField) || StringUtil.equals((CharSequence)"openinglocalcurrency", (CharSequence)amountField) || StringUtil.equals((CharSequence)"closinglocalcurrency", (CharSequence)amountField) || StringUtil.equals((CharSequence)"closingamount", (CharSequence)amountField);
    }

    public static QFilter reBuildAccountFilter(QFilter conditionFilters) {
        QFilter[] recombine;
        QFilter filters = null;
        QFilter accountFilters = null;
        for (QFilter filter : recombine = conditionFilters.recombine()) {
            String property = filter.getProperty();
            if (property.startsWith("account.")) {
                GetGLBalanceCommonUtil.replaceAccount(filter);
                if (accountFilters != null) {
                    accountFilters.and(filter);
                    continue;
                }
                accountFilters = filter;
                continue;
            }
            if (filters != null) {
                filters.and(filter);
                continue;
            }
            filters = filter;
        }
        DynamicObjectCollection masterid = null;
        if (accountFilters != null) {
            masterid = QueryServiceHelper.query((String)"bd_accountview", (String)"masterid", (QFilter[])new QFilter[]{accountFilters});
        }
        if (filters != null && masterid != null && masterid.size() > 0) {
            filters.and("account", "in", (Object)masterid.stream().map(o -> o.get("masterid")).toArray());
        }
        return filters;
    }

    private static void replaceAccount(QFilter qFilter) {
        String property = qFilter.getProperty();
        if (property.startsWith("account.")) {
            qFilter.__setProperty(property.replaceAll("account\\.", ""));
        } else if ("account".equals(property)) {
            qFilter.__setProperty("id");
        }
        List nests = qFilter.getNests(true);
        if (CollectionUtils.isNotEmpty((Collection)nests)) {
            for (QFilter.QFilterNest nest : nests) {
                GetGLBalanceCommonUtil.replaceAccount(nest.getFilter());
            }
        }
    }

    public static boolean conditionCheck(String fieldsubname, String amountField) {
        if (!StringUtil.equals((CharSequence)GL_BALANCE, (CharSequence)fieldsubname)) {
            return false;
        }
        return StringUtil.equals((CharSequence)"beginlocal", (CharSequence)amountField) || StringUtil.equals((CharSequence)"beginqty", (CharSequence)amountField) || StringUtil.equals((CharSequence)"endlocal", (CharSequence)amountField) || StringUtil.equals((CharSequence)"endqty", (CharSequence)amountField);
    }

    public static DynamicObjectCollection queryAccountingList(String entryName, String selectFieldwithid, String amountField, String startDate, String endDate, List<QFilter> filterList) {
        if (StringUtil.startsWith((CharSequence)amountField, (CharSequence)"begin")) {
            return GetGLBalanceCommonUtil.getBeginAccountingByDate(entryName, selectFieldwithid, amountField, startDate, filterList);
        }
        if (StringUtil.startsWith((CharSequence)amountField, (CharSequence)"end")) {
            return GetGLBalanceCommonUtil.getEndAccountingByDate(entryName, selectFieldwithid, amountField, endDate, filterList);
        }
        return new DynamicObjectCollection();
    }

    public static DynamicObjectCollection queryAccountingList(String entryName, String selectFieldwithid, String advancedconf, String amountField, String startDate, String endDate, List<QFilter> filterList) {
        if (StringUtil.equals((CharSequence)RuleConfigEnum.TOBEGIN.getRuleConfigCode(), (CharSequence)advancedconf)) {
            return GetGLBalanceCommonUtil.getBeginAccountingByDate(entryName, selectFieldwithid, amountField, startDate, filterList);
        }
        if (StringUtil.equals((CharSequence)RuleConfigEnum.TOEND.getRuleConfigCode(), (CharSequence)advancedconf)) {
            return GetGLBalanceCommonUtil.getEndAccountingByDate(entryName, selectFieldwithid, amountField, endDate, filterList);
        }
        return new DynamicObjectCollection();
    }

    private static DynamicObjectCollection getBeginAccountingByDate(String entryName, String selectFieldwithid, String amountField, String queryDate, List<QFilter> filterList) {
        CopyOnWriteArrayList<QFilter> resultFilter = new CopyOnWriteArrayList<QFilter>(filterList);
        for (QFilter qFilter : resultFilter) {
            if ("period.begindate".equals(qFilter.getProperty()) && "<=".equals(qFilter.getCP())) {
                qFilter.__setProperty("endperiod.begindate");
                qFilter.__setCP(">");
                qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
                qFilter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(qFilter.getProperty()) || !">=".equals(qFilter.getCP())) continue;
            qFilter.__setProperty("period.enddate");
            qFilter.__setCP("=");
            qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
        }
        DynamicObjectCollection currentAccountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        for (QFilter filter : resultFilter) {
            if (!"period.enddate".equals(filter.getProperty()) || !"=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setCP("<");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
        }
        selectFieldwithid = selectFieldwithid.replace(amountField, beginToEndMap.get(amountField));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        currentAccountingList.addAll((Collection)dynamicObjectCollection);
        return currentAccountingList;
    }

    private static DynamicObjectCollection getEndAccountingByDate(String entryName, String selectFieldwithid, String amountField, String queryDate, List<QFilter> filterList) {
        CopyOnWriteArrayList<QFilter> resultFilter = new CopyOnWriteArrayList<QFilter>(filterList);
        for (QFilter filter : resultFilter) {
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("endperiod.begindate");
                filter.__setCP(">");
                filter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
        }
        DynamicObjectCollection accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        if (accountingList.size() > 0) {
            return accountingList;
        }
        return new DynamicObjectCollection();
    }

    public static QFilter parseQFilter(Long orgId, String table, QFilter filter, Map<String, BdAccountVO> fiBdAccountMaps) {
        if (filter == null) {
            return null;
        }
        QFilter result = filter;
        if (GL_BALANCE.equals(table)) {
            result = GetGLBalanceCommonUtil.reBuildQFilter(result, "account.number", fiBdAccountMaps);
        } else if (TDM_BALANCE_NEW.equals(table)) {
            result = filter;
        } else if (GL_VOUCHER.equals(table)) {
            result = GetGLBalanceCommonUtil.reBuildQFilter(result, "entries.account.number", fiBdAccountMaps);
        } else if (TDM_RECORDING_VOUCHER_NEW.equals(table)) {
            result = filter;
        }
        return result;
    }

    private static QFilter reBuildQFilter(QFilter result, String columnNumber, Map<String, BdAccountVO> fiBdAccountMaps) {
        ArrayList cps = Lists.newArrayList((Object[])new String[]{"=", "in", "IN"});
        QFilter[] recombine = result.recombine();
        ArrayList<String> numbers = new ArrayList<String>();
        QFilter newResult = null;
        for (QFilter qFilter : recombine) {
            String property = qFilter.getProperty();
            String cp = qFilter.getCP();
            if ("booktype.number".equals(property) && cps.contains(cp)) {
                numbers.addAll(GetGLBalanceCommonUtil.getValue(qFilter.getValue()));
                continue;
            }
            newResult = newResult == null ? qFilter : newResult.and(qFilter);
        }
        newResult = newResult == null ? new QFilter("booktype.id", "in", GetGLBalanceCommonUtil.getBookType(numbers)) : newResult.and(new QFilter("booktype.id", "in", GetGLBalanceCommonUtil.getBookType(numbers)));
        List targetFilters = Arrays.stream(newResult.recombine()).filter(s -> cps.contains(s.getCP()) && columnNumber.equals(s.getProperty())).collect(Collectors.toList());
        for (QFilter qFilter : targetFilters) {
            ArrayList newNumbers = new ArrayList();
            for (String number : GetGLBalanceCommonUtil.getValue(qFilter.getValue())) {
                Optional.ofNullable(fiBdAccountMaps.get(number)).map(s -> s.getChildNodes()).orElseGet(() -> new HashSet()).forEach(s -> newNumbers.add(s.getNumber()));
            }
            if (newNumbers.size() <= 0) continue;
            ArrayList<String> nums = new ArrayList<String>();
            for (QFilter filter : newResult.recombine()) {
                if (!filter.getProperty().equals(columnNumber)) continue;
                nums.addAll(GetGLBalanceCommonUtil.getValue(filter.getValue()));
            }
            if (nums == null || nums.size() <= 0) continue;
            newResult.setProperty(columnNumber);
            newResult.__setCP("in");
            nums.addAll(newNumbers);
            newResult.__setValue(nums);
        }
        return newResult;
    }

    private static List<Long> getBookType(List<String> numbers) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        if (query != null && query.size() > 0) {
            return query.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private static List<String> getValue(Object value) {
        List<String> numbers = new ArrayList<String>();
        if (value instanceof String) {
            numbers.add(value.toString());
        } else if (value instanceof List) {
            numbers = (List)value;
        }
        return numbers;
    }

    public static Map<String, BdAccountVO> create(Long orgid) {
        QFilter dataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgid);
        QFilter[] filters = new QFilter[]{dataFilter};
        DynamicObjectCollection load = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,longnumber,parent", (QFilter[])filters, (String)"number asc");
        ArrayList<BdAccountVO> list = new ArrayList<BdAccountVO>(16);
        for (DynamicObject s2 : load) {
            BdAccountVO vo = new BdAccountVO();
            vo.setId(s2.getLong("id"));
            vo.setNumber(s2.getString("number"));
            vo.setLongNumber(s2.getString("longnumber"));
            vo.setParentId(s2.getLong("parent"));
            list.add(vo);
        }
        return list.stream().map(s -> s.addChildNodes((BdAccountVO)s, (List<BdAccountVO>)list)).collect(Collectors.toMap(s -> s.getNumber(), s -> s, (k1, k2) -> k2));
    }

    static {
        beginToEndMap.put("beginlocal", "endlocal as beginlocal");
        beginToEndMap.put("beginqty", "endqty as beginqty");
        beginToEndMap.put("endlocal", "endlocal");
        beginToEndMap.put("endqty", "endqty");
    }
}

