/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;

public class PartitionSaveTask
extends Task<List<DynamicObject>> {
    private List<DynamicObject> list;

    public PartitionSaveTask(List<DynamicObject> list) {
        this.list = new ArrayList<DynamicObject>(list);
    }

    @Override
    public List<List<DynamicObject>> getValue() {
        return Lists.partition(this.list, (int)1000);
    }

    @Override
    public List<DynamicObject> executor(List<DynamicObject> ex) {
        DynamicObject[] objects = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                objects = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])ex.toArray(new DynamicObject[0]));
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
        return Arrays.asList(objects);
    }
}

