/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.opplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.StatusServiceFactory;
import kd.taxc.bdtaxr.common.taxdeclare.opplugin.DeclareQueryListOp;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareQueryListOldOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DeclareQueryListOp.class);
    private List<DynamicObject> successObj = Lists.newArrayList();

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            for (DynamicObject entity : this.successObj) {
                this.callElementFresh(entity);
            }
        }
    }

    private void callElementFresh(DynamicObject entity) {
        try {
            String templatetype = entity.getString("type");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            Date skssqq = entity.getDate("skssqq");
            Date skssqz = entity.getDate("skssqz");
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"EleAutoUpdate", (String)"executorElement", (Object[])new Object[]{orgId.toString(), DateUtils.format(skssqq), DateUtils.format(skssqq), DateUtils.format(skssqz), TableTypeMapTemplateTypeEnum.getEnumByTemplateType(templatetype).getTableType()});
            logger.info("\u8c03\u7528\u5143\u7d20\u5237\u65b0\u63a5\u53e3\u53c2\u6570 orgId\uff1a" + orgId + "-skssqq:" + skssqq + "-skssqz" + skssqz + "-type" + TableTypeMapTemplateTypeEnum.getEnumByTemplateType(templatetype).getTableType());
        }
        catch (Exception e1) {
            logger.error("\u8c03\u7528\u5143\u7d20\u5237\u65b0\u63a5\u53e3\u5931\u8d25\uff1a" + e1);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (DynamicObject entity : dataEntities) {
                try {
                    Object pkValue = entity.getPkValue();
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.billEntityType.getName());
                    String templatetype = declare.getString("type");
                    Long orgId = declare.getDynamicObject("org").getLong("id");
                    Date skssqq = declare.getDate("skssqq");
                    Date skssqz = declare.getDate("skssqz");
                    IStatusService service = StatusServiceFactory.getService(templatetype);
                    if (service != null) {
                        service.delete(orgId.toString(), DateUtils.format(skssqq), DateUtils.format(skssqz));
                    }
                    TemplateUtils.deleteReport(orgId, templatetype, skssqq, skssqz, null);
                    successObjs.add(entity);
                    this.successObj.add(declare);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u7533\u62a5\u6570\u636e\u5931\u8d25\u3002", (String)"DeclareQueryListOldOp_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_declare_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                }
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
    }
}

