/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.opplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQSender;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DraftQueryListOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DraftQueryListOp.class);
    private List<DynamicObject> successObj = Lists.newArrayList();
    private static final Set<String> OPERATEKEYS_TO_MQ = Sets.newHashSet((Object[])new String[]{DeclareMQEvent.AUDIT.name().toLowerCase(), DeclareMQEvent.UNSUBMIT.name().toLowerCase(), DeclareMQEvent.UNAUDIT.name().toLowerCase(), DeclareMQEvent.SUBMIT.name().toLowerCase()});

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("delete".equals(operateKey)) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getBillPkId(), (String)"tctb_draft_main");
                        String jtnumber = dynamicObject.getString("jtnumber");
                        if (jtnumber.length() > 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u91d1\u8ba1\u63d0\u5355\u5df2\u751f\u6210\uff0c\u4e0d\u53ef\u5220\u9664\u5e95\u7a3f\u3002", (String)"DraftQueryListOp_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]));
                            continue;
                        }
                        DynamicObject org = dynamicObject.getDynamicObject("org");
                        String drafttype = dynamicObject.getString("templatetype");
                        String declareType = TemplateEnum.getEnumByDraftType(drafttype).getDeclareType();
                        String skssqq = DateUtils.format(dynamicObject.getDate("startdate"));
                        String skssqz = DateUtils.format(dynamicObject.getDate("enddate"));
                        DynamicObject ybnsr = YbnsrService.queryYbnsr(org.getString("id"), declareType, skssqq, skssqz, Collections.emptyMap());
                        if (ybnsr == null) continue;
                        String billstatus = ybnsr.getString("billstatus");
                        if ("B".equals(billstatus)) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\uff0c\u6240\u5c5e\u7a0e\u671f\u3010%2$s\u81f3%3$s\u3011\u5bf9\u5e94\u7684\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u5e95\u7a3f\u4e0d\u652f\u6301\u5220\u9664", (String)"DraftQueryListOp_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz));
                            continue;
                        }
                        if (!"C".equals(billstatus)) continue;
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\uff0c\u6240\u5c5e\u7a0e\u671f\u3010%2$s\u81f3%3$s\u3011\u5bf9\u5e94\u7684\u7533\u62a5\u8868\u5df2\u5ba1\u6838\uff0c\u5e95\u7a3f\u4e0d\u652f\u6301\u5220\u9664", (String)"DraftQueryListOp_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz));
                    }
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            for (DynamicObject draft : this.successObj) {
                this.callElementFresh(draft);
            }
            DraftMQSender.sendMQ(this.successObj, DeclareMQType.DRAFT.name(), DeclareMQEvent.DELETE.name().toLowerCase());
            Set<Object> idSet = this.successObj.stream().map(a -> a.get("id")).collect(Collectors.toSet());
            new DraftService().deleteRiskItem("tctb_draft_main", idSet);
        }
        if (OPERATEKEYS_TO_MQ.contains(operationKey)) {
            List<Object> ids = Arrays.stream(e.getDataEntities()).map(a -> a.get("id")).collect(Collectors.toList());
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tctb_draft_main"));
            DraftMQSender.sendMQ(Arrays.asList(load), DeclareMQType.DRAFT.name(), operationKey);
        }
    }

    private void callElementFresh(DynamicObject draft) {
        try {
            String templatetype = draft.get("templatetype") instanceof DynamicObject ? draft.getString("templatetype.number") : draft.getString("templatetype");
            String orgId = draft.getDynamicObject("org").getString("id");
            String startdate = DateUtils.format(draft.getDate("startdate"));
            String enddate = DateUtils.format(draft.getDate("enddate"));
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"EleAutoUpdate", (String)"executorElement", (Object[])new Object[]{orgId, startdate, startdate, enddate, TableTypeMapTemplateTypeEnum.getEnumByTemplateType(templatetype).getTableType()});
            logger.info("\u8c03\u7528\u5143\u7d20\u5237\u65b0\u63a5\u53e3\u53c2\u6570 orgId\uff1a" + orgId + "-skssqq:" + startdate + "-skssqz" + enddate + "-templatetype" + templatetype);
        }
        catch (Exception e1) {
            logger.error("\u8c03\u7528\u5143\u7d20\u5237\u65b0\u63a5\u53e3\u5931\u8d25\uff1a" + e1);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (DynamicObject entity : dataEntities) {
                DynamicObject draft = null;
                try {
                    Object pkValue = entity.getPkValue();
                    draft = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tctb_draft_main");
                    String templatetype = draft.get("templatetype") instanceof DynamicObject ? draft.getString("templatetype.number") : draft.getString("templatetype");
                    String declareType = TemplateEnum.getEnumByDraftType(templatetype).getDeclareType();
                    EngineHandler handler = EngineHandlerFactory.createHandler(declareType);
                    List<IEngine> engineList = handler.getEngineList();
                    String orgId = draft.getDynamicObject("org").getString("id");
                    Date startdate = draft.getDate("startdate");
                    Date enddate = draft.getDate("enddate");
                    String draftpurpose = draft.getString("draftpurpose");
                    String skssqq = startdate != null ? DateUtils.format(draft.getDate("startdate")) : "1900-01-01";
                    String skssqz = enddate != null ? DateUtils.format(draft.getDate("enddate")) : "1900-01-31";
                    EngineModel engineModel = handler.getEngineModel(templatetype, declareType, orgId, startdate, enddate, skssqq, skssqz);
                    engineModel.addCustom("draftpurpose", draftpurpose);
                    if ("qysdsnb".equals(declareType)) {
                        engineModel.addCustom("remove_adjust_by_hand", true);
                    }
                    engineList.forEach(e -> e.deleteData(engineModel));
                    successObjs.add(entity);
                    this.successObj.add(draft);
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u5e95\u7a3f\u6570\u636e\u5931\u8d25\uff01", (String)"DraftQueryListOp_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_draft_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                }
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
    }

    protected EngineModel getEngineModel(String templatetype, String declareType, String orgId, Date startdate, Date enddate, String skssqq, String skssqz) {
        EngineModel engineModel = new EngineModel(orgId, skssqq, skssqz, templatetype, null);
        engineModel.getCustom().put("draftpurpose", "nssb");
        engineModel.getCustom().put("skssqq", skssqq);
        engineModel.getCustom().put("skssqz", skssqz);
        engineModel.getCustom().put("taxperiod", skssqq.substring(0, 7));
        engineModel.getCustom().put("deadline", startdate == null || enddate == null ? "" : DateUtils.getTaxLimit(startdate, enddate));
        engineModel.getCustom().put("taxPayerType", declareType);
        return engineModel;
    }
}

