/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.route;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.upgrade.UpdConstant;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxDeclareRouteHelper {
    private static final String STRING = "_";
    private static final String STRING1 = "#";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String ROUTENAME = "routename";
    private static final String ROUTETYPE = "routetype";
    private static final String CUSTOM_CAPTION = "customCaption";
    public static String ROUTE_ENTITY = "tpo_sbmodel_route_conf";
    public static String ROUTE_FORM = "bdtaxr_dyn_route_show";
    private static String MODEL_VERSION_TWO = "2.0";
    private static String MODEL_VERSION_THREE = "3.0";
    private static final String TWO_CELL_KEY_FORMAT = "%s#%s#%s";
    private static final String THREE_CELL_KEY_FORMAT = "%s#%s";
    private static final String MEMBER_KEY_FORMAT = "%s_%s";
    private static final String TPO_DECLARE_MAIN_TSC = "tpo_declare_main_tsc";

    public static String convertToTwoKey(String threeCellKey) {
        if (StringUtil.isNotEmpty((CharSequence)threeCellKey) && threeCellKey.contains(STRING1)) {
            if (threeCellKey.contains(TPO_DECLARE_MAIN_TSC)) {
                String[] split = threeCellKey.split(STRING1);
                if (split.length == 2) {
                    return String.format(TWO_CELL_KEY_FORMAT, TCVAT_NSRXX, "1", split[1]);
                }
            } else {
                String[] split = threeCellKey.split(STRING1);
                if (split.length == 2) {
                    String row = split[0];
                    String col = split[0];
                    int index = row.lastIndexOf(STRING);
                    int index1 = col.lastIndexOf(STRING);
                    if (index > -1 && index1 > -1) {
                        String xh = row.substring(index + 1);
                        String table = row.substring(0, index);
                        String fieldName = col.substring(index1 + 1);
                        return String.format(TWO_CELL_KEY_FORMAT, table, xh, fieldName);
                    }
                }
            }
        }
        throw new KDBizException("Parameter format is not correct, unable to transform");
    }

    public static String convertToThreeKey(String towCellKey) {
        if (StringUtil.isNotEmpty((CharSequence)towCellKey) && towCellKey.contains(STRING1)) {
            if (towCellKey.contains(TCVAT_NSRXX)) {
                String[] split = towCellKey.split(STRING1);
                if (split.length == 3) {
                    String colMember = UpdConstant.NSRXX_FIELD_MAP.get(split[2]);
                    return String.format(THREE_CELL_KEY_FORMAT, TPO_DECLARE_MAIN_TSC, colMember);
                }
            } else {
                String[] split = towCellKey.split(STRING1);
                if (split.length == 3) {
                    String table = split[0];
                    String rowMember = String.format(MEMBER_KEY_FORMAT, table, split[1]);
                    String colMember = String.format(MEMBER_KEY_FORMAT, table, split[2]);
                    return String.format(THREE_CELL_KEY_FORMAT, rowMember, colMember);
                }
            }
        }
        throw new KDBizException("Parameter format is not correct, unable to transform");
    }

    public static String getCurrentShowListMeta(String metaRouteName) {
        TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.valueOf(metaRouteName);
        if (metaRouteEnum != null) {
            String appid = metaRouteEnum.getAppid();
            String route = TaxDeclareRouteHelper.getDeclareRouteOfApp(appid);
            return route.equalsIgnoreCase(MODEL_VERSION_THREE) ? metaRouteEnum.getThreeListMetaEntity() : metaRouteEnum.getTwoListMetaEntity();
        }
        throw new KDBizException("The route of " + metaRouteName + " is not exist");
    }

    public static String getCurrentShowMeta(String metaRouteName) {
        TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.valueOf(metaRouteName);
        if (metaRouteEnum != null) {
            String appid = metaRouteEnum.getAppid();
            String route = TaxDeclareRouteHelper.getDeclareRouteOfApp(appid);
            return route.equalsIgnoreCase(MODEL_VERSION_THREE) ? metaRouteEnum.getThreeMetaEntity() : metaRouteEnum.getTwoMetaEntity();
        }
        throw new KDBizException("The route of " + metaRouteName + " is not exist");
    }

    public static void dynMenuClick(String appId, String checkedNodeID, IFormView view) {
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)checkedNodeID);
        if (menu != null && ROUTE_FORM.equalsIgnoreCase(menu.getFormId())) {
            String caption = menu.getName().getLocaleValue();
            String params = menu.getParams();
            HashMap customParams = JsonUtil.fromJson(params, HashMap.class);
            String routeName = (String)customParams.get(ROUTENAME);
            String routeType = (String)customParams.get(ROUTETYPE);
            if ("form".equalsIgnoreCase(routeType)) {
                String currentShowMeta = TaxDeclareRouteHelper.getCurrentShowMeta(routeName);
                customParams.put(CUSTOM_CAPTION, caption);
                TaxDeclareRouteHelper.openForm(currentShowMeta, view, appId, caption, customParams, false, routeName);
            } else if ("list".equalsIgnoreCase(routeType)) {
                String currentShowListMeta = TaxDeclareRouteHelper.getCurrentShowListMeta(routeName);
                TaxDeclareRouteHelper.openForm(currentShowListMeta, view, appId, caption, customParams, true, routeName);
            }
        }
    }

    public static String getDeclareRouteOfApp(String appid) {
        DynamicObject object = QueryServiceHelper.queryOne((String)ROUTE_ENTITY, (String)"taxappid,version", (QFilter[])new QFilter("taxappid", "=", (Object)appid).toArray());
        if (object != null) {
            String version = object.getString("version");
            return MODEL_VERSION_THREE.equalsIgnoreCase(version) ? MODEL_VERSION_THREE : MODEL_VERSION_TWO;
        }
        return MODEL_VERSION_TWO;
    }

    private static void openForm(String currentShowMeta, IFormView iFormView, String bizAppId, String caption, Map<String, Object> customParams, boolean isList, String routeName) {
        List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)bizAppId);
        Optional<AppMenuInfo> menuOptional = appMenuInfos.stream().filter(appMenuInfo -> ROUTE_FORM.equals(appMenuInfo.getFormId()) && appMenuInfo.getParams() != null && (isList && appMenuInfo.getParams().contains("\"routetype\":\"list\"") || !isList && appMenuInfo.getParams().contains("\"routetype\":\"form\"")) && appMenuInfo.getParams().contains("\"routename\":\"" + routeName + "\"")).findFirst();
        if (!menuOptional.isPresent()) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u83dc\u5355\u53c2\u6570\u914d\u7f6e\u9519\u8bef", (String)"TaxDeclareRouteHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        String menuId = menuOptional.get().getId();
        String appId = AppMetadataCache.getAppInfo((String)bizAppId).getAppId();
        IFormView mainView = iFormView.getMainView();
        String mainViewPageId = mainView.getPageId();
        String mainPageId = appId + mainViewPageId;
        String billPageId = menuId + mainViewPageId;
        if (null != mainView.getViewNoPlugin(billPageId)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("view", iFormView);
            hashMap.put("appname", caption);
            hashMap.put("formnumber", currentShowMeta);
            if (isList) {
                hashMap.put("parametertype", "ListShowParameter");
            } else {
                hashMap.put("parametertype", "FormShowParameter");
            }
            TaxDeclareRouteHelper.activatePage(billPageId, iFormView, hashMap);
        } else if (isList) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId("bos_list");
            listShowParameter.setBillFormId(currentShowMeta);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setHasRight(true);
            listShowParameter.setAppId(appId);
            listShowParameter.setParentPageId(mainPageId);
            listShowParameter.setCustomParams(customParams);
            listShowParameter.setCustomParam("billFormId", (Object)currentShowMeta);
            listShowParameter.setCustomParam("appid", (Object)appId);
            listShowParameter.setCustomParam("type", (Object)"list");
            listShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            listShowParameter.setPageId(billPageId);
            IFormView view = iFormView.getView(mainPageId);
            view.showForm((FormShowParameter)listShowParameter);
            iFormView.sendFormAction(view);
        } else {
            FormShowParameter param = new FormShowParameter();
            param.setFormId(currentShowMeta);
            if (customParams == null) {
                param.setCustomParams(new HashMap());
            } else {
                param.setCustomParams(customParams);
            }
            if (customParams != null && customParams.get(CUSTOM_CAPTION) != null) {
                param.setCaption((String)customParams.get(CUSTOM_CAPTION));
            }
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setHasRight(true);
            param.setAppId(appId);
            param.setParentPageId(mainPageId);
            param.setCustomParams(customParams);
            param.setCustomParam("billFormId", (Object)currentShowMeta);
            param.setCustomParam("appid", (Object)appId);
            param.setCustomParam("type", (Object)"list");
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setPageId(billPageId);
            IFormView view = iFormView.getView(mainPageId);
            view.showForm(param);
            iFormView.sendFormAction(view);
        }
    }

    private static void activatePage(String pageId, IFormView view, Map<String, Object> map) {
        IFormView childView = view.getViewNoPlugin(pageId);
        if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
            childView = view.getView(pageId);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                Map customParameters = (Map)map.get("customparameters");
                childView.getFormShowParameter().getCustomParams().remove("messageId");
                childView.getFormShowParameter().getCustomParams().remove("tabType");
                childView.getFormShowParameter().getCustomParams().remove("openPage");
                if (customParameters != null) {
                    if (customParameters.get("messageId") != null) {
                        childView.getFormShowParameter().setCustomParam("messageId", customParameters.get("messageId"));
                    }
                    if (customParameters.get("tabType") != null) {
                        childView.getFormShowParameter().setCustomParam("tabType", customParameters.get("tabType"));
                    }
                    if (customParameters.get("openPage") != null) {
                        childView.getFormShowParameter().setCustomParam("openPage", customParameters.get("openPage"));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55!", (String)"TaxDeclareRouteHelper_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }
}

