/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.ruleconfig;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.StandBookRuleEnum;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RuleTemplateFormNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String ENTRY_ENTITY_KEY = "entryentity";
    private static final Map<String, String> formToBillMap = new LinkedHashMap<String, String>();
    private static final Map<String, String[]> billEntitySuffix = new LinkedHashMap<String, String[]>();
    private static final String SIM_VATINVOICE = "1163062995127970816";
    private static final String SIM_VATINVOICE_ZJZT = "1835580761286481920";
    private static final String SIM_VATINVOICE_ZJZT_TAX = "1835580806685626454";
    private static final String SIM_VATINVOICE_TAX = "1163062995136359510";
    private static final String SIM_VATINVOICE_NUMBER = "sim_vatinvoice";
    private static final String[] ADVCONAPS = new String[]{"advconap", "advconap1", "advconap2"};
    private static final String[] DISABLEBUTTON = new String[]{"name", "item", "entryentity", "entryentity1", "entryentity2", "standingbooks"};
    private static final String[] INVISABLEBUTTON = new String[]{"bar_disable", "bar_save"};
    private static String[] FIELDS_NONULL = new String[]{"bizname", "table", "amountfield", "datadirection", "absolute", "datatype"};
    private static final String STANDINGBOOKS = "standingbooks";

    public void initialize() {
        String[] entitys;
        BasedataEdit standingbooks = (BasedataEdit)this.getControl(STANDINGBOOKS);
        standingbooks.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String parentform = this.getView().getFormShowParameter().getParentFormId();
        if (null != parentform && "tccit_tz_rule_query".equals(parentform)) {
            this.getView().setEnable(Boolean.valueOf(false), DISABLEBUTTON);
            this.getView().setVisible(Boolean.valueOf(false), INVISABLEBUTTON);
        }
        if ((entitys = this.getBillEntitys()) != null) {
            for (String entitySuffix : entitys) {
                BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield" + entitySuffix);
                amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                BasedataEdit tablefield = (BasedataEdit)this.getControl("table" + entitySuffix);
                tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    private String[] getBillEntitys() {
        String currentPage = this.getModel().getDataEntityType().getName();
        String entityName = formToBillMap.get(currentPage);
        return billEntitySuffix.get(entityName);
    }

    public void afterCreateNewData(EventObject e) {
        Object ruletype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        if (orgid != null) {
            this.getModel().setValue("org", orgid);
        }
        if (null == (ruletype = customParams.get("ruletype"))) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
        this.initBtnStatus(customParams);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruledetail = customParams.getOrDefault("ruledetail", "");
        if (StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy;
            String formId = ((BillModel)e.getSource()).getDataEntityType().getName();
            DynamicObject obj = DynamicObjectUtils.serializeToDataEntity(ruledetail, formId);
            String operateSource = customParams.getOrDefault("operateSource", "");
            if ("tpo_rule".equals(operateSource) && (iscopy = customParams.getOrDefault("iscopy", Boolean.FALSE)).booleanValue()) {
                String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)obj, (String)obj.getString("org.id"));
                obj.set("number", (Object)number);
                obj.set("ruletype", (Object)"private");
            }
            e.setDataEntity(obj);
        }
        this.initBtnStatus(customParams);
    }

    private void initBtnStatus(Map<String, Object> customParams) {
        String operation = (String)customParams.get("operateType");
        String ruledetail = (String)customParams.getOrDefault("ruledetail", "");
        if ("addSysRule".equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            if ("addSysRule".equals(operation)) {
                try {
                    this.getModel().setValue("ruletype", (Object)"private");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy = (Boolean)customParams.getOrDefault("iscopy", Boolean.FALSE);
            if (iscopy.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "saverule"});
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isBlank((CharSequence)ruledetail)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParams().get("orgid"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
    }

    public void afterBindData(EventObject e) {
        DynamicObject standingbooks = (DynamicObject)this.getModel().getValue(STANDINGBOOKS);
        if (standingbooks == null) {
            this.getView().setVisible(Boolean.FALSE, ADVCONAPS);
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        } else {
            String number = standingbooks.getString("number");
            this.showAdvconap(number, "");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key;
            String entitySuffix = key = ((Donothing)args.getSource()).getOperateKey();
            if (!key.startsWith("setting") && !key.startsWith("setadvancedconf")) {
                return;
            }
            if (key.startsWith("setting")) {
                entitySuffix = entitySuffix.replace("setting", "");
            }
            if (key.startsWith("setadvancedconf")) {
                entitySuffix = entitySuffix.replace("setadvancedconf", "");
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormNewPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (args.getSource() instanceof Save) {
            DynamicObject standBookRule = (DynamicObject)this.getModel().getValue(STANDINGBOOKS);
            String number = standBookRule.getString("number");
            String entityName = StandBookRuleEnum.getEntryEntityByCode(number);
            String sufiix = StandBookRuleEnum.getSuffixByCode(number);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
            if (this.checkHasNullFields(entryEntity, sufiix)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u5f55\u5b57\u6bb5\u672a\u8fdb\u884c\u5f55\u5165\u3002", (String)"RuleTemplateFormNewPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("saverule".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject ruleObject = this.getModel().getDataEntity(true);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            RuleTemplateService.saveRule(ruleObject, customParams);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TemplatePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (!operateKey.startsWith("setting") && !operateKey.startsWith("setadvancedconf")) {
            return;
        }
        if (args.getOperationResult().isSuccess()) {
            String entitySuffix = operateKey.replace("setting", "").replace("setadvancedconf", "");
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
            String ischild = tabletype.getString("ischild");
            String entityNumber = tabletype.getString("name");
            if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                entityNumber = tabletype.getString("subname");
            }
            if (operateKey.startsWith("setting")) {
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY_KEY + entitySuffix, KEY_CONDITIONJSON + entitySuffix, "setting" + entitySuffix, entitySuffix);
            } else if (operateKey.startsWith("setadvancedconf")) {
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + entitySuffix, focusRow);
                long tableEntityId = tabletype.getLong("id");
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson" + entitySuffix, focusRow);
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, null, null);
                RuleTemplateService.operationConfigClick(advanceConfDto, args, entryentity, amountfield, (Long)tableEntityId, this.getView(), focusRow, ENTRY_ENTITY_KEY + entitySuffix, (IFormPlugin)this);
            }
        }
    }

    private boolean checkHasNullFields(DynamicObjectCollection entryEntity, String sufiix) {
        for (DynamicObject dynamicObject : entryEntity) {
            for (String s : FIELDS_NONULL) {
                if (dynamicObject.get(s + sufiix) != null) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        String entitySuffix;
        String key;
        super.closedCallBack(evt);
        if (evt.getActionId().startsWith("setting")) {
            key = evt.getActionId();
            entitySuffix = key.replace("setting", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                this.getModel().setValue(KEY_FILTERCONDITION + entitySuffix, filterData.get("filterdescription"), currentRowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + entitySuffix, filterData.get("filtervalue"), currentRowIndex);
            }
        }
        if (evt.getActionId().startsWith("setadvancedconf")) {
            key = evt.getActionId();
            entitySuffix = key.replace("setadvancedconf", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                this.getModel().setValue("advancedconf" + entitySuffix, filterData.get("advancedconf"), currentRowIndex);
                this.getModel().setValue("advancedconfjson" + entitySuffix, filterData.get("advancedconfjson"), currentRowIndex);
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId, String entitySuffix) {
        String ruleType;
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION + entitySuffix));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String string = ruleType = this.getModel().getDataEntityType().getProperties().containsKey((Object)"ruletype") ? (String)this.getModel().getValue("ruletype") : (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", (Object)ruleType);
        }
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"RuleTemplateFormNewPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        String currentPage = this.getModel().getDataEntityType().getName();
        String entityName = formToBillMap.get(currentPage);
        if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && Objects.equals(entityNumber, SIM_VATINVOICE_NUMBER) && Lists.newArrayList((Object[])new String[]{"1", "11"}).contains(entitySuffix)) {
            formshowParameter.setCustomParam("NO_SPECIAL", (Object)"true");
            formshowParameter.setCustomParam("NO_TAXRATE", (Object)"true");
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        if (evt.getProperty().getName().startsWith("amountfield")) {
            QFilter fieldFilter;
            key = evt.getProperty().getName();
            String suffix = key.replace("amountfield", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormNewPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String currentPage = this.getModel().getDataEntityType().getName();
            String entityName = formToBillMap.get(currentPage);
            if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            if (RuleTypeEnum.INCOME.getEntry().equals(entityName)) {
                DynamicObject taxation = (DynamicObject)this.getModel().getValue("taxation");
                if (null != taxation && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                    QFilter fieldFilter2 = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter2);
                }
                if (Lists.newArrayList((Object[])new String[]{"11", "3", "2"}).contains(suffix)) {
                    if (Objects.equals(tabletype.get("id"), Long.valueOf(SIM_VATINVOICE))) {
                        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)Long.parseLong(SIM_VATINVOICE_TAX)));
                    }
                    if (Objects.equals(tabletype.get("id"), Long.valueOf(SIM_VATINVOICE_ZJZT))) {
                        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)Long.parseLong(SIM_VATINVOICE_ZJZT_TAX)));
                    }
                }
            }
            if ("tdm_finance_main".equals(tabletype.get("entityName"))) {
                fieldFilter = new QFilter("fieldname", "!=", (Object)"sqje");
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
        }
        if (evt.getProperty().getName().startsWith("table")) {
            String formId;
            String ruleType;
            key = evt.getProperty().getName();
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            if (StringUtil.isNotBlank((CharSequence)(ruleType = RuleCodeEnum.getRuleType(formId = this.getView().getFormShowParameter().getFormId())))) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
        }
        if (STANDINGBOOKS.equals(evt.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("template", "=", (Object)"qysdstz"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (eventName.startsWith("table")) {
            String suffix = eventName.replace("table", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            this.getModel().setValue("amountfield" + suffix, null, rowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
            this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
        } else if (eventName.startsWith("amountfield")) {
            String suffix = eventName.replace("amountfield", "");
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = RuleTemplateFormNewPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = RuleTemplateFormNewPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + suffix, rowIndex);
            RuleTemplateService.setAdvanceConfDefaultValue(this.getModel(), rowIndex, tabletype, amountfield, "advancedconf" + suffix, "advancedconfjson" + suffix);
        } else if (STANDINGBOOKS.equals(eventName)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject oldValue = (DynamicObject)changeSet[0].getOldValue();
            String number = Optional.ofNullable((DynamicObject)this.getModel().getValue(STANDINGBOOKS)).map(standingbooks -> standingbooks.getString("number")).orElse(null);
            if (StringUtil.isEmpty((CharSequence)number)) {
                return;
            }
            String oldNumber = "";
            if (oldValue != null) {
                oldNumber = oldValue.getString("number");
            }
            this.showAdvconap(number, oldNumber);
            this.initData(number);
        }
    }

    private void showAdvconap(String number, String oldNumber) {
        if (StringUtils.isNotBlank((CharSequence)oldNumber)) {
            String entryEntityName = StandBookRuleEnum.getEntryEntityByCode(oldNumber);
            this.getModel().deleteEntryData(entryEntityName);
        }
        this.getView().setVisible(Boolean.FALSE, ADVCONAPS);
        String advconap = StandBookRuleEnum.getAdvconapByCode(number);
        this.getView().setVisible(Boolean.TRUE, new String[]{advconap});
        String name = StandBookRuleEnum.getAdvconapNameByCode(number);
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
        map.put("text", new LocaleString(name));
        this.getView().updateControlMetadata(advconap, map);
    }

    private void initData(String number) {
        String entryEntityName = StandBookRuleEnum.getEntryEntityByCode(number);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityName);
        int row = 0;
        if (entryEntity.size() == 0) {
            row = this.getModel().createNewEntryRow(entryEntityName);
        }
        this.getModel().setValue("name", (Object)new LocaleString(""));
        if (StandBookRuleEnum.TAKING.getStandBookCode().equals(number)) {
            String suffix = StandBookRuleEnum.getSuffixByCode(number);
            String name = ResManager.loadKDString((String)"\u8d44\u4ea7\u603b\u989d", (String)"RuleTemplateFormNewPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            String filter = ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u8d44\u4ea7\u603b\u8ba1  ", (String)"RuleTemplateFormNewPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue("bizname" + suffix, (Object)name, row);
            this.getModel().setValue("table" + suffix, (Object)"886815693662609408", row);
            this.getModel().setValue("amountfield" + suffix, (Object)"886815693662631947", row);
            this.getModel().setValue(KEY_FILTERCONDITION + suffix, (Object)filter, row);
            this.getModel().setValue(KEY_CONDITIONJSON + suffix, (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"41\",\"Id\":\"23+DJVBMEW0U\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u8d44\u4ea7\u603b\u8ba1\",\"Id\":\"23+DJVBMEZE2\"}],\"CompareType\":\"67\",\"Id\":\"23+DJVBMEW0T\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}", row);
        }
        if (StandBookRuleEnum.TOTALASSETS.getStandBookCode().equals(number)) {
            String name = ResManager.loadKDString((String)"\u8425\u4e1a\u6536\u5165", (String)"RuleTemplateFormNewPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            String filter = ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u8425\u4e1a\u6536\u5165  ", (String)"RuleTemplateFormNewPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue("bizname", (Object)name, row);
            this.getModel().setValue("table", (Object)"886814324742447104", row);
            this.getModel().setValue("amountfield", (Object)"886814324742469642", row);
            this.getModel().setValue(KEY_FILTERCONDITION, (Object)filter, row);
            this.getModel().setValue(KEY_CONDITIONJSON, (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"23+BLMC/R7R8\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u8425\u4e1a\u6536\u5165\",\"Id\":\"23+BLMC/RA3H\"}],\"CompareType\":\"67\",\"Id\":\"23+BLMC/R7R7\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}", row);
        }
    }

    private static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }

    private static List<String> getBizName() {
        return Arrays.asList(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91.\u51ed\u8bc1", (String)"RuleTemplateFormNewPlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d22\u52a1\u4e91.\u79d1\u76ee\u4f59\u989d\u8868", (String)"RuleTemplateFormNewPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51ed\u8bc1\u8868", (String)"RuleTemplateFormNewPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868", (String)"RuleTemplateFormNewPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    static {
        formToBillMap.put("tccit_standbook_rule_item", "tccit_standbook_rule_item");
        billEntitySuffix.put("tccit_standbook_rule_item", new String[]{"", "1", "2"});
    }
}

