/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.ruleconfig;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RuleTemplateNewMultiPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final List<String> ORG_NULLABLE_ENTITY_NAME_LIST = Arrays.asList("tcvvt_accessconfig", "tcvvt_tax_accessconfig", "tcvvt_qh_accessconfig", "itp_accessconfig", "gtcp_accessconfig", "tccit_profits_rule", "tccit_preferential_item", "tccit_other_rule");

    public void registerListener(EventObject e) {
        List items = ((Container)this.getControl("conentpanel")).getItems();
        List<EntryGrid> allEntryGrid = this.findAllEntryGrid(items);
        for (EntryGrid entryGrid : allEntryGrid) {
            BasedataEdit tablefield;
            String entryKey = entryGrid.getEntryKey();
            String entitySuffix = entryKey.replace(ENTRY_ENTITY, "");
            BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield" + entitySuffix);
            if (amountfield != null) {
                amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if ((tablefield = (BasedataEdit)this.getControl("table" + entitySuffix)) == null) continue;
            tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private List<EntryGrid> findAllEntryGrid(List<Control> items) {
        ArrayList<EntryGrid> result = new ArrayList<EntryGrid>(items.size());
        for (Control item : items) {
            if (item instanceof EntryGrid) {
                result.add((EntryGrid)item);
                continue;
            }
            if (!(item instanceof Container)) continue;
            List<EntryGrid> subEntryGrid = this.findAllEntryGrid(((Container)item).getItems());
            result.addAll(subEntryGrid);
        }
        return result;
    }

    public void afterBindData(EventObject e) {
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParams().get("orgid"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
    }

    public void afterCreateNewData(EventObject e) {
        Object ruletype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        if (!ObjectUtils.isEmpty(orgid)) {
            this.getModel().setValue("org", orgid);
        }
        if (null == (ruletype = customParams.get("ruletype"))) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
        this.initBtnStatus(customParams);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruledetail = customParams.getOrDefault("ruledetail", "");
        if (StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy;
            String formId = ((BillModel)e.getSource()).getDataEntityType().getName();
            DynamicObject obj = DynamicObjectUtils.serializeToDataEntity(ruledetail, formId);
            String operateSource = customParams.getOrDefault("operateSource", "");
            if ("tpo_rule".equals(operateSource) && (iscopy = customParams.getOrDefault("iscopy", Boolean.FALSE)).booleanValue()) {
                String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)obj, (String)obj.getString("org.id"));
                obj.set("number", (Object)number);
                obj.set("ruletype", (Object)"private");
            }
            e.setDataEntity(obj);
        }
        this.initBtnStatus(customParams);
    }

    private void initBtnStatus(Map<String, Object> customParams) {
        String operation = (String)customParams.get("operateType");
        String ruledetail = (String)customParams.getOrDefault("ruledetail", "");
        if ("addSysRule".equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            if ("addSysRule".equals(operation)) {
                try {
                    this.getModel().setValue("ruletype", (Object)"private");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy = (Boolean)customParams.getOrDefault("iscopy", Boolean.FALSE);
            if (iscopy.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "saverule"});
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isBlank((CharSequence)ruledetail)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!key.startsWith("setting") && !key.startsWith("setadvancedconf")) {
                return;
            }
            String entitySuffix = "";
            if (key.startsWith("setting")) {
                entitySuffix = key.replace("setting", "");
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                if (tabletype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateNewMultiPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (!(operateKey.startsWith("setting") || operateKey.startsWith("setadvancedconf") || operateKey.startsWith("saverule"))) {
            return;
        }
        if (args.getOperationResult().isSuccess()) {
            DynamicObject tabletype;
            EntryGrid entryentity;
            String entitySuffix;
            if ("saverule".equals(operateKey)) {
                DynamicObject ruleObject = this.getModel().getDataEntity(true);
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                RuleTemplateService.saveRule(ruleObject, customParams);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RuleTemplateNewMultiPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (operateKey.startsWith("setting")) {
                entitySuffix = operateKey.replace("setting", "");
                entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                if (tabletype != null) {
                    String ischild = tabletype.getString("ischild");
                    String entityNumber = tabletype.getString("name");
                    if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                        entityNumber = tabletype.getString("subname");
                    }
                    this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY + entitySuffix, KEY_CONDITIONJSON + entitySuffix, "setting" + entitySuffix, entitySuffix);
                }
            }
            if (operateKey.startsWith("setadvancedconf")) {
                entitySuffix = operateKey.replace("setadvancedconf", "");
                entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                Long tableEntityId = tabletype != null ? tabletype.getLong("id") : 0L;
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + entitySuffix, focusRow);
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson" + entitySuffix, focusRow);
                String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                BigDecimal jsbl = BigDecimal.ONE;
                BigDecimal yzvatrate = BigDecimal.ZERO;
                if (datatype.equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate" + entitySuffix, focusRow);
                } else if (datatype.equals("gjqs")) {
                    jsbl = (BigDecimal)this.getModel().getValue("jsbl" + entitySuffix, focusRow);
                } else if (datatype.equals("yjjsflqs")) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate" + entitySuffix, focusRow);
                    yzvatrate = (BigDecimal)this.getModel().getValue("yzvatrate" + entitySuffix, focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate, jsbl, yzvatrate);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson" + entitySuffix)) {
                    String exratejson = (String)this.getModel().getValue("exratejson" + entitySuffix, focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateService.operationConfigClick(advanceConfDto, args, entryentity, amountfield, tableEntityId, this.getView(), focusRow, ENTRY_ENTITY + entitySuffix, (IFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        String entitySuffix;
        super.closedCallBack(evt);
        if (evt.getActionId().startsWith("setting")) {
            entitySuffix = evt.getActionId().replace("setting", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY + entitySuffix);
                this.getModel().setValue(KEY_FILTERCONDITION + entitySuffix, filterData.get("filterdescription"), currentRowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + entitySuffix, filterData.get("filtervalue"), currentRowIndex);
            }
        }
        if (evt.getActionId().startsWith("setadvancedconf")) {
            entitySuffix = evt.getActionId().replace("setadvancedconf", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                Object datatype;
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY + entitySuffix);
                this.getModel().setValue("advancedconf" + entitySuffix, filterData.get("advancedconf"), currentRowIndex);
                this.getModel().setValue("advancedconfjson" + entitySuffix, filterData.get("advancedconfjson"), currentRowIndex);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson" + entitySuffix)) {
                    this.getModel().setValue("exratejson" + entitySuffix, filterData.get("convert_rate_json"), currentRowIndex);
                }
                if ((datatype = this.getModel().getValue("datatype" + entitySuffix, currentRowIndex)).equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                    this.getModel().setValue("vatrate" + entitySuffix, filterData.get("vatrate"), currentRowIndex);
                } else if (datatype.equals("gjqs")) {
                    this.getModel().setValue("jsbl" + entitySuffix, filterData.get("jsbl"), currentRowIndex);
                } else if (datatype.equals("yjjsflqs")) {
                    this.getModel().setValue("vatrate" + entitySuffix, filterData.get("vatrate"), currentRowIndex);
                    this.getModel().setValue("yzvatrate" + entitySuffix, filterData.get("yzvatrate"), currentRowIndex);
                }
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId, String entitySuffix) {
        String ruleType;
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION + entitySuffix));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String string = ruleType = this.getModel().getDataEntityType().getProperties().containsKey((Object)"ruletype") ? (String)this.getModel().getValue("ruletype") : (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (ORG_NULLABLE_ENTITY_NAME_LIST.contains(this.getView().getEntityId()) && org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"RuleTemplateNewMultiPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", (Object)ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (evt.getProperty().getName().startsWith("amountfield")) {
            String suffix = key.replace("amountfield", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(evt.getProperty().getParent().getName());
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateNewMultiPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
        }
        if (evt.getProperty().getName().startsWith("table")) {
            String formId;
            String ruleType;
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            if (StringUtil.isNotBlank((CharSequence)(ruleType = RuleCodeEnum.getRuleType(formId = this.getView().getFormShowParameter().getFormId())))) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (eventName.startsWith("table")) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            Long id = Optional.ofNullable((DynamicObject)newValue).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            String suffix = eventName.replace("table", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY + suffix);
            if (1772729236155684864L == id) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("entryentity.fieldname", "=", (Object)"value")};
                DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.id", (QFilter[])filters);
                this.getModel().setValue("amountfield" + suffix, (Object)object.getLong("entryentity.id"), rowIndex);
                this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getModel().setValue("amountfield" + suffix, null, rowIndex);
                this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
            }
        } else if (eventName.startsWith("amountfield")) {
            String suffix = eventName.replace("amountfield", "");
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY + suffix);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = RuleTemplateNewMultiPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = RuleTemplateNewMultiPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + suffix, rowIndex);
            RuleTemplateService.setAdvanceConfDefaultValue(this.getModel(), rowIndex, tabletype, amountfield, "advancedconf" + suffix, "advancedconfjson" + suffix);
        } else if (eventName.startsWith("datatype")) {
            String suffix = eventName.replace("datatype", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY + suffix);
            BigDecimal vatrate = BigDecimal.ZERO;
            String datatype = (String)e.getChangeSet()[0].getNewValue();
            if (!("jsflqs".equals(datatype) || "cysldsqs".equals(datatype) || "sehshsj".equals(datatype))) {
                this.getModel().setValue("vatrate" + suffix, (Object)vatrate, rowIndex);
            }
        }
    }

    public static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }
}

