/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.ruleconfig;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDefaultDto;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RuleTemplateNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String[] DISABLEBUTTON = new String[]{"name", "item", "entryentity", "itemchoicename", "fs_baseinfo"};
    private static final String[] INVISABLEBUTTON = new String[]{"bar_disable", "bar_save"};
    private static final List<String> ORG_NULLABLE_ENTITY_NAME_LIST = Arrays.asList("tcvvt_accessconfig", "tcvvt_tax_accessconfig", "tcvvt_qh_accessconfig", "itp_accessconfig", "gtcp_accessconfig", "tccit_profits_rule", "tccit_preferential_item", "tccit_other_rule");

    public void initialize() {
        BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String parentform = this.getView().getFormShowParameter().getParentFormId();
        if ("tccit_yj_rule_query".equals(parentform)) {
            this.getView().setEnable(Boolean.valueOf(false), DISABLEBUTTON);
            this.getView().setVisible(Boolean.valueOf(false), INVISABLEBUTTON);
        } else if ("tcret_house_rule_configs".equals(parentform)) {
            BasedataEdit item = (BasedataEdit)this.getControl("leasecontractno");
            item.setMustInput(true);
            item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        } else if ("tcret_house_rule_conf_inh".equals(parentform)) {
            BasedataProp leasecontractno = (BasedataProp)this.getModel().getProperty("leasecontractno");
            leasecontractno.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"leasecontractno"});
        }
        BasedataEdit tablefield = (BasedataEdit)this.getControl("table");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        String ruletype = (String)this.getModel().getValue("ruletype");
        if ("tcret_rule_fcczzj".equals(formId) && "public".equals(ruletype)) {
            BasedataProp leasecontractno = (BasedataProp)this.getModel().getProperty("leasecontractno");
            leasecontractno.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"leasecontractno"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParams().get("orgid"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
    }

    public void afterCreateNewData(EventObject e) {
        Object ruletype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        if (!ObjectUtils.isEmpty(orgid)) {
            this.getModel().setValue("org", orgid);
        }
        if (null == (ruletype = customParams.get("ruletype"))) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
        this.initBtnStatus(customParams);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruledetail = customParams.getOrDefault("ruledetail", "");
        if (StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy;
            String formId = ((BillModel)e.getSource()).getDataEntityType().getName();
            DynamicObject obj = DynamicObjectUtils.serializeToDataEntity(ruledetail, formId);
            String operateSource = customParams.getOrDefault("operateSource", "");
            if ("tpo_rule".equals(operateSource) && (iscopy = customParams.getOrDefault("iscopy", Boolean.FALSE)).booleanValue()) {
                String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)obj, (String)obj.getString("org.id"));
                obj.set("number", (Object)number);
                obj.set("ruletype", (Object)"private");
            }
            e.setDataEntity(obj);
        }
        this.initBtnStatus(customParams);
    }

    private void initBtnStatus(Map<String, Object> customParams) {
        String operation = (String)customParams.get("operateType");
        String ruledetail = (String)customParams.getOrDefault("ruledetail", "");
        if ("addSysRule".equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            if ("addSysRule".equals(operation)) {
                try {
                    this.getModel().setValue("ruletype", (Object)"private");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy = (Boolean)customParams.getOrDefault("iscopy", Boolean.FALSE);
            if (iscopy.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "saverule"});
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isBlank((CharSequence)ruledetail)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!"setting".equals(key) && !"setadvancedconf".equals(key)) {
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateNewPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (!("setting".equals(operateKey) || "setadvancedconf".equals(operateKey) || "saverule".equals(operateKey))) {
            return;
        }
        if (args.getOperationResult().isSuccess()) {
            if (operateKey.equals("saverule")) {
                DynamicObject ruleObject = this.getModel().getDataEntity(true);
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                RuleTemplateService.saveRule(ruleObject, customParams);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TemplatePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table", focusRow);
            Long tableEntityId = tabletype.getLong("id");
            if ("setting".equals(operateKey)) {
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY, KEY_CONDITIONJSON, "setting");
            }
            if ("setadvancedconf".equals(operateKey)) {
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", focusRow);
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", focusRow);
                String datatype = (String)this.getModel().getValue("datatype", focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                BigDecimal jsbl = BigDecimal.ONE;
                BigDecimal yzvatrate = BigDecimal.ZERO;
                if (((Donothing)args.getSource()).getEntityId().equalsIgnoreCase("tcvvt_tax_accessconfig") || ((Donothing)args.getSource()).getEntityId().equalsIgnoreCase("tcvvt_qh_accessconfig")) {
                    jsbl = (BigDecimal)this.getModel().getValue("jsbl", focusRow);
                }
                if (datatype.equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                } else if (datatype.equals("gjqs")) {
                    jsbl = (BigDecimal)this.getModel().getValue("jsbl", focusRow);
                } else if (datatype.equals("yjjsflqs")) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                    yzvatrate = (BigDecimal)this.getModel().getValue("yzvatrate", focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate, jsbl, yzvatrate);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                    String exratejson = (String)this.getModel().getValue("exratejson", focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateService.operationConfigClick(advanceConfDto, args, entryentity, amountfield, tableEntityId, this.getView(), focusRow, ENTRY_ENTITY, (IFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        super.closedCallBack(evt);
        if ("setting".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(KEY_FILTERCONDITION, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, filterData.get("filtervalue"), currentRowIndex);
        }
        if ("setadvancedconf".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            Object datatype;
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue("advancedconf", filterData.get("advancedconf"), currentRowIndex);
            this.getModel().setValue("advancedconfjson", filterData.get("advancedconfjson"), currentRowIndex);
            if (("tcvvt_tax_accessconfig".equalsIgnoreCase(this.getView().getEntityId()) || "tcvvt_qh_accessconfig".equalsIgnoreCase(this.getView().getEntityId())) && filterData.get("jsbl") != null) {
                this.getModel().setValue("jsbl", filterData.get("jsbl"), currentRowIndex);
            }
            if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                this.getModel().setValue("exratejson", filterData.get("convert_rate_json"), currentRowIndex);
            }
            if ((datatype = this.getModel().getValue("datatype", currentRowIndex)).equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                this.getModel().setValue("vatrate", filterData.get("vatrate"), currentRowIndex);
            } else if (datatype.equals("gjqs")) {
                this.getModel().setValue("jsbl", filterData.get("jsbl"), currentRowIndex);
            } else if (datatype.equals("yjjsflqs")) {
                this.getModel().setValue("vatrate", filterData.get("vatrate"), currentRowIndex);
                this.getModel().setValue("yzvatrate", filterData.get("yzvatrate"), currentRowIndex);
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId) {
        String ruleType;
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String string = ruleType = this.getModel().getDataEntityType().getProperties().containsKey((Object)"ruletype") ? (String)this.getModel().getValue("ruletype") : (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (ORG_NULLABLE_ENTITY_NAME_LIST.contains(this.getView().getEntityId()) && org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"RuleTemplateNewPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", (Object)ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("leasecontractno".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(qFilter);
            evt.setCustomQFilters(filterList);
        } else {
            RuleTemplateService.setRuleConfig(evt, this.getModel(), this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (e.getProperty().getName().equals("table")) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            Long id = Optional.ofNullable((DynamicObject)newValue).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (1772729236155684864L == id) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("entryentity.fieldname", "=", (Object)"value")};
                DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.id", (QFilter[])filters);
                this.getModel().setValue("amountfield", (Object)object.getLong("entryentity.id"), rowIndex);
                this.getModel().setValue(KEY_FILTERCONDITION, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON, null, rowIndex);
                this.getModel().setValue("absolute", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getModel().setValue("amountfield", null, rowIndex);
                this.getModel().setValue(KEY_FILTERCONDITION, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON, null, rowIndex);
                this.getModel().setValue("absolute", (Object)Boolean.FALSE, rowIndex);
            }
        } else if ("amountfield".equals(eventName)) {
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = RuleTemplateNewPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = RuleTemplateNewPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute", (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute", (Object)Boolean.FALSE, rowIndex);
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table", rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", rowIndex);
            AdvanceConfDefaultDto dto = new AdvanceConfDefaultDto(this.getModel(), rowIndex, tabletype, amountfield, "advancedconf", "advancedconfjson");
            RuleTemplateService.setAdvanceConfDefaultValue(this.getModel(), rowIndex, tabletype, amountfield, "advancedconf", "advancedconfjson");
        } else if (eventName.equals("datatype")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            BigDecimal vatrate = BigDecimal.ZERO;
            String datatype = (String)e.getChangeSet()[0].getNewValue();
            if (!(datatype.equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj"))) {
                this.getModel().setValue("vatrate", (Object)vatrate, rowIndex);
            }
        }
    }

    public static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }
}

