/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxorg;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;

public class TaxOrgUtil {
    public static boolean isTaxAccount(Long orgid) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        return QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter});
    }

    public static String getUnifiedsocialcode(DynamicObject taxorg) {
        return TaxOrgUtil.getFieldValue(taxorg, "entry_unifiedsocialcode", TaxationsysMappingEnum.CHN.getId());
    }

    public static String getUnifiedsocialcodeByTaxSystem(DynamicObject taxorg, long taxSystem) {
        if (taxSystem == 0L) {
            taxSystem = TaxationsysMappingEnum.CHN.getId();
        }
        return TaxOrgUtil.getFieldValue(taxorg, "entry_unifiedsocialcode", taxSystem);
    }

    public static String getTaxpayer(DynamicObject taxorg) {
        return TaxOrgUtil.getFieldValue(taxorg, "entry_taxpayer", TaxationsysMappingEnum.CHN.getId());
    }

    public static String getTaxpayerByTaxSystem(DynamicObject taxorg, long taxSystem) {
        if (taxSystem == 0L) {
            taxSystem = TaxationsysMappingEnum.CHN.getId();
        }
        return TaxOrgUtil.getFieldValue(taxorg, "entry_taxpayer", taxSystem);
    }

    public static String getStatus(DynamicObject taxorg) {
        return TaxOrgUtil.getFieldValue(taxorg, "entry_status", TaxationsysMappingEnum.CHN.getId());
    }

    private static String getFieldValue(DynamicObject taxorg, String entryStatus, Long taxationsys) {
        Optional<DynamicObject> optional;
        if (taxorg != null && (optional = taxorg.getDynamicObjectCollection("entryentity").stream().filter(d -> d.getLong("entry_taxationsys.id") == taxationsys.longValue()).findFirst()).isPresent()) {
            return optional.get().getString(entryStatus);
        }
        return "";
    }
}

