/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxsource.delete;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.SourceRelationConstant;
import kd.taxc.bdtaxr.common.taxsource.delete.IDeleteService;

public class MappingDeleteService
implements IDeleteService {
    @Override
    public void deleteSourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        for (DynamicObject sourceRelation : sourceRelations) {
            String sourceEntity = sourceRelation.getString("source");
            String sbbIdField = sourceRelation.getString("mappingfield");
            DynamicObject[] sourceList = BusinessDataServiceHelper.load((String)sourceEntity, (String)sbbIdField, (QFilter[])new QFilter[]{new QFilter(sbbIdField, "=", (Object)sbbId)});
            Arrays.stream(sourceList).forEach(source -> source.set(sbbIdField, (Object)0L));
            SaveServiceHelper.save((DynamicObject[])sourceList);
            QFilter q1 = new QFilter("sbbid", "=", (Object)sbbId);
            QFilter q2 = new QFilter("taxsourcetype", "=", (Object)sourceEntity);
            DeleteServiceHelper.delete((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (QFilter[])new QFilter[]{q1, q2});
        }
    }

    @Override
    public void deleteTemporarySourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        this.deleteTemporarySourceData(sbbId, sourceRelations, null);
    }

    @Override
    public void deleteTemporarySourceData(Long sbbId, List<DynamicObject> sourceRelations, String excludeEntity) {
        for (DynamicObject sourceRelation : sourceRelations) {
            String sourceEntity = sourceRelation.getString("source");
            if (Objects.equals(excludeEntity, sourceEntity)) continue;
            QFilter q1 = new QFilter("sbbid", "=", (Object)sbbId);
            QFilter q2 = new QFilter("taxsourcetype", "=", (Object)sourceEntity);
            DeleteServiceHelper.delete((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (QFilter[])new QFilter[]{q1, q2});
        }
    }
}

