/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.tctb.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class PermissionUtils {
    public static HasPermOrgResult getAllPermOrgs(IFormView view) {
        return PermissionUtils.getAllPermOrgs(view, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllPermOrgs(String appNumber, String entityid, String perm) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return PermissionUtils.getAllPermOrgsByUserId(appNumber, entityid, perm, userId);
    }

    public static HasPermOrgResult getAllPermOrgsByUserId(String appNumber, String entityid, String perm, Long userId) {
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        userId = EmptyCheckUtils.isEmpty(userId) ? Long.valueOf(RequestContext.get().getUserId()) : userId;
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static Boolean getPermByUserIdOrg(Long orgid, Long userId, String appid, String entityid, String perm) {
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return Boolean.TRUE;
        }
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        for (Long hasPermOrg : hasPermOrgs) {
            if (!Objects.equals(hasPermOrg, orgid)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        String entityid = view.getEntityId();
        if (view instanceof ListView) {
            entityid = ((ListView)view).getBillFormId();
        }
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String entityId, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityId, (String)perm);
        return hasPermOrgResult;
    }

    public static Long getDefaultOrgId() {
        Long orgId = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("id", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        TreeUtils.convertParam("id", orgId, map);
        TreeUtils.convertParam("status", "1", map);
        DynamicObjectCollection orgCollection = TreeUtils.queryOrgListByCondition(map);
        if (orgCollection != null && orgCollection.size() > 0) {
            return orgId;
        }
        DynamicObjectCollection orgCollection1 = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("status", "1"));
        if (orgCollection1 != null && orgCollection1.size() > 0) {
            return ((DynamicObject)orgCollection1.get(0)).getLong("id");
        }
        return 0L;
    }

    public static boolean hasSpecificPerm(IFormView view, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        String entityid = view.getEntityId();
        if (view instanceof ListView) {
            entityid = ((ListView)view).getBillFormId();
        }
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appid, (String)entityid, (String)perm);
    }

    public static void putTempFilePermissionCache(String url, String appid, String entityNum, String permissionItemId) {
        DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String tempFileId = url.split("id=")[1];
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entityNum);
        refEntitiyMap.put("appId", appid);
        refEntitiyMap.put("permissionItemId", permissionItemId);
        distributeCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }
}

