/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.threadpools;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.formula.context.Content;
import kd.taxc.bdtaxr.common.formula.db.formula.QueryFormulaService;
import kd.taxc.bdtaxr.common.formula.sql.SqlVo;
import kd.taxc.bdtaxr.common.formula.value.impl.AbstractGetValue;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class UnionSqlGetValue
extends AbstractGetValue {
    private static Log logger = LogFactory.getLog(UnionSqlGetValue.class);

    public UnionSqlGetValue(Content content) {
        super(content);
    }

    @Override
    public String getValue(Object sqls) {
        List list = (List)sqls;
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                sb.append(" /*dialect*/").append(((SqlVo)list.get(i)).toSql()).append(' ');
            } else {
                sb.append(" union all ").append(' ').append(((SqlVo)list.get(i)).toSql()).append(' ');
            }
            map.put(((SqlVo)list.get(i)).getMd5(), "0");
        }
        String sql = this.replaceFormula(sb.toString());
        List<Map<String, Object>> data = QueryFormulaService.queryUnion(sql);
        if (null != data) {
            for (Map.Entry entry : map.entrySet()) {
                this.getFormulaContext().getSqlValues().put((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map map2 : data) {
                for (Map.Entry value : map2.entrySet()) {
                    String key = (String)value.getKey();
                    String execSql = this.getSql(list, key);
                    String md5 = StringUtil.getMd5(execSql);
                    if (value.getValue() instanceof BigDecimal) {
                        this.getFormulaContext().getSqlValues().put(md5, DataFormatUtils.decimalFormat((BigDecimal)value.getValue()));
                        continue;
                    }
                    if (value.getValue() instanceof Double) {
                        this.getFormulaContext().getSqlValues().put(md5, DataFormatUtils.decimalFormat(BigDecimal.valueOf((Double)value.getValue())));
                        continue;
                    }
                    if (null != value.getValue()) {
                        this.getFormulaContext().getSqlValues().put(md5, value.getValue().toString());
                        continue;
                    }
                    this.getFormulaContext().getSqlValues().put(md5, "0");
                }
            }
        }
        return "";
    }

    private String getSql(List<SqlVo> list, String key) {
        for (SqlVo sqlVo : list) {
            if (!sqlVo.getMd5().equals(key)) continue;
            return this.replaceFormula(sqlVo.toExecSql());
        }
        return null;
    }
}

