/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.unittest;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class UnitTestDataPrepyFormPlugin
extends AbstractFormPlugin {
    private static final String UPGRADEBTN = "createcode";
    public static final char LF = '\n';

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{UPGRADEBTN});
    }

    public void click(EventObject evt) {
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        Object pkStr = this.getModel().getValue("entitynumber");
        Object entityNumber = this.getModel().getValue("idlist");
        String[] idArray = entityNumber.toString().split(",");
        List<Long> idList = Arrays.stream(idArray).map(i -> Long.valueOf(i)).collect(Collectors.toList());
        StringBuffer code = UnitTestDataPrepyFormPlugin.createDateByEntityeNumber(idList, pkStr.toString());
        codeSQLshow.setText(code.toString());
    }

    public static StringBuffer createDateByEntityeNumber(List<Long> pk, String entityeNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityeNumber);
        StringBuffer mainStringBuffer = new StringBuffer();
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            DynamicObject[] dbObjectCollection = BusinessDataServiceHelper.load((Object[])pk.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityeNumber));
            for (int i = 0; i < dbObjectCollection.length; ++i) {
                mainStringBuffer.append(String.format("DynamicObject mainObject%s = BusinessDataServiceHelper.newDynamicObject(\"%s\");", i, entityeNumber));
                mainStringBuffer.append('\n');
                StringBuffer subStringBuffer = new StringBuffer();
                for (IDataEntityProperty mainPro : mainPros) {
                    if (StringUtils.isEmpty((CharSequence)mainPro.getAlias())) {
                        if (!(mainPro instanceof EntryProp)) continue;
                        String objectname = mainPro.getName() + i;
                        subStringBuffer.append(String.format("DynamicObjectCollection %s = new DynamicObjectCollection();", objectname));
                        subStringBuffer.append('\n');
                        subStringBuffer.append(String.format("DynamicObjectCollection %sCollection = mainObject%s.getDynamicObjectCollection(\"%s\");", objectname, i, mainPro.getName()));
                        subStringBuffer.append('\n');
                        DynamicObjectCollection entryentityCollection = dbObjectCollection[i].getDynamicObjectCollection(mainPro.getName());
                        for (int j = 0; j < entryentityCollection.size(); ++j) {
                            subStringBuffer.append(String.format("DynamicObject  %s%s= %sCollection.addNew();", objectname, j, objectname));
                            subStringBuffer.append('\n');
                            for (IDataEntityProperty subProperty : ((DynamicObject)entryentityCollection.get(j)).getDataEntityType().getProperties()) {
                                if (StringUtils.isEmpty((CharSequence)subProperty.getAlias())) continue;
                                subStringBuffer.append(String.format("%s%s.set(", objectname, j));
                                subStringBuffer.append('\"');
                                subStringBuffer.append(subProperty.getName());
                                subStringBuffer.append('\"');
                                subStringBuffer.append(',');
                                subStringBuffer.append(UnitTestDataPrepyFormPlugin.buildValue(((DynamicObject)entryentityCollection.get(j)).get(subProperty.getName()), subProperty));
                                subStringBuffer.append(");");
                                subStringBuffer.append('\n');
                            }
                            subStringBuffer.append(String.format("%s.add(%s%s);", objectname, objectname, j));
                            subStringBuffer.append('\n');
                            subStringBuffer.append('\n');
                        }
                        continue;
                    }
                    Object value = dbObjectCollection[i].get(mainPro.getName());
                    if (value == null) {
                        // empty if block
                    }
                    mainStringBuffer.append(String.format("mainObject%s.set(", i));
                    mainStringBuffer.append('\"');
                    mainStringBuffer.append(mainPro.getName());
                    mainStringBuffer.append('\"');
                    mainStringBuffer.append(',');
                    mainStringBuffer.append(UnitTestDataPrepyFormPlugin.buildValue(value, mainPro));
                    mainStringBuffer.append(");");
                    mainStringBuffer.append('\n');
                }
                mainStringBuffer.append('\n');
                mainStringBuffer.append('\n');
                mainStringBuffer.append(subStringBuffer);
                mainStringBuffer.append(String.format("DynamicObject[] saveObject%s = (DynamicObject[]) SaveServiceHelper.save(new DynamicObject[]{mainObject%s});", i, i));
                mainStringBuffer.append('\n');
                mainStringBuffer.append('\n');
            }
            mainStringBuffer.append('\n');
        }
        return mainStringBuffer;
    }

    private static String buildValue(Object value, IDataEntityProperty mainPro) {
        StringBuilder stringBuilder = new StringBuilder();
        if (value == null) {
            stringBuilder.append("null");
        } else if (value instanceof Integer) {
            stringBuilder.append(value);
        } else if (value instanceof Long) {
            stringBuilder.append(value);
            stringBuilder.append('L');
        } else if (value instanceof BigDecimal) {
            stringBuilder.append("BigDecimal.valueOf(");
            stringBuilder.append(((BigDecimal)value).toPlainString());
            stringBuilder.append(")");
        } else if (value instanceof DynamicObject) {
            DynamicObject valueObj = (DynamicObject)value;
            stringBuilder.append(valueObj.get("id"));
            stringBuilder.append('L');
        } else if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            Date date = new Date(timestamp.getTime());
            String format = DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
            stringBuilder.append("DateUtils.stringToDate(");
            stringBuilder.append('\"');
            stringBuilder.append(format);
            stringBuilder.append('\"');
            stringBuilder.append(", DateUtils.YYYY_MM_DD_HH_MM_SS)");
        } else if (value instanceof String) {
            stringBuilder.append('\"');
            stringBuilder.append(value);
            stringBuilder.append('\"');
        } else {
            stringBuilder.append('\"');
            stringBuilder.append(value);
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }
}

