/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.unittest;

import java.util.List;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class UnitTestTemplateUtils {
    private static final String itemc_lick_tpl = "[{\"key\":\"%s\",\"methodName\":\"itemClick\",\"args\":[\"%s\",\"%s\"],\"postData\":[{},[]]}]";
    private static final String click_confirm_tpl = "[{\"key\":\"\",\"methodName\":\"afterConfirm\",\"args\":[\"%s\",6,\"%s\"],\"postData\":[{},[]]}]";
    private static final String click_cancel_tpl = "[{\"key\":\"\",\"methodName\":\"afterConfirm\",\"args\":[\"%s\",2,\"\"],\"postData\":[{},[]]}]";
    private static final String cancel_choseall_tpl = "[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[-1],\"postData\":[{\"billlistap\":{\"fieldKey\":\"%s\",\"row\":-1,\"selRows\":[],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[]}},[]]}]";
    private static final String update_value_tpl = "[{\"key\":\"\",\"methodName\":\"updateValue\",\"args\":[],\"postData\":[{},[{\"k\":\"%s\",\"v\":\"%s\",\"r\":%d}]]}]";
    private static final String load_data_tpl = "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]";
    private static final String select_tab_tpl = "[{\"key\":\"%s\",\"methodName\":\"selectTab\",\"args\":[\"%s\"],\"postData\":[{},[]]}]";
    private static final String entryRow_click_tpl = "[{\"key\":\"%s\",\"methodName\":\"entryRowClick\",\"args\":[%d],\"postData\":[{\"%s\":{\"fieldKey\":\"%s\",\"row\":%d,\"selRows\":[%d],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[%s]}},[]]}]";
    private static final String hyperLink_lick_tpl = "[{\"key\":\"%s\",\"methodName\":\"hyperLinkClick\",\"args\":[\"%s\",%d],\"postData\":[{},[]]}]";
    private static final String entryRowHyperLink_click_tpl = "[{\"key\":\"%s\",\"methodName\":\"entryRowClick\",\"args\":[%d],\"postData\":[{\"%s\":{\"fieldKey\":\"%s\",\"row\":%d,\"selRows\":[%d],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[%s]}},[]]},{\"key\":\"%s\",\"methodName\":\"hyperLinkClick\",\"args\":[\"%s\",%d],\"postData\":[{},[]]}]";
    private static final String close_tpl = "[{\"key\":\"\",\"methodName\":\"close\",\"args\":[],\"postData\":[{\"filtergridap\":[]},[]]}]";
    private static final String click_tpl = "[{\"key\":\"%s\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},%s]}]";
    private static final String release_tpl = "[{\"key\":\"\",\"methodName\":\"release\",\"args\":[{}],\"postData\":[]}]";
    private static final String update_basedata_tpl = "[{\"key\":\"%s\",\"methodName\":\"setItemByIdFromClient\",\"args\":[[\"%s\",%d]],\"postData\":[{},[]]}]";

    public static String release(AbstractJUnitTestPlugIn testPlugIn, String originAppid) {
        return testPlugIn.batchInvokeAction(originAppid, release_tpl);
    }

    public static String setItemByIdFromClient(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String fieldKey, String baseDataId) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(update_basedata_tpl, fieldKey, baseDataId, 0));
    }

    public static String setItemByIdFromClientSubEntity(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String fieldKey, String baseDataId) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(update_basedata_tpl, fieldKey, baseDataId, 1));
    }

    public static String click(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String btnKey) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(click_tpl, btnKey, "[]"));
    }

    public static String itemClickDefault(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String btnKey, String operateKey) {
        return UnitTestTemplateUtils.itemClickByKey(testPlugIn, originAppid, "toolbarap", btnKey, operateKey);
    }

    public static String itemClickNoOperateBillList(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String btnKey) {
        return UnitTestTemplateUtils.itemClickByKey(testPlugIn, originAppid, "toolbarap", btnKey, "");
    }

    public static String refreshBillList(AbstractJUnitTestPlugIn testPlugIn, String originAppid) {
        return UnitTestTemplateUtils.itemClickByKey(testPlugIn, originAppid, "toolbarap", "tblrefresh", "refresh");
    }

    public static String itemClickByKey(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String key, String btnKey, String operateKey) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(itemc_lick_tpl, key, btnKey, operateKey));
    }

    public static String afterConfirm(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String key) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(click_confirm_tpl, key, ""));
    }

    public static String afterConfirmWithCustomValue(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String key, String customeValue) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(click_confirm_tpl, key, customeValue));
    }

    public static String afterCancel(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String key) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(click_cancel_tpl, key));
    }

    public static String cancelChoseAll(AbstractJUnitTestPlugIn testPlugIn, String originAppid) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(cancel_choseall_tpl, "0"));
    }

    public static String updateValue(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String k, String v, int r) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(update_value_tpl, k, v, r));
    }

    public static String loadData(AbstractJUnitTestPlugIn testPlugIn, String originAppid) {
        return testPlugIn.batchInvokeAction(originAppid, load_data_tpl);
    }

    public static String selectTab(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String tabKey, String pageKey) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(select_tab_tpl, tabKey, pageKey));
    }

    public static String entryRowClick(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String listKey, String columnKey, int rowIndex) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(entryRow_click_tpl, listKey, rowIndex, listKey, columnKey, rowIndex, rowIndex, ""));
    }

    public static String entryRowClickWithSelData(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String listKey, String columnKey, int rowIndex, String selData) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(entryRow_click_tpl, listKey, rowIndex, listKey, columnKey, rowIndex, rowIndex, selData));
    }

    public static String entryRowhyperLinkClick(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String listKey, String columnKey, int rowIndex, String selData) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(entryRowHyperLink_click_tpl, listKey, rowIndex, listKey, columnKey, rowIndex, rowIndex, selData, listKey, columnKey, rowIndex));
    }

    public static String hyperLinkClick(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String listKey, String columnKey, int rowIndex) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(hyperLink_lick_tpl, listKey, columnKey, rowIndex));
    }

    public static String addEntry(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String superPanelKey, String btnKey, String operateKey) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(itemc_lick_tpl, superPanelKey, btnKey, operateKey));
    }

    public static String close(AbstractJUnitTestPlugIn testPlugIn, String originAppid) {
        return testPlugIn.batchInvokeAction(originAppid, close_tpl);
    }

    public static String clickWithPostData(AbstractJUnitTestPlugIn testPlugIn, String originAppid, String btnKey, List<PostDataItem> postItems) {
        return testPlugIn.batchInvokeAction(originAppid, String.format(click_tpl, btnKey, JsonUtil.toJson(postItems)));
    }

    public static class PostDataItem {
        private String k;
        private String v;
        private int r;

        public PostDataItem(String k, String v, int r) {
            this.k = k;
            this.v = v;
            this.r = r;
        }

        public String getK() {
            return this.k;
        }

        public void setK(String k) {
            this.k = k;
        }

        public String getV() {
            return this.v;
        }

        public void setV(String v) {
            this.v = v;
        }

        public int getR() {
            return this.r;
        }

        public void setR(int r) {
            this.r = r;
        }
    }
}

