/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractUpgradeFormPlugin
extends AbstractFormPlugin
implements IUpgradeService {
    private static final String UPGRADEBTN = "upatedata";
    protected static final String SUCCESS_INFO = AbstractUpgradeFormPlugin.getMsgA();
    protected static final String ERROR_INFO = AbstractUpgradeFormPlugin.getMsgB();
    protected static String TAXC = "taxc";
    protected static final String POINT = ".";
    protected static final String COMMA = ",";
    protected static final String ID = "id";
    protected static final char ENTER = '\n';
    protected String currentData = "";
    protected static int ERROR = 1;
    protected static int INFO = 2;
    protected StringBuilder logs = new StringBuilder();

    protected static String getMsgA() {
        return "DATA UPGRADE SUCCESSFUL!";
    }

    protected static String getMsgB() {
        return "DATA UPGRADE FAILURE!!!!";
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{UPGRADEBTN});
    }

    protected abstract IUpgradeService getService();

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (Objects.equals(UPGRADEBTN, source.getKey())) {
            UpgradeResult upgradeResult = this.getService().beforeExecuteSqlWithResult(null, null, null, null);
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
            if (StringUtil.isEmpty((CharSequence)upgradeResult.getErrorInfo())) {
                codeSQLshow.setText(upgradeResult.getLog());
            } else {
                codeSQLshow.setText(upgradeResult.getLog() + "\n" + upgradeResult.getErrorInfo());
            }
            this.getView().updateView();
        }
    }

    protected abstract Log getLogger();

    protected void addLog(int level, String info) {
        if (ERROR == level) {
            this.getLogger().error(info);
        } else {
            this.getLogger().info(info);
        }
        this.logs.append(info);
        this.logs.append('\n');
    }

    protected List<Long> getOrgList() {
        String orgSql = "select forgid from t_tctb_tax_main";
        try (DataSet OrgList = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)orgSql);){
            ArrayList<Long> OrgSumList = new ArrayList<Long>(500);
            while (OrgList.hasNext()) {
                Row row = OrgList.next();
                OrgSumList.add(row.getLong("FORGID"));
            }
            ArrayList<Long> arrayList = OrgSumList;
            return arrayList;
        }
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            return entityType != null;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    protected String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    protected void splitSave(List<DynamicObject> maindatas) {
        List partition = Lists.partition(maindatas, (int)200);
        for (List objectList : partition) {
            SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[objectList.size()]));
        }
    }

    protected void splitExecuteBatch(String sql, List<Object[]> params) {
        List partition = Lists.partition(params, (int)2000);
        for (List subList : partition) {
            DBUtils.executeBatch(sql, subList);
        }
    }
}

