/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.upgrade;

import kd.bos.logging.Log;
import kd.bos.service.upgrade.IUpgradeService;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public abstract class AbstractUpgradeService
implements IUpgradeService {
    protected static final String POINT = ".";
    protected static final String COMMA = ",";
    protected static final String ID = "id";
    protected static final char ENTER = '\n';
    protected String currentData = "";
    protected static int ERROR = 1;
    protected static int INFO = 2;
    protected StringBuilder logs = new StringBuilder();

    protected abstract Log getLogger();

    protected void addLog(int level, String info) {
        if (ERROR == level) {
            this.getLogger().error(info);
        } else {
            this.getLogger().info(info);
        }
        this.logs.append(info);
        this.logs.append('\n');
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById(entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    protected String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

