/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.lang.reflect.Field;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;

public class BeanMapUtils {
    public static <T> T mapToBean(Map<String, Object> map, Class<?> clazz) throws Exception {
        Object obj = clazz.newInstance();
        if (!CollectionUtils.isEmpty(map)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                Field field = BeanMapUtils.getClassField(clazz, propertyName);
                if (field == null) continue;
                Class<?> fieldTypeClass = field.getType();
                value = BeanMapUtils.convertValType(value, fieldTypeClass);
                try {
                    clazz.getMethod(setMethodName, field.getType()).invoke(obj, value);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        return (T)obj;
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        if (clazz.isAssignableFrom(Object.class)) {
            return null;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return BeanMapUtils.getClassField(superClass, fieldName);
        }
        return null;
    }

    private static Object convertValType(Object value, Class<?> fieldTypeClass) {
        Object retVal = null;
        retVal = fieldTypeClass.isAssignableFrom(Long.class) || fieldTypeClass.isAssignableFrom(Long.TYPE) ? Long.valueOf(Long.parseLong(value.toString())) : (fieldTypeClass.isAssignableFrom(Integer.class) || fieldTypeClass.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(Integer.parseInt(value.toString())) : (fieldTypeClass.isAssignableFrom(Float.class) || fieldTypeClass.isAssignableFrom(Float.TYPE) ? Float.valueOf(Float.parseFloat(value.toString())) : (fieldTypeClass.isAssignableFrom(Double.class) || fieldTypeClass.isAssignableFrom(Double.TYPE) ? Double.valueOf(Double.parseDouble(value.toString())) : value)));
        return retVal;
    }
}

