/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class CompareUtils {
    public static final Log logger = LogFactory.getLog(CompareUtils.class);

    public static boolean compare(Long templateId, Map<String, String> data1, Map<String, String> data2) {
        Map<String, String> metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId(templateId);
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntity(metaMap);
        Map<String, String> templateKeys = TemplateFormulaServiceHelper.getTemplateKeys(templateId);
        List<DynamicRowModel> dynRowSetList = DynamicRowService.getDynRowSetList(templateId);
        Map<String, DynamicRowModel> dynamicRowModelMap = dynRowSetList.stream().collect(Collectors.toMap(d -> d.getDynRowNo().split("#")[0], d -> d));
        Map<String, Set<String>> dynRowKeyIndexMap = CompareUtils.getDynRowKeyIndexMap(dynRowSetList, data1, data2);
        for (String key : templateKeys.keySet()) {
            String[] split = key.split("#");
            String entity = split[0];
            String ewbxlh = split[1];
            String field = split[2];
            EntityField entityField = entityFieldMap.get(key);
            if (CompareUtils.isDynRowKey(dynamicRowModelMap, entity, ewbxlh)) {
                if (!EmptyCheckUtils.isNotEmpty(dynRowKeyIndexMap.get(entity))) continue;
                for (String index : dynRowKeyIndexMap.get(entity)) {
                    String newKey = entity + "#" + index + "#" + field;
                    if (!CompareUtils.isDiff(newKey, data1, data2, entityField)) continue;
                    return false;
                }
                continue;
            }
            if (!CompareUtils.isDiff(key, data1, data2, entityField)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDynRowKey(Map<String, DynamicRowModel> dynamicRowModelMap, String entity, String ewbxlh) {
        try {
            return dynamicRowModelMap.get(entity) != null && Long.parseLong(ewbxlh) >= dynamicRowModelMap.get(entity).getStartRow();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Map<String, Set<String>> getDynRowKeyIndexMap(List<DynamicRowModel> dynRowSetList, Map<String, String> data, Map<String, String> data2) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (DynamicRowModel dynamicRowModel : dynRowSetList) {
            CompareUtils.addIndex(data, result, dynamicRowModel);
            CompareUtils.addIndex(data2, result, dynamicRowModel);
        }
        return result;
    }

    private static void addIndex(Map<String, String> data, Map<String, Set<String>> result, DynamicRowModel dynamicRowModel) {
        String[] dynRowNos = dynamicRowModel.getDynRowNo().split("#");
        String entity = dynRowNos[0];
        for (String key : data.keySet()) {
            try {
                String[] split = key.split("#");
                if (!split[0].equals(entity) || Long.parseLong(split[1]) < dynamicRowModel.getStartRow()) continue;
                Set set = result.computeIfAbsent(entity, k -> new HashSet());
                set.add(split[1]);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isDiff(String key, Map<String, String> data1, Map<String, String> data2, EntityField entityField) {
        boolean isEquals;
        String value1 = data1.getOrDefault(key, "");
        String value2 = data2.getOrDefault(key, "");
        if (entityField != null && ("Decimal".equals(entityField.getFieldType()) || "Double".equals(entityField.getFieldType()))) {
            BigDecimal decimal1 = BigDecimalUtil.toBigDecimal(value1.replaceAll("\\,", ""));
            BigDecimal decimal2 = BigDecimalUtil.toBigDecimal(value2.replaceAll("\\,", ""));
            isEquals = CompareUtils.accuracyCalibration(decimal1, decimal2);
        } else {
            isEquals = CompareUtils.equals(value1, value2);
        }
        if (!isEquals) {
            logger.info(String.format("\u6570\u636e\u6bd4\u5bf9\u5b58\u5728\u5dee\u5f02\u5b57\u6bb5\uff1a\u3010%1$s\u3011\uff0c\u8be5\u5b57\u6bb5\u7a0e\u5c40\u7684\u503c\u4e3a\u3010%2$s\u3011\uff0c\u7eb3\u7a0e\u7533\u62a5\u7684\u503c\u4e3a\u3010%3$s\u3011", key, data1.get(key), data2.get(key)));
            return true;
        }
        return false;
    }

    private static boolean equals(String value1, String value2) {
        boolean equals = Objects.equals(value1, value2);
        if (!equals) {
            return !(!EmptyCheckUtils.isEmpty(value1) && !"0".equals(value1) && !"0.00".equals(value1) || !EmptyCheckUtils.isEmpty(value2) && !"0".equals(value2) && !"0.00".equals(value2));
        }
        return true;
    }

    private static boolean accuracyCalibration(BigDecimal decimal1, BigDecimal decimal2) {
        String format1 = BigDecimalUtil.setScale(decimal1, 2).toString();
        String format2 = BigDecimalUtil.setScale(decimal2, 2).toString();
        return format1.equals(format2);
    }

    public static boolean judgeCellEqual(String para, String key) {
        String[] split;
        for (String str : split = key.split("#")) {
            if (para.contains(str)) continue;
            return false;
        }
        return true;
    }
}

