/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelUtils {
    private static Log logger = LogFactory.getLog(ExcelUtils.class);

    public static Workbook getWorkbook(InputStream inputStream) {
        Workbook hssfWorkbook;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            hssfWorkbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u6587\u4ef6", (String)"ExcelUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        return hssfWorkbook;
    }

    public static Map<String, String> readDataToMap(Workbook hssfWorkbook, Boolean includeBlank, IFormView view) {
        Iterator it = hssfWorkbook.sheetIterator();
        LinkedHashMap<String, String> excelDataMap = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            Sheet sheet = (Sheet)it.next();
            String sheetName = sheet.getSheetName();
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                for (Cell cell : row) {
                    String text;
                    String key;
                    block7: {
                        int columnIndex = cell.getColumnIndex();
                        key = sheetName.trim() + "#" + rowNum + "#" + columnIndex;
                        text = "";
                        DecimalFormat decimalFormat = null;
                        String kjsdsbgbExrate = ResManager.loadKDString((String)"\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u62a5\u544a\u8868#24#4", (String)"ExcelUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        if (Sets.newHashSet((Object[])new String[]{"A107041#11#8", "A107041#14#8", "A107041#32#8", kjsdsbgbExrate}).contains(key)) {
                            decimalFormat = new DecimalFormat("#####0.0000");
                        }
                        try {
                            text = ExcelUtils.getStringValueFromCell(cell, decimalFormat);
                        }
                        catch (Exception e) {
                            logger.error("\u7b2c{}\u884c\u7b2c{}\u5217\u5355\u5143\u683c\u6570\u636e\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (Object)(cell.getRowIndex() + 1), (Object)(cell.getColumnIndex() + 1));
                            if (view == null) break block7;
                            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7b2c%2$s\u5217\u5355\u5143\u683c\u6570\u636e\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"ExcelUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), cell.getRowIndex() + 1, cell.getColumnIndex() + 1));
                        }
                    }
                    if (includeBlank.booleanValue()) {
                        excelDataMap.put(key, text);
                        continue;
                    }
                    if (text == null || "".equals(text)) continue;
                    excelDataMap.put(key, text);
                }
            }
        }
        return excelDataMap;
    }

    public static String getStringValueFromCell(Cell cell, DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat("#.##########");
        }
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd");
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.STRING) {
            cellValue = cell.getRichStringCellValue().toString();
        } else if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                double d = cell.getNumericCellValue();
                Date date = DateUtil.getJavaDate((double)d);
                cellValue = sFormat.format(date);
            } else {
                cellValue = decimalFormat.format(cell.getNumericCellValue());
            }
        } else if (cellType == CellType.BLANK) {
            cellValue = "";
        } else if (cellType == CellType.BOOLEAN) {
            cellValue = String.valueOf(cell.getBooleanCellValue());
        } else if (cellType == CellType.ERROR) {
            cellValue = "";
        } else if (cellType == CellType.FORMULA) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                cellValue = sFormat.format(cell.getDateCellValue());
            } else {
                cellValue = String.valueOf(cell.getNumericCellValue());
                logger.info("\u5355\u5143\u683c\u516c\u5f0f\u7684\u503c\uff1a{}", (Object)cell.toString());
            }
        }
        return cellValue;
    }

    @Deprecated
    public static String getStringValueFromCell(Cell cell) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return ExcelUtils.getStringValueFromCell(cell, decimalFormat);
    }
}

