/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.refactor.rule.rulecal.filter.FilterAssistDto;
import kd.taxc.bdtaxr.common.refactor.rule.rulecal.filter.FilterDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.rule.RuleSettingUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FilterBuilderUtils {
    private static Log logger = LogFactory.getLog(FilterBuilderUtils.class);
    private static final String DYNAMIC = "dynamic";

    public static QFilter buildFilter(String conditionjson, String entryName) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public static QFilter getCustomQFilter(String entityNumber, String jsonStr) {
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)jsonStr, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filBuilder = new FilterBuilder(entityType, fc);
        filBuilder.buildFilter(false);
        return filBuilder.getFilterObject().getQFilter();
    }

    public static ConcurrentHashMap<String, List<QFilter>> buildFilterByFilterDto(ConcurrentHashMap<String, List<FilterDto>> dataSource2FilterDto, Map<String, Object> extendParams) {
        for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("orgid")) {
                try {
                    Long orgid = Long.parseLong(entry.getValue().toString());
                    extendParams.put(entry.getKey(), orgid);
                }
                catch (Exception e) {
                    logger.error("Illigal params:" + e);
                }
            }
            if (!entry.getKey().equalsIgnoreCase("startDate") && !entry.getKey().equalsIgnoreCase("endDate")) continue;
            try {
                Date time = DateUtils.stringToDate(entry.getValue().toString());
                extendParams.put(entry.getKey(), time);
            }
            catch (Exception e) {
                logger.error("Illigal params:" + e);
            }
        }
        ConcurrentHashMap<String, List<QFilter>> result = new ConcurrentHashMap<String, List<QFilter>>();
        for (Map.Entry<String, List<FilterDto>> entry : dataSource2FilterDto.entrySet()) {
            LinkedList<Object> filterStack = new LinkedList<Object>();
            for (FilterDto dto : entry.getValue()) {
                QFilter filter = FilterBuilderUtils.getFilter(dto, extendParams);
                if (null == filter) continue;
                String leftBracket = dto.getLeftBracket();
                if (!StringUtil.isEmpty((CharSequence)leftBracket)) {
                    int count = leftBracket.length();
                    while (count-- > 0) {
                        filterStack.push("(");
                    }
                }
                filterStack.push(new FilterAssistDto(filter, dto.getLogic()));
                String rightBracket = dto.getRightBracket();
                if (StringUtil.isEmpty((CharSequence)rightBracket)) continue;
                int count = rightBracket.length();
                while (count > 0 && !filterStack.isEmpty()) {
                    ArrayList<FilterAssistDto> filterAssistDtos = null;
                    if (filterStack.peek() instanceof FilterAssistDto) {
                        filterAssistDtos = new ArrayList<FilterAssistDto>(1);
                        filterAssistDtos.add(0, (FilterAssistDto)filterStack.pop());
                        continue;
                    }
                    if (filterAssistDtos != null) {
                        filterStack.pop();
                        int i = 0;
                        while (i + 1 < filterAssistDtos.size()) {
                            FilterAssistDto head = (FilterAssistDto)filterAssistDtos.get(i);
                            FilterAssistDto follow = (FilterAssistDto)filterAssistDtos.get(i + 1);
                            if ("0".equals(head.getLogic())) {
                                head.getqFilter().and(follow.getqFilter());
                            } else {
                                head.getqFilter().or(follow.getqFilter());
                            }
                            ++i;
                        }
                        ((FilterAssistDto)filterAssistDtos.get(0)).setLogic(((FilterAssistDto)filterAssistDtos.get(filterAssistDtos.size() - 1)).getLogic());
                        filterStack.push(filterAssistDtos.get(0));
                    }
                    --count;
                }
            }
            QFilter filter = FilterBuilderUtils.buildFilter(filterStack);
            if (null == filter) continue;
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(filter);
            result.put(entry.getKey(), list);
        }
        return result;
    }

    private static QFilter getFilter(FilterDto dto, Map<String, Object> extendParams) {
        String compareType;
        boolean isDynamic = false;
        if (StringUtil.isNotEmpty((CharSequence)dto.getValue().get(0)) && dto.getValue().get(0).startsWith("#")) {
            isDynamic = true;
            if (extendParams == null || null == extendParams.get(dto.getValue().get(0).substring(1))) {
                return null;
            }
        }
        QFilter temp = null;
        switch (compareType = dto.getConditonNumber()) {
            case "=": 
            case "!=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                temp = new QFilter(dto.getFieldNumber(), compareType, isDynamic ? extendParams.get(dto.getValue().get(0).substring(1)) : FilterBuilderUtils.getValue(dto));
                break;
            }
            case "is null": 
            case "is not null": {
                temp = new QFilter(dto.getFieldNumber(), compareType, null);
                break;
            }
            case "in": 
            case "not in": {
                temp = new QFilter(dto.getFieldNumber(), compareType, isDynamic ? extendParams.get(dto.getValue().get(0).substring(1)) : dto.getValue());
                break;
            }
            case "like": 
            case "not like": {
                temp = new QFilter(dto.getFieldNumber(), compareType, (Object)("%" + (isDynamic ? extendParams.get(dto.getValue().get(0).substring(1)) : dto.getValue().get(0)) + "%"));
                break;
            }
            case "start with": {
                temp = new QFilter(dto.getFieldNumber(), "like", isDynamic ? extendParams.get(dto.getValue().get(0).substring(1)) : dto.getValue().get(0) + "%");
                break;
            }
            case "end with": {
                temp = new QFilter(dto.getFieldNumber(), "like", (Object)("%" + (isDynamic ? extendParams.get(dto.getValue().get(0).substring(1)) : dto.getValue().get(0))));
                break;
            }
            case "subquery": {
                Object subQueryValue = RuleSettingUtils.getSubQueryValue(dto.getValue().get(0));
                temp = new QFilter(dto.getFieldNumber(), "in", subQueryValue);
            }
        }
        if (temp != null) {
            temp = MsqlQueryUtil.formatFieldValue(temp, MsqlQueryUtil.getFieldMap(dto.getDataSourceNumber()));
        }
        return temp;
    }

    private static Object getValue(FilterDto dto) {
        IDataEntityProperty iDataEntityProperty;
        String fieldNumber = dto.getFieldNumber();
        if (fieldNumber.contains(".")) {
            String[] split = fieldNumber.split("\\.");
            fieldNumber = split[split.length - 1];
        }
        return (iDataEntityProperty = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)dto.getDataSourceNumber()).getAllFields().get(fieldNumber)).getPropertyType().equals(BigDecimal.class) ? new BigDecimal(dto.getValue().get(0)) : dto.getValue().get(0);
    }

    private static QFilter buildFilter(Deque<Object> filterDeque) {
        LinkedList<FilterAssistDto> filterAssistDtos = new LinkedList<FilterAssistDto>();
        while (!filterDeque.isEmpty()) {
            Object obj = filterDeque.pop();
            if (!(obj instanceof FilterAssistDto)) continue;
            filterAssistDtos.add(0, (FilterAssistDto)obj);
        }
        int i = 0;
        while (i + 1 < filterAssistDtos.size()) {
            FilterAssistDto head = (FilterAssistDto)filterAssistDtos.get(i);
            FilterAssistDto follow = (FilterAssistDto)filterAssistDtos.get(i + 1);
            if ("0".equals(head.getLogic())) {
                head.getqFilter().and(follow.getqFilter());
            } else {
                head.getqFilter().or(follow.getqFilter());
            }
            ++i;
        }
        return filterAssistDtos.size() == 0 ? null : ((FilterAssistDto)filterAssistDtos.get(0)).getqFilter();
    }

    public static QFilter filterTextToQfilter(String billtype, String filterText) {
        if (StringUtils.isEmpty((CharSequence)filterText)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterText, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb.getQFilter();
    }
}

