/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class KdToolUtils {
    public static final List<Long> stringToLong(List<String> strList) {
        if (EmptyCheckUtils.isEmpty(strList)) {
            return new ArrayList<Long>();
        }
        return strList.stream().filter(v -> EmptyCheckUtils.isNotEmpty(v)).map(v -> Long.parseLong(v)).collect(Collectors.toList());
    }

    public static final List<Long> stringToLong(String[] strArr) {
        if (EmptyCheckUtils.isEmpty(strArr)) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(strArr).filter(v -> EmptyCheckUtils.isNotEmpty(v)).map(v -> Long.parseLong(v)).collect(Collectors.toList());
    }

    public static final LinkQueryPkIdCollection listToLinkQueryPkidColl(List<Long> pkids) {
        LinkQueryPkIdCollection linkQueryPkIds = new LinkQueryPkIdCollection();
        if (EmptyCheckUtils.isEmpty(pkids)) {
            linkQueryPkIds.add((Object)new LinkQueryPkId((Object)0));
            return linkQueryPkIds;
        }
        for (Long pkid : pkids) {
            linkQueryPkIds.add((Object)new LinkQueryPkId((Object)pkid));
        }
        return linkQueryPkIds;
    }

    public static DynamicObjectCollection customSortList(String field, List<String> sort, String sortField, DynamicObjectCollection collection) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashMap<String, Integer> sortOrder = new HashMap<String, Integer>(sort.size());
        for (int i = 0; i < sort.size(); ++i) {
            sortOrder.put(sort.get(i), i);
        }
        Map taxperiods = collection.stream().sorted(Comparator.comparing(col -> col.getString(sortField))).collect(Collectors.groupingBy(col -> col.getString(sortField), TreeMap::new, Collectors.toList()));
        for (Map.Entry entry : taxperiods.entrySet()) {
            Collections.sort((List)entry.getValue(), Comparator.comparing(obj -> (Integer)sortOrder.get(obj.getString(field))));
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }
}

