/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;

public class OperatorDialogUtils {
    public static void operateDialog(String type, String entityName, String operateName, String operateDescription) {
        CalendarTaxType valueByType = CalendarTaxType.getValueByType(type);
        if (null != valueByType) {
            String operateCode = valueByType.getOperatecode();
            OperatorDialogUtils.saveDialog(operateCode, entityName, operateName, operateDescription);
        }
    }

    public static void operateDialog(String type, String entityName, String operateName, String operateDescription, Long orgId) {
        CalendarTaxType valueByType = CalendarTaxType.getValueByType(type);
        if (null != valueByType) {
            String operateCode = valueByType.getOperatecode();
            OperatorDialogUtils.saveDialog(operateCode, entityName, operateName, operateDescription, orgId);
        }
    }

    public static void operateDialogByAppid(String appid, String entityName, String operateName, String operateDescription) {
        OperatorDialogUtils.saveDialog(appid, entityName, operateName, operateDescription);
    }

    private static void saveDialog(String appid, String entityName, String operateName, String operateDescription) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(appid);
        appLogInfo.setBizObjID(entityName);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        appLogInfo.setOpName(operateName);
        appLogInfo.setOpDescription(operateDescription);
        service.addLog(appLogInfo);
    }

    private static void saveDialog(String appid, String entityName, String operateName, String operateDescription, Long orgId) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(appid);
        appLogInfo.setBizObjID(entityName);
        appLogInfo.setOrgID(orgId);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        appLogInfo.setOpName(operateName);
        appLogInfo.setOpDescription(operateDescription);
        service.addLog(appLogInfo);
    }
}

