/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RuleConfigUtils {
    public static final String KEY_ORG = "orgstate";
    public static final String KEY_DATE = "datastate";
    public static final String KEY_YEAR = "yearstate";
    public static final String KEY_MONTH = "monthstate";

    public static ConcurrentHashMap<String, Map<String, String>> get(DynamicObject[] objects) {
        ConcurrentHashMap<String, Map<String, String>> result = new ConcurrentHashMap<String, Map<String, String>>();
        for (DynamicObject object : objects) {
            HashMap<String, String> fieldsMap = new HashMap<String, String>();
            for (DynamicObject dynamicObject : object.getDynamicObjectCollection("entryentity")) {
                if (dynamicObject.getBoolean(KEY_ORG)) {
                    fieldsMap.put(KEY_ORG, dynamicObject.getString("fieldname"));
                    continue;
                }
                if (dynamicObject.getBoolean(KEY_DATE)) {
                    fieldsMap.put(KEY_DATE, dynamicObject.getString("fieldname"));
                    continue;
                }
                if (dynamicObject.getBoolean(KEY_YEAR)) {
                    fieldsMap.put(KEY_YEAR, dynamicObject.getString("fieldname"));
                    continue;
                }
                if (!dynamicObject.getBoolean(KEY_MONTH)) continue;
                fieldsMap.put(KEY_MONTH, dynamicObject.getString("fieldname"));
            }
            result.put(object.getString("entityname"), fieldsMap);
        }
        return result;
    }

    public static Map<String, String> get(Long tableid) {
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)tableid, (String)"tctb_custom_datasource");
        HashMap<String, String> result = new HashMap<String, String>();
        for (DynamicObject dynamicObject : object.getDynamicObjectCollection("entryentity")) {
            String fieldname = dynamicObject.getString("fieldname");
            String fieldsubname = dynamicObject.getString("fieldsubname");
            String entityname = object.getString("entityname");
            if (!(StringUtils.equals((CharSequence)entityname, (CharSequence)fieldsubname) || "gl_balance".equals(entityname) || "gl_voucher".equals(entityname))) {
                fieldname = fieldsubname + "." + fieldname;
            }
            if (dynamicObject.getBoolean(KEY_ORG)) {
                result.put(KEY_ORG, fieldname);
                continue;
            }
            if (dynamicObject.getBoolean(KEY_DATE)) {
                result.put(KEY_DATE, fieldname);
                continue;
            }
            if (dynamicObject.getBoolean(KEY_YEAR)) {
                result.put(KEY_YEAR, fieldname);
                continue;
            }
            if (!dynamicObject.getBoolean(KEY_MONTH)) continue;
            result.put(KEY_MONTH, fieldname);
        }
        return result;
    }
}

