/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class RuleUtils {
    private static final Map<String, Integer> taxationOrderMap = new HashMap<String, Integer>();

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(Long orgid, List<Long> excludingRuleIds, RuleTypeEnum type, String taxpayertype, String rulePurpose) {
        Map<RuleTypeEnum, List<DynamicObject>> sharingAndOrgRules = RuleUtils.getSharingAndOrgRules(orgid, type, taxpayertype, rulePurpose);
        for (List<DynamicObject> objects : sharingAndOrgRules.values()) {
            objects.removeIf(next -> excludingRuleIds.contains(next.getLong("id")));
        }
        return sharingAndOrgRules;
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(Long orgid, Long excludingPlanId, RuleTypeEnum type, String taxpayertype, String rulePurpose) {
        return RuleUtils.getSharingAndOrgRules(Collections.singletonList(orgid), excludingPlanId, type, Boolean.FALSE, taxpayertype, rulePurpose);
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(Long orgid, RuleTypeEnum type, String taxpayertype, String rulePurpose) {
        return RuleUtils.getSharingAndOrgRules(Collections.singletonList(orgid), null, type, Boolean.FALSE, taxpayertype, rulePurpose);
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(List<Long> orgidList, RuleTypeEnum type, String taxpayertype, String rulePurpose) {
        return RuleUtils.getSharingAndOrgRules(orgidList, null, type, Boolean.FALSE, taxpayertype, rulePurpose);
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(List<Long> orgidList, Long excludingPlanId, RuleTypeEnum type, Boolean includingDisable, String taxpayertype, String rulePurpose) {
        ArrayList<QFilter> sbxPlanQfilters = new ArrayList<QFilter>(2);
        QFilter sharingorg = new QFilter("orgentity.orgid", "in", orgidList);
        QFilter sbxSharingorg = new QFilter("orgentity.org", "in", orgidList);
        sbxPlanQfilters.add(sbxSharingorg);
        if (excludingPlanId != null && excludingPlanId != 0L) {
            QFilter planIdFilter = new QFilter("id", "!=", (Object)excludingPlanId);
            sbxPlanQfilters.add(planIdFilter);
        }
        DynamicObjectCollection sbxShareplan = QueryServiceHelper.query((String)"tcvat_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
        ArrayList<QFilter> tzPlanQfilters = new ArrayList<QFilter>();
        QFilter tzSharingorg = new QFilter("orgentity.org", "in", orgidList);
        tzPlanQfilters.add(tzSharingorg);
        if (excludingPlanId != null && excludingPlanId != 0L) {
            QFilter planIdFilter = new QFilter("id", "!=", (Object)excludingPlanId);
            tzPlanQfilters.add(planIdFilter);
        }
        DynamicObjectCollection tzSharingRules = QueryServiceHelper.query((String)"tcvat_tz_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid", (QFilter[])tzPlanQfilters.toArray(new QFilter[0]));
        sbxShareplan.addAll((Collection)tzSharingRules);
        HashMap<String, List<Long>> rulePublicIdMap = new HashMap<String, List<Long>>();
        for (DynamicObject sharingRule : sbxShareplan) {
            String groupId = sharingRule.getString("groupid");
            RuleTypeEnum ruleTypeEnum = RuleTypeEnum.valueOfGroupId(groupId);
            List ids = rulePublicIdMap.computeIfAbsent(ruleTypeEnum.getName(), k -> new ArrayList());
            ids.add(sharingRule.getLong("ruleid"));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("org", "in", orgidList));
        filterList.add(new QFilter("ruletype", "=", (Object)"private"));
        if (taxpayertype != null) {
            filterList.add(new QFilter("taxpayertype", "=", (Object)taxpayertype));
        }
        if (!includingDisable.booleanValue()) {
            filterList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        HashMap<RuleTypeEnum, List<DynamicObject>> result = new HashMap<RuleTypeEnum, List<DynamicObject>>();
        if (RuleTypeEnum.ALL == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.INCOME, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.DEDUCT, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.JZJTSE, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.ROLL_OUT, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.DIFF, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.PERPRE, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.REDUCE, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
            RuleUtils.queryRulesByType(RuleTypeEnum.MDTS, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.INCOME == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.INCOME, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.DEDUCT == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.DEDUCT, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.JZJTSE == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.JZJTSE, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.ROLL_OUT == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.ROLL_OUT, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.DIFF == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.DIFF, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.REDUCE == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.REDUCE, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        } else if (RuleTypeEnum.APPORTION == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.APPORTION, includingDisable, rulePublicIdMap, filterList, result, "");
        } else if (RuleTypeEnum.WKPSR == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.WKPSR, includingDisable, rulePublicIdMap, filterList, result, "");
        } else if (RuleTypeEnum.REFUND == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.REFUND, includingDisable, rulePublicIdMap, filterList, result, "");
        }
        if (RuleTypeEnum.NCP_CPXM == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.NCP_CPXM, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        }
        if (RuleTypeEnum.NCPXM == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.NCPXM, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        }
        if (RuleTypeEnum.PERPRE == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.PERPRE, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        }
        if (RuleTypeEnum.MDTS == type) {
            RuleUtils.queryRulesByType(RuleTypeEnum.MDTS, includingDisable, rulePublicIdMap, filterList, result, rulePurpose);
        }
        if (taxpayertype != null) {
            result.values().stream().forEach(list -> list.removeIf(s -> !taxpayertype.equals(s.getString("taxpayertype"))));
        }
        return result;
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getJxdkOrgRules(RuleTypeEnum ruleType, Long orgId, Boolean includingDisable) {
        HashMap result = Maps.newHashMap();
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        RuleUtils.queryRulesByType(ruleType, includingDisable, Maps.newHashMap(), Collections.singletonList(filter), result, null);
        return result;
    }

    public static void queryRulesByType(RuleTypeEnum ruleType, Boolean includingDisable, Map<String, List<Long>> rulePublicIdMap, List<QFilter> filterList, Map<RuleTypeEnum, List<DynamicObject>> result, String rulePurpose) {
        List ids = rulePublicIdMap.getOrDefault(ruleType.getName(), new ArrayList());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ruleType.getEntry(), (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        List privateids = dynamicObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        ids.addAll(privateids);
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
        Object[] rulearray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ruleType.getEntry()));
        CollectionUtils.addAll(rules, (Object[])rulearray);
        if (StringUtils.isBlank((CharSequence)rulePurpose)) {
            rules.removeIf(rule -> !"1".equals(rule.getDynamicObject("org").getString("enable")));
        } else {
            rules.removeIf(rule -> !"1".equals(rule.getDynamicObject("org").getString("enable")) || !rule.getString("rulepurpose").contains(rulePurpose));
        }
        if (!includingDisable.booleanValue()) {
            rules.removeIf(rule -> !rule.getBoolean("enable"));
        }
        result.put(ruleType, new ArrayList(rules));
        List objects = result.computeIfAbsent(RuleTypeEnum.ALL, r -> new ArrayList());
        objects.addAll(new ArrayList(rules));
    }

    public static List<DynamicObject> sortIncomeRules(List<DynamicObject> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().sorted((rule1, rule2) -> RuleUtils.compareTaxation(rule1, rule2)).sorted((rule1, rule2) -> RuleUtils.compareTaxRate(rule1, rule2)).collect(Collectors.toList());
        }
        return list;
    }

    public static List<DynamicObject> sortRolloutRules(List<DynamicObject> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().sorted((rule1, rule2) -> {
                String number1 = rule1.getDynamicObject("rollouttype").getString("number");
                String number2 = rule2.getDynamicObject("rollouttype").getString("number");
                return number1.compareTo(number2);
            }).collect(Collectors.toList());
        }
        return list;
    }

    public static List<DynamicObject> sortDiffRules(List<DynamicObject> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().sorted((rule1, rule2) -> {
                String number1 = rule1.getDynamicObject("difftype").getString("number");
                String number2 = rule2.getDynamicObject("difftype").getString("number");
                return number1.compareTo(number2);
            }).collect(Collectors.toList());
        }
        return list;
    }

    public static List<DynamicObject> sortPerpreRules(List<DynamicObject> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().sorted((rule1, rule2) -> {
                String number1 = rule1.getDynamicObject("perpreproduct").getString("number");
                String number2 = rule2.getDynamicObject("perpreproduct").getString("number");
                return number1.compareTo(number2);
            }).collect(Collectors.toList());
        }
        return list;
    }

    private static int compareTaxation(DynamicObject rule1, DynamicObject rule2) {
        String number1 = rule1.getDynamicObject("taxation").getString("number");
        String number2 = rule2.getDynamicObject("taxation").getString("number");
        return taxationOrderMap.getOrDefault(number2, 0) - taxationOrderMap.getOrDefault(number1, 0);
    }

    private static int compareTaxRate(DynamicObject rule1, DynamicObject rule2) {
        String rate1 = rule1.getDynamicObject("taxrate").getString("number").replace("%", "");
        String rate2 = rule2.getDynamicObject("taxrate").getString("number").replace("%", "");
        return Integer.parseInt(rate2) - Integer.parseInt(rate1);
    }

    static {
        taxationOrderMap.put("YBJS", 2);
        taxationOrderMap.put("JYZS_3", 1);
        taxationOrderMap.put("JYZS_5", 1);
    }
}

