/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;

public class TaxTypeUtils {
    public static final List<String> FJSF_SPLIT = Arrays.asList("cswhjss", "jyffj", "dfjyfj");

    public static String getTaxTypeName(String templateType, String calanderTaxtypeValue) {
        CalendarTaxType taxType = CalendarTaxType.getValueByType(TaxTypeUtils.getTaxType(templateType, calanderTaxtypeValue));
        return taxType != null ? taxType.getBridge().getDescription() : "";
    }

    public static String getTaxType(String templateType, String calanderTaxtypeValue) {
        String taxType = null;
        if (templateType != null) {
            taxType = templateType.startsWith("zzs") ? ("2".equals(calanderTaxtypeValue) ? CalendarTaxType.FJSF.getType() : ("3".equals(calanderTaxtypeValue) ? CalendarTaxType.CSWHJSS.getType() : ("4".equals(calanderTaxtypeValue) ? CalendarTaxType.JYFFJ.getType() : ("5".equals(calanderTaxtypeValue) ? CalendarTaxType.DFJYFJ.getType() : CalendarTaxType.ZZS.getType())))) : (templateType.startsWith("qysds") ? CalendarTaxType.QYSDS.getType() : (templateType.startsWith("szys") ? CalendarTaxType.SZYS.getType() : templateType));
        }
        return taxType;
    }

    public static List<String> getTemplateTypeList(String appId, String taxtype) {
        if ("tcret".equals(appId) && "yhs".equals(taxtype)) {
            appId = "tcsd";
        } else {
            if ("tcret".equals(appId) && "fjsf".equals(taxtype)) {
                List<String> totf = Stream.of(TaxTypeEnum.TOTF.getTemplates()).collect(Collectors.toList());
                totf.remove("fjsf");
                return totf;
            }
            if ("tccit".equals(appId)) {
                String theAppid = appId;
                TaxTypeEnum[] values = TaxTypeEnum.values();
                return Stream.of(values).filter(v -> v.getAppId().startsWith(theAppid)).map(TaxTypeEnum::getTemplates).flatMap(Stream::of).collect(Collectors.toList());
            }
        }
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.valueOfAppId(appId);
        if (taxTypeEnum != null) {
            return Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        return new ArrayList<String>(TemplateTypeConstant.getNsrtypemap().keySet());
    }
}

