/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.admindivision;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AdminDivisionConstant;

public class AdminDivisionUtils {
    private static final Log LOGGER = LogFactory.getLog(AdminDivisionUtils.class);

    private static Long getLongId(String divisionId) {
        try {
            return Long.valueOf(divisionId);
        }
        catch (Exception e) {
            LOGGER.info("AdminDivisionUtilsLog: getLongId: idStr : {}", (Object)divisionId);
            return 0L;
        }
    }

    public static DynamicObject getObject(String divisionId) {
        try {
            return BusinessDataServiceHelper.loadSingle((Object)AdminDivisionUtils.getLongId(divisionId), (String)"bd_admindivision");
        }
        catch (KDException e) {
            LOGGER.info("AdminDivisionUtilsLog: getObject: idStr : {}", (Object)divisionId);
            return null;
        }
    }

    public static String getLevel(String divisionId) {
        DynamicObject object = AdminDivisionUtils.getObject(divisionId);
        if (object != null && object.getDynamicObject("basedatafield") != null) {
            return object.getDynamicObject("basedatafield").getString("level");
        }
        return " ";
    }

    public static DynamicObject getParent(String divisionId) {
        DynamicObject parent;
        DynamicObject object = AdminDivisionUtils.getObject(divisionId);
        if (object != null && (parent = object.getDynamicObject("parent")) != null) {
            String id = parent.getString("id");
            return AdminDivisionUtils.getObject(id);
        }
        return null;
    }

    public static DynamicObject getParent(DynamicObject divisionObject) {
        DynamicObject parent;
        if (divisionObject != null && "bd_admindivision".equals(divisionObject.getDynamicObjectType().getName()) && (parent = divisionObject.getDynamicObject("parent")) != null) {
            String id = parent.getString("id");
            return AdminDivisionUtils.getObject(id);
        }
        return null;
    }

    public static String getLongNumber(String divisionId) {
        QFilter idFilter = new QFilter("id", "=", (Object)AdminDivisionUtils.getLongId(divisionId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"longnumber", (QFilter[])new QFilter[]{idFilter, enableFilter});
        return dynamicObject != null ? dynamicObject.getString("longnumber") : " ";
    }

    public static DynamicObject getLevelObject(String targetLevel, String divisionId) {
        DynamicObject object = AdminDivisionUtils.getObject(divisionId);
        if (object != null && object.getDynamicObject("basedatafield") != null && AdminDivisionConstant.LEVEL_LIST.contains(targetLevel)) {
            char currentChar;
            String currentLevel = object.getDynamicObject("basedatafield").getString("level");
            char targetChar = targetLevel.charAt(0);
            if (targetChar == (currentChar = currentLevel.charAt(0))) {
                return object;
            }
            if (targetChar < currentChar) {
                for (int i = 0; i < currentChar - targetChar; ++i) {
                    object = AdminDivisionUtils.getParent(object);
                }
                return object;
            }
        }
        return null;
    }

    public static boolean isSameLevel(String divisionId1, String divisionId2) {
        String level1 = AdminDivisionUtils.getLevel(divisionId1);
        String level2 = AdminDivisionUtils.getLevel(divisionId2);
        if (level1 != " " && level2 != " ") {
            return level1.equals(level2);
        }
        return false;
    }

    public static boolean isSameTargetLevel(String level, String divisionId1, String divisionId2) {
        if (!AdminDivisionConstant.LEVEL_LIST.contains(level)) {
            return false;
        }
        DynamicObject result1 = null;
        DynamicObject result2 = null;
        result1 = AdminDivisionUtils.getLevelObject(level, divisionId1);
        result2 = AdminDivisionUtils.getLevelObject(level, divisionId2);
        if (result1 != null && result2 != null) {
            String id1 = result1.getString("id");
            String id2 = result2.getString("id");
            if (id1 != null && id2 != null) {
                return id1.equals(id2);
            }
        }
        return false;
    }
}

