/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.calender;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.enums.CalendarTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class CalenderUtils {
    private static final Log LOGGER = LogFactory.getLog(CalenderUtils.class);
    private static final Map<String, String> methodsMap = new HashMap<String, String>(){
        {
            this.put("season", "1");
            this.put("month", "2");
            this.put("year", "3");
            this.put("halfyear", "6");
        }
    };

    public static Date getTaxCalenderDate(Long orgId, Date skssqz, String taxtype, String taxlimit, int addMonth) {
        if (CalendarTaxType.isSmallTax(taxtype)) {
            return CalenderUtils.smallTaxHandle(taxtype, skssqz);
        }
        if (CalendarTaxType.QYSDS.getType().equals(taxtype) && "year".equals(taxlimit)) {
            addMonth = 5;
        }
        String calendarTaxValue = null;
        CalendarTaxType calendarTaxType = CalendarTaxType.getValueByType(taxtype);
        if (EmptyCheckUtils.isNotEmpty((Object)calendarTaxType)) {
            calendarTaxValue = calendarTaxType.getValue();
        }
        String applyType = methodsMap.getOrDefault(taxlimit, "6");
        Date payDate = DateUtils.addMonth(skssqz, addMonth);
        try {
            return RegisterAddressUtil.findOrgApplyTypeTaxTypeWithQueryDateEndDate(orgId, applyType, calendarTaxValue, payDate);
        }
        catch (Exception e) {
            LOGGER.error("CalenderUtils findOrgApplyTypeTaxTypeWithQueryDateEndDate org:{},taxlimit:{},tax:{},payDate:{}", new Object[]{orgId, applyType, calendarTaxValue, payDate});
            LOGGER.error("CalenderUtils findOrgApplyTypeTaxTypeWithQueryDateEndDate error:{}", (Object)e.getMessage());
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    private static Date smallTaxHandle(String taxtype, Date skssqz) {
        switch (taxtype) {
            case "ccs": {
                return skssqz;
            }
            case "qs": {
                return DateUtils.addDay(skssqz, 10);
            }
            case "tvpt": {
                return DateUtils.addDay(skssqz, 60);
            }
            case "gdzys": {
                return DateUtils.addDay(skssqz, 30);
            }
            case "tdzzs": {
                return null;
            }
        }
        return null;
    }
}

