/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.enums.DateFormatEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DateUtils {
    private static Log logger = LogFactory.getLog(DateUtils.class);
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static String YYYYMM_CHINESE = DateUtils.getYyyymmChinese();
    public static String YYYYMMDD_CHINESE = DateUtils.getYyyymmddChinese();
    public static String MMDD_CHINESE = DateUtils.getMmddChinese();
    public static String DD_CHINESE = DateUtils.getDdChinese();
    public static String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSSS = "yyyyMMddHHmmssSS";
    public static final List<String> seasonStartMonth = Collections.unmodifiableList(Arrays.asList("1", "4", "7", "10"));
    public static final List<String> seasonEndMonth = Collections.unmodifiableList(Arrays.asList("3", "6", "9", "12"));
    public static final List<String> halfyearStartMonth = Collections.unmodifiableList(Arrays.asList("1", "7"));
    public static final List<String> halfyearEndMonth = Collections.unmodifiableList(Arrays.asList("6", "12"));

    private static String getYyyymmChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"DateUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    private static String getYyyymmddChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"DateUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    private static String getMmddChinese() {
        return ResManager.loadKDString((String)"MM\u6708dd\u65e5", (String)"DateUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    private static String getDdChinese() {
        return ResManager.loadKDString((String)"dd\u65e5", (String)"DateUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public String yyyymmddChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"DateUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public static int getMonthDiff(Date d1, Date d2) {
        return Math.abs(DateUtils.monthOfD1MinusD2(d1, d2));
    }

    public static int getMonthDiff2(String d1, String d2) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYY_MM_DD);
        LocalDate date1 = LocalDate.parse(d1, formatter);
        LocalDate date2 = LocalDate.parse(d2, formatter);
        long monthsBetween = ChronoUnit.MONTHS.between(date1.withDayOfMonth(1), date2.withDayOfMonth(1));
        if (monthsBetween < Integer.MIN_VALUE || monthsBetween > Integer.MAX_VALUE) {
            throw new KDBizException("The month difference is too large to fit in an int.");
        }
        return (int)monthsBetween;
    }

    public static int monthOfD1MinusD2(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        return yearInterval * 12 + (monthInterval %= 12);
    }

    public static int getDayDiff(Date startDate, Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
        long startDateTime = 0L;
        long endDateTime = 0L;
        try {
            startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
            endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("kd.taxc.bdtaxr.common.util.date.DateUtils getDayDiff", e);
        }
        return (int)((endDateTime - startDateTime) / 86400000L);
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String formatHMS(Date date) {
        return DateUtils.format(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        return df.format(date);
    }

    public static String formatMonth(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM);
        return df.format(date);
    }

    public static Date getLastMinMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, 1);
        String strTime = DateUtils.format(calendar.getTime());
        try {
            return new SimpleDateFormat(YYYY_MM_DD).parse(strTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"DateUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e);
        }
    }

    public static Date getLastMaxMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        String strTime = DateUtils.format(calendar.getTime());
        try {
            return new SimpleDateFormat(YYYY_MM_DD).parse(strTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"DateUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e);
        }
    }

    public static Date stringToDateInAnyFormat(String datestr) {
        logger.info(datestr);
        if (EmptyCheckUtils.isEmpty(datestr)) {
            return null;
        }
        Date date = null;
        for (DateFormatEnum dateFormatEnum : DateFormatEnum.values()) {
            try {
                logger.info("zhengze--------" + dateFormatEnum.getZhengze());
                if (!datestr.matches(dateFormatEnum.getZhengze())) continue;
                logger.info("parse date message----" + dateFormatEnum.getZhengze());
                SimpleDateFormat df = new SimpleDateFormat(dateFormatEnum.getFormat());
                date = df.parse(datestr);
                if (null == date) continue;
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (null == date) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef datestr = %s", (String)"DateUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), datestr));
        }
        return date;
    }

    @Deprecated
    public static Date stringToDate(String datestr) {
        Date date;
        if (EmptyCheckUtils.isEmpty(datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%s", (String)"DateUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), YYYY_MM_DD), e);
        }
        return date;
    }

    @Deprecated
    public static Date stringToDate(String datestr, String dateformat) {
        Date date;
        if (StringUtil.isEmpty((CharSequence)datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), datestr, dateformat), e);
        }
        return date;
    }

    public static Date stringToDate2(String datestr) {
        if (StringUtil.isEmpty((CharSequence)datestr)) {
            return null;
        }
        String[] s = datestr.split(" ");
        try {
            LocalDate parse = LocalDate.parse(s[0], DateTimeFormatter.ofPattern(YYYY_MM_DD));
            return Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%s", (String)"DateUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), YYYY_MM_DD), e);
        }
    }

    public static Date stringToDate2(String datestr, String dateformat) {
        if (StringUtil.isEmpty((CharSequence)datestr)) {
            return null;
        }
        try {
            if (YYYY.equals(dateformat)) {
                LocalDate localDate = Year.parse(datestr).atDay(1);
                return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            if (YYYY_MM.equals(dateformat) || YYYYMM.equals(dateformat) || YYYYMM_CHINESE.equals(dateformat)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateformat);
                YearMonth parse = YearMonth.parse(datestr, formatter);
                LocalDate localDate = parse.atDay(1);
                return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(dateformat).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
            TemporalAccessor temporalAccessor = dateTimeFormatter.parse(datestr);
            LocalDateTime dateTime = LocalDateTime.from(temporalAccessor);
            return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), datestr, dateformat), e);
        }
    }

    public static String formatDateStr(String dateStr) {
        String[] parts = dateStr.split(ResManager.loadKDString((String)"\u5e74|\u6708|\u65e5", (String)"DateUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        String year = parts[0];
        String month = parts[1].length() == 1 ? "0" + parts[1] : parts[1];
        String day = parts[2].length() == 1 ? "0" + parts[2] : parts[2];
        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708%3$s\u65e5", (String)"DateUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), year, month, day);
    }

    public static Date formatDateStr2(String dateStr) {
        DateTimeFormatter originalFormatter = DateTimeFormatter.ofPattern(ResManager.loadKDString((String)"yyyy\u5e74M\u6708d\u65e5", (String)"DateUtils_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        LocalDate date = LocalDate.parse(dateStr, originalFormatter);
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static String getLastMonthFirstDateStr(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(cal.getTime());
    }

    public static Date getDayFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(cal.getTime());
    }

    public static String getFirstDateOfMonthStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDayOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(5);
        return y;
    }

    public static Date getDayLast(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth2(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getLastDateOfMonthStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addMonthForLastDate(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static int getYearOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(1);
        return y;
    }

    public static int getMonthOfDate(Date date) {
        int m = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        m = cd.get(2);
        return m + 1;
    }

    public static Date trunc(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%s", (String)"DateUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), format), e);
        }
    }

    public static Date getFirstDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
            cd.get(2);
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        cd.add(2, 2);
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfHalfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 6) {
            cd.set(2, 0);
        } else {
            cd.set(2, 6);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfHalfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 6) {
            cd.set(2, 5);
        } else {
            cd.set(2, 11);
        }
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getLastDateOfYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-31 00:00:00";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getLastDateOfYear1(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-31 23:59:59";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getLastDateOfDay(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY_MM_DD).format(cd.getTime()) + " 23:59:59";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getOne(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getSeven(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-07-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static boolean validDateRange(String taxLimit, Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        if (DateUtils.getYearOfDate(startDate) != DateUtils.getYearOfDate(endDate)) {
            return false;
        }
        if ("month".equals(taxLimit)) {
            Date startDay = DateUtils.getFirstDateOfMonth(startDate);
            Date lastDay = DateUtils.getLastDateOfMonth(startDate);
            return DateUtils.format(startDate).equals(DateUtils.format(startDay)) && DateUtils.format(endDate).equals(DateUtils.format(lastDay));
        }
        if ("season".equals(taxLimit)) {
            Date startDay = DateUtils.getFirstDateOfSeason(startDate);
            Date lastDay = DateUtils.getLastDateOfSeason(startDate);
            return DateUtils.format(startDate).equals(DateUtils.format(startDay)) && DateUtils.format(endDate).equals(DateUtils.format(lastDay));
        }
        if ("halfyear".equals(taxLimit)) {
            Date startDay = DateUtils.getFirstDateOfHalfYear(startDate);
            Date lastDateOfHalfYear = DateUtils.getLastDateOfHalfYear(startDate);
            return DateUtils.format(startDate).equals(DateUtils.format(startDay)) && DateUtils.format(endDate).equals(DateUtils.format(lastDateOfHalfYear));
        }
        if ("year".equals(taxLimit)) {
            Date startDay = DateUtils.getFirstDateOfYear(startDate);
            Date lastDateOfYear = DateUtils.getLastDateOfYear(startDate);
            return DateUtils.format(startDate).equals(DateUtils.format(startDay)) && DateUtils.format(endDate).equals(DateUtils.format(lastDateOfYear));
        }
        if ("count".equals(taxLimit)) {
            return DateUtils.format(startDate).equals(DateUtils.format(endDate));
        }
        return false;
    }

    public static String getTaxLimitTips(Date startdate, Date enddate) {
        String taxlimitStr = "";
        String taxLimit = DateUtils.getTaxLimit(startdate, enddate);
        int startYear = DateUtils.getYearOfDate(startdate);
        int startMonthInt = DateUtils.getMonthOfDate(startdate);
        int endMonthInt = DateUtils.getMonthOfDate(enddate);
        switch (taxLimit) {
            case "year": {
                taxlimitStr = String.format(ResManager.loadKDString((String)"\u5e74", (String)"DateUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), DateUtils.getYearOfDate(startdate));
                break;
            }
            case "halfyear": {
                if (startMonthInt < 7) {
                    taxlimitStr = String.format(ResManager.loadKDString((String)"%s\u4e0a\u534a\u5e74", (String)"DateUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startYear);
                    break;
                }
                taxlimitStr = String.format(ResManager.loadKDString((String)"%s\u4e0b\u534a\u5e74", (String)"DateUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startYear);
                break;
            }
            case "season": {
                if (DateUtils.isSeason(startMonthInt, endMonthInt, 0, 4)) {
                    taxlimitStr = String.format(ResManager.loadKDString((String)"%s\u7b2c\u4e00\u5b63\u5ea6", (String)"DateUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startYear);
                    break;
                }
                if (DateUtils.isSeason(startMonthInt, endMonthInt, 3, 7)) {
                    taxlimitStr = String.format(ResManager.loadKDString((String)"%s\u7b2c\u4e8c\u5b63\u5ea6", (String)"DateUtils_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startYear);
                    break;
                }
                if (DateUtils.isSeason(startMonthInt, endMonthInt, 6, 10)) {
                    taxlimitStr = String.format(ResManager.loadKDString((String)"%s\u7b2c\u4e09\u5b63\u5ea6", (String)"DateUtils_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startYear);
                    break;
                }
                if (!DateUtils.isSeason(startMonthInt, endMonthInt, 9, 13)) break;
                taxlimitStr = String.format(ResManager.loadKDString((String)"%s\u7b2c\u56db\u5b63\u5ea6", (String)"DateUtils_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startYear);
                break;
            }
            case "month": {
                taxlimitStr = DateUtils.formatMonth(startdate);
                break;
            }
            default: {
                taxlimitStr = DateUtils.formatMonth(startdate);
            }
        }
        return taxlimitStr;
    }

    private static boolean isSeason(int startMonthInt, int endMonthInt, int minMonth, int maxMonth) {
        return startMonthInt < maxMonth && startMonthInt > minMonth && endMonthInt < maxMonth && endMonthInt > minMonth;
    }

    public static boolean isSeason(Date startdate, Date enddate, int minMonth, int maxMonth) {
        int startMonthInt = DateUtils.getMonthOfDate(startdate);
        int endMonthInt = DateUtils.getMonthOfDate(enddate);
        return startMonthInt < maxMonth && startMonthInt > minMonth && endMonthInt < maxMonth && endMonthInt > minMonth;
    }

    public static String getTaxLimit2(Date startDate, Date endDate) {
        int monthDiff = DateUtils.getMonthDiff(endDate, startDate);
        String monthOfDate1 = String.valueOf(DateUtils.getMonthOfDate(startDate));
        String monthOfDate2 = String.valueOf(DateUtils.getMonthOfDate(endDate));
        if (monthDiff == 0) {
            return "month";
        }
        if (monthDiff == 2) {
            if (seasonStartMonth.contains(monthOfDate1) && seasonEndMonth.contains(monthOfDate2)) {
                return "season";
            }
        } else if (monthDiff == 5) {
            if (halfyearStartMonth.contains(monthOfDate1) && halfyearEndMonth.contains(monthOfDate2)) {
                return "halfyear";
            }
        } else if (monthDiff == 11 && StringUtil.equals((CharSequence)"1", (CharSequence)monthOfDate1) && StringUtil.equals((CharSequence)"12", (CharSequence)monthOfDate2)) {
            return "year";
        }
        return "";
    }

    public static Date getLastDateOfMonth1(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        Calendar nowDate = Calendar.getInstance();
        nowDate.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        if (endTime == null) {
            return nowDate.after(begin);
        }
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return nowDate.after(begin) && nowDate.before(end);
    }

    public static List<Date> getPreDate(Date startData, Date endDate) {
        int diff = DateUtils.getMonthDiff(endDate, startData);
        Date date1 = DateUtils.addMonth(startData, -(diff + 1));
        Date date2 = DateUtils.getLastDateOfMonth(DateUtils.addMonth(endDate, -(diff + 1)));
        return Arrays.asList(date1, date2);
    }

    public static String getTaxLimit(Date startDate, Date endDate) {
        int monthDiff = DateUtils.getMonthDiff(endDate, startDate);
        if (monthDiff == 0) {
            return startDate.equals(endDate) ? "single" : "month";
        }
        if (monthDiff == 2) {
            return "season";
        }
        if (monthDiff == 5) {
            return "halfyear";
        }
        if (monthDiff == 11) {
            return "year";
        }
        return "";
    }

    public static Map<String, Map<String, Date>> getTaxLimitSkssqzMap(Date date) {
        HashMap<String, Map<String, Date>> result = new HashMap<String, Map<String, Date>>();
        for (String taxLimit : TaxConstant.TAX_LIMITS) {
            Map<String, Date> skssqzMap = DateUtils.getSkssqzMap(date, taxLimit);
            if (skssqzMap == null) continue;
            result.put(taxLimit, skssqzMap);
        }
        return result;
    }

    public static Map<String, Date> getSkssqzMap(Date date, String taxLimit) {
        int month = DateUtils.getMonthOfDate(date);
        Date skssqq = null;
        Date skssqz = null;
        if ("month".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(date, -1));
            skssqz = DateUtils.getLastDateOfMonth1(DateUtils.addMonth(date, -1));
        } else if ("season".equals(taxLimit) && (1 == month || 4 == month || 7 == month || 10 == month)) {
            skssqq = DateUtils.getFirstDateOfSeason(DateUtils.addMonth(date, -3));
            skssqz = DateUtils.getLastDateOfSeason(DateUtils.addMonth(date, -3));
        } else if ("halfyear".equals(taxLimit) && (1 == month || 7 == month)) {
            skssqq = DateUtils.getFirstDateOfHalfYear(DateUtils.addMonth(date, -6));
            skssqz = DateUtils.getLastDateOfHalfYear(DateUtils.addMonth(date, -6));
        } else if (1 == month && "year".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfYear(DateUtils.addYear(date, -1));
            skssqz = DateUtils.getLastDateOfYear(DateUtils.addYear(date, -1));
        }
        if (skssqq != null && skssqz != null) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put("skssqq", skssqq);
            map.put("skssqz", DateUtils.trunc(skssqz));
            return map;
        }
        return null;
    }

    public static Map<String, Date> getPeriodByTaxLimit(Date date, String taxLimit) {
        Date skssqq = null;
        Date skssqz = null;
        if ("month".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfMonth(date);
            skssqz = DateUtils.getLastDateOfMonth1(date);
        } else if ("season".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfSeason(date);
            skssqz = DateUtils.getLastDateOfSeason(date);
        } else if ("halfyear".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfHalfYear(date);
            skssqz = DateUtils.getLastDateOfHalfYear(date);
        } else if ("year".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfYear(date);
            skssqz = DateUtils.getLastDateOfYear(date);
        }
        if (skssqq != null && skssqz != null) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put("startDate", skssqq);
            map.put("endDate", DateUtils.trunc(skssqz));
            return map;
        }
        return new HashMap<String, Date>();
    }

    public static Map<String, Date> getPrePeriodByTaxLimit(Date date, String taxLimit) {
        if ("month".equals(taxLimit)) {
            return DateUtils.getPeriodByTaxLimit(DateUtils.addMonth(date, -1), taxLimit);
        }
        if ("season".equals(taxLimit)) {
            return DateUtils.getPeriodByTaxLimit(DateUtils.addMonth(date, -3), taxLimit);
        }
        if ("halfyear".equals(taxLimit)) {
            return DateUtils.getPeriodByTaxLimit(DateUtils.addMonth(date, -6), taxLimit);
        }
        if ("year".equals(taxLimit)) {
            return DateUtils.getPeriodByTaxLimit(DateUtils.addYear(date, -1), taxLimit);
        }
        return new HashMap<String, Date>();
    }

    public static Map<String, Date> getSkssqzMap(Date date, String taxLimit, Boolean isInPeriod) {
        if (!isInPeriod.booleanValue()) {
            return DateUtils.getSkssqzMap(date, taxLimit);
        }
        int month = DateUtils.getMonthOfDate(date);
        Date skssqq = null;
        Date skssqz = null;
        if ("month".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfMonth(date);
            skssqz = DateUtils.getLastDateOfMonth1(date);
        } else if ("season".equals(taxLimit) && (12 == month || 3 == month || 6 == month || 9 == month)) {
            skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(date, -2));
            skssqz = DateUtils.getLastDateOfMonth1(date);
        } else if ("halfyear".equals(taxLimit) && (12 == month || 6 == month)) {
            skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(date, -5));
            skssqz = DateUtils.getLastDateOfMonth1(date);
        } else if (12 == month && "year".equals(taxLimit)) {
            skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(date, -11));
            skssqz = DateUtils.getLastDateOfMonth1(date);
        }
        if (skssqq != null && skssqz != null) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put("skssqq", skssqq);
            map.put("skssqz", DateUtils.trunc(skssqz));
            return map;
        }
        return null;
    }

    public static List<String> getMonthBetween(Date minDate, Date maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        min.set(min.get(1), min.get(2), 1);
        max.setTime(maxDate);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static List<String> getMonthBetween(Date minDate, Date maxDate, String format) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        min.set(min.get(1), min.get(2), 1);
        max.setTime(maxDate);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static Date[] getIntersectionDate(Date beginTime, Date endTime, Date startDate, Date endDate) {
        Date[] date = new Date[2];
        if (null == endTime && null == endDate) {
            if (null == beginTime && null != startDate) {
                date[0] = startDate;
            } else if (null != beginTime && null == startDate) {
                date[0] = beginTime;
            } else if (null != beginTime && null != startDate) {
                date[0] = beginTime.getTime() <= startDate.getTime() ? startDate : beginTime;
            }
        } else if (null == endTime && null != endDate) {
            if (null == beginTime && null == startDate) {
                date[1] = endDate;
            } else if (null != beginTime && null == startDate && beginTime.getTime() <= endDate.getTime()) {
                date[0] = beginTime;
                date[1] = endDate;
            } else if (null == beginTime && null != startDate) {
                date[0] = startDate;
                date[1] = endDate;
            } else if (null != beginTime && null != startDate) {
                if (beginTime.getTime() <= startDate.getTime()) {
                    date[0] = startDate;
                    date[1] = endDate;
                } else if (beginTime.getTime() >= startDate.getTime() && beginTime.getTime() <= endDate.getTime()) {
                    date[0] = beginTime;
                    date[1] = endDate;
                }
            }
        } else if (null != endTime && null == endDate) {
            if (null == beginTime && null == startDate) {
                date[1] = endTime;
            } else if (null == beginTime && null != startDate && startDate.getTime() <= endTime.getTime()) {
                date[0] = startDate;
                date[1] = endTime;
            } else if (null != beginTime && null == startDate) {
                date[0] = beginTime;
                date[1] = endTime;
            } else if (null != beginTime && null != startDate) {
                if (beginTime.getTime() >= startDate.getTime()) {
                    date[0] = beginTime;
                    date[1] = endTime;
                } else if (beginTime.getTime() <= startDate.getTime() && startDate.getTime() <= endTime.getTime()) {
                    date[0] = startDate;
                    date[1] = endTime;
                }
            }
        } else if (null != endTime && null != endDate) {
            if (null == beginTime && null == startDate && endTime.getTime() <= endDate.getTime()) {
                date[0] = endTime;
                date[1] = endDate;
            } else if (null == beginTime && null == startDate && endDate.getTime() <= endTime.getTime()) {
                date[0] = endDate;
                date[1] = endTime;
            } else if (null != beginTime && null == startDate && beginTime.getTime() <= endDate.getTime() && endDate.getTime() <= endTime.getTime()) {
                date[0] = beginTime;
                date[1] = endDate;
            } else if (null != beginTime && null == startDate && beginTime.getTime() <= endDate.getTime() && endTime.getTime() <= endDate.getTime()) {
                date[0] = beginTime;
                date[1] = endTime;
            } else if (null == beginTime && null != startDate && startDate.getTime() <= endTime.getTime() && endTime.getTime() <= endDate.getTime()) {
                date[0] = startDate;
                date[1] = endTime;
            } else if (null == beginTime && null != startDate && startDate.getTime() <= endTime.getTime() && endDate.getTime() <= endTime.getTime()) {
                date[0] = startDate;
                date[1] = endDate;
            } else if (null != beginTime && null != startDate) {
                if (beginTime.getTime() <= startDate.getTime() && endTime.getTime() >= endDate.getTime()) {
                    date[0] = startDate;
                    date[1] = endDate;
                } else if (beginTime.getTime() >= startDate.getTime() && endTime.getTime() <= endDate.getTime()) {
                    date[0] = beginTime;
                    date[1] = endTime;
                } else if (beginTime.getTime() >= startDate.getTime() && beginTime.getTime() <= endDate.getTime() && endDate.getTime() <= endTime.getTime()) {
                    date[0] = beginTime;
                    date[1] = endDate;
                } else if (beginTime.getTime() <= startDate.getTime() && startDate.getTime() <= endTime.getTime() && endTime.getTime() <= endDate.getTime()) {
                    date[0] = startDate;
                    date[1] = endTime;
                }
            }
        }
        if (null == date[0] && null == date[1]) {
            return null;
        }
        return date;
    }

    public static boolean checkTimeRepeat(Date start1, Date end1, Date start2, Date end2) {
        if (end1 == null) {
            if (end2 == null) {
                return Boolean.FALSE;
            }
            return end2.before(start1);
        }
        if (end2 == null) {
            return end1.before(start2);
        }
        return start1.before(start2) && end1.before(start2) || start1.after(end2) && end1.after(end2);
    }

    public static LocalDateTime date2LocalDateTime(Date current) {
        Instant instant = current.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Date setMaxHHMMSS(Date current) {
        LocalDateTime local = DateUtils.date2LocalDateTime(current);
        local = local.withHour(23).withMinute(59).withSecond(59);
        return DateUtils.localDateTime2Date(local);
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static boolean isFirstMonthWithinSeason(Date date) {
        int monthOfDate = DateUtils.getMonthOfDate(date);
        return Arrays.asList(1, 4, 7, 10).contains(monthOfDate);
    }

    public static boolean isFront5Month(Date date) {
        int monthOfDate = DateUtils.getMonthOfDate(date);
        return Arrays.asList(1, 2, 3, 4, 5).contains(monthOfDate);
    }

    public static boolean isFirstMonthWithinYear(Date date) {
        return 1 == DateUtils.getMonthOfDate(date);
    }

    public static Date getMaxDateBeforeSomeMonth(Date now, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, month);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getMinDateBeforeSomeMonth(Date now, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, month);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getBigger(Date d1, Date d2) {
        return d1.after(d2) ? d1 : d2;
    }

    public static Date getSmaller(Date d1, Date d2) {
        return d1.before(d2) ? d1 : d2;
    }

    public static boolean isPrePeriodStartEnd(Date start, Date end, Date date) {
        Date addMonth = DateUtils.addMonth(date, -1);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth(addMonth);
        Date lastDateOfMonth = DateUtils.trunc(DateUtils.getLastDateOfMonth(addMonth));
        if (firstDateOfMonth != null && lastDateOfMonth != null && firstDateOfMonth.equals(start) && lastDateOfMonth.equals(end)) {
            return true;
        }
        addMonth = DateUtils.addMonth(date, -3);
        Date firstDateOfSeason = DateUtils.getFirstDateOfSeason(addMonth);
        Date lastDateOfSeason = DateUtils.trunc(DateUtils.getLastDateOfSeason(addMonth));
        if (firstDateOfSeason != null && lastDateOfSeason != null && firstDateOfSeason.equals(start) && lastDateOfSeason.equals(end)) {
            return true;
        }
        addMonth = DateUtils.addMonth(date, -6);
        Date firstDateOfHalfYear = DateUtils.getFirstDateOfHalfYear(addMonth);
        Date lastDateOfHalfYear = DateUtils.trunc(DateUtils.getLastDateOfHalfYear(addMonth));
        if (firstDateOfHalfYear != null && lastDateOfHalfYear != null && firstDateOfHalfYear.equals(start) && lastDateOfHalfYear.equals(end)) {
            return true;
        }
        addMonth = DateUtils.addMonth(date, -12);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear(addMonth);
        Date lastDateOfYear = DateUtils.trunc(DateUtils.getLastDateOfYear(addMonth));
        return firstDateOfYear != null && lastDateOfYear != null && firstDateOfYear.equals(start) && lastDateOfYear.equals(end);
    }

    public static Date getMinDate(Date ... dates) {
        Date min = null;
        for (Date date : dates) {
            if (date == null) continue;
            if (min == null) {
                min = date;
            }
            if (date.compareTo(min) >= 0) continue;
            min = date;
        }
        return min;
    }

    public static Date getMaxDate(Date ... dates) {
        Date max = null;
        for (Date date : dates) {
            if (date == null) {
                return null;
            }
            if (max == null) {
                max = date;
            }
            if (date.compareTo(max) <= 0) continue;
            max = date;
        }
        return max;
    }

    public static String getChinesePeriod(String taxLimit, Date date) {
        int year = DateUtils.getYearOfDate(date);
        int month = DateUtils.getMonthOfDate(date);
        switch (taxLimit) {
            case "month": {
                String formatMonth = String.format("%02d", month);
                return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u4efd", (String)"DateUtils_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), year, formatMonth);
            }
            case "season": {
                return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u5b63\u5ea6", (String)"DateUtils_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), year, (month + 2) / 3);
            }
            case "year": {
                return String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"DateUtils_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), year);
            }
            case "halfyear": {
                if (month <= 6) {
                    return String.format(ResManager.loadKDString((String)"%s\u5e74\u4e0a\u534a\u5e74", (String)"DateUtils_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), year);
                }
                return String.format(ResManager.loadKDString((String)"%s\u5e74\u4e0b\u534a\u5e74", (String)"DateUtils_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), year);
            }
        }
        return null;
    }

    public static int subtractDatesForMonth(Date enddate, Date startdate) {
        if (enddate == null || startdate == null) {
            return 0;
        }
        int year1 = DateUtils.getYearOfDate(enddate);
        int year2 = DateUtils.getYearOfDate(startdate);
        int month1 = DateUtils.getMonthOfDate(enddate);
        int month2 = DateUtils.getMonthOfDate(startdate);
        return (year1 - year2) * 12 + month1 - month2;
    }

    public static String getStartToEndDate(Date startDate, Date endDate, String format) {
        return DateUtils.format(startDate, format) + "~" + DateUtils.format(endDate, format);
    }

    public static String getPeriodByChinese(Date skssqq, Date skssqz) {
        String period;
        if (skssqq == null || skssqz == null) {
            return "";
        }
        switch (period = DateUtils.getTaxLimit(skssqq, skssqz)) {
            case "month": {
                return ResManager.loadKDString((String)"\u6708\u5ea6", (String)"DateUtils_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "season": {
                return ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"DateUtils_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "year": {
                return ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"DateUtils_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "halfyear": {
                return ResManager.loadKDString((String)"\u534a\u5e74\u5ea6", (String)"DateUtils_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

