/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FormulaUtils {
    private static final String CALE_EXPRESSION = "([\\+\\-\\*/])";
    private static final String formulaZKHExp = "(\\w{0,2})\\[([\\w\\s_\n\r\\.\\(\\),\\%#=><\\-\\\\'\u4e00-\u9fa5]*)\\]";
    private static final String REGX = "\\[(.*?)]";
    private static final String NUMBER = "[0-9]*";
    private static final String sumFormula = "(?i)sum\\(([^)]*)\\{\\w{0,2}\\[([^)]*)\\)";

    public static boolean isExpression(String str) {
        Pattern p = Pattern.compile(CALE_EXPRESSION);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static String getMatchKey(String str) {
        Pattern pattern = Pattern.compile(REGX);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static List<String> getMatchKeyList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGX);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    public static List<String> getSumFormula(String formula) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isBlank((CharSequence)formula)) {
            return list;
        }
        Pattern pattern = Pattern.compile(sumFormula);
        Matcher matcher = pattern.matcher(formula);
        while (matcher.find()) {
            list.add(matcher.group(0));
        }
        return list;
    }

    public static boolean isSumFormula(String formula) {
        if (StringUtil.isBlank((CharSequence)formula)) {
            return false;
        }
        Pattern pattern = Pattern.compile(sumFormula);
        return pattern.matcher(formula).find();
    }

    public static boolean isNumeric(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile(NUMBER);
        return pattern.matcher(str).matches();
    }

    public static Map<String, String> parseFormulaZKH(String formula) {
        Pattern r = Pattern.compile(formulaZKHExp);
        Matcher m = r.matcher(formula);
        HashMap<String, String> map = new HashMap<String, String>();
        while (m.find()) {
            map.put(m.group(2), m.group(1));
        }
        return map;
    }

    public static StringBuffer getFormulaItem(String formulaBody, String ... params) {
        Pattern pattern = Pattern.compile(REGX);
        Matcher matcher = pattern.matcher(formulaBody);
        int index = 0;
        StringBuffer formulaItem = new StringBuffer();
        while (matcher.find()) {
            String result = "[" + matcher.group(1) + "]";
            String maskResult = "[" + params[index] + "]";
            matcher.appendReplacement(formulaItem, maskResult == null ? result : maskResult);
            ++index;
        }
        matcher.appendTail(formulaItem);
        return formulaItem;
    }
}

