/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.rule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.CommonConstant;
import kd.taxc.bdtaxr.common.refactor.rule.rulecal.filter.FilterDto;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleSettingUtils {
    private static Log logger = LogFactory.getLog(RuleSettingUtils.class);
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_SUB_NAME = "fieldsubname";
    private static final String JSON = "conditionjson";
    private static final String FIELDS = "fields";
    private static final String GROUP_FIELDS = "groupfields";
    private static final String DISTINCT_FIELD = "distinctfield";
    private static final String ENTITY_NAME = "entityname";
    private static final String SELECTED_FIELDS = "id,conditionjson,func,distinctfield";

    public static ConcurrentHashMap<String, List<QFilter>> getFilter(Map<String, Map<String, String>> fieldMap, BussinessParamsVo bussinessParams, DynamicObject setting, boolean isSubQuery, List<String> mainTables, List<FilterDto> joinDtos) {
        ConcurrentHashMap<String, List<QFilter>> dataSource2Filters = new ConcurrentHashMap<String, List<QFilter>>();
        String conditionjson = setting.getString(JSON);
        if (StringUtils.isNotBlank((CharSequence)conditionjson)) {
            List<FilterDto> dtos = JsonUtil.fromJsonList(conditionjson, FilterDto.class);
            if (null == dtos || dtos.size() == 0) {
                return null;
            }
            ConcurrentHashMap<String, List<FilterDto>> dataSource2FilterDto = new ConcurrentHashMap<String, List<FilterDto>>();
            List<FilterDto> joins = RuleSettingUtils.getJoinDto(dtos, dataSource2FilterDto);
            if (CollectionUtils.isNotEmpty(joins)) {
                joinDtos.addAll(joins);
            }
            dataSource2Filters.putAll(FilterBuilderUtils.buildFilterByFilterDto(dataSource2FilterDto, bussinessParams.getExtendParams()));
        }
        for (String mainTable : mainTables) {
            dataSource2Filters.putIfAbsent(mainTable, new ArrayList());
            List<QFilter> mainTableFilter = dataSource2Filters.get(mainTable);
            if (isSubQuery || null == mainTableFilter || !fieldMap.containsKey(mainTable)) continue;
            String org = fieldMap.get(mainTable).get("orgstate");
            if (null != org && StringUtils.isNotBlank((CharSequence)bussinessParams.getOrgId())) {
                mainTableFilter.add(new QFilter(org, "=", (Object)Long.parseLong(bussinessParams.getOrgId())));
            }
            RuleSettingUtils.setOtherFilter(fieldMap.get(mainTable), mainTableFilter, bussinessParams);
        }
        return dataSource2Filters;
    }

    private static List<FilterDto> getJoinDto(List<FilterDto> dtos, ConcurrentHashMap<String, List<FilterDto>> dataSource2FilterDto) {
        ArrayList<FilterDto> joinDtos = new ArrayList<FilterDto>();
        for (FilterDto dto : dtos) {
            List group = dataSource2FilterDto.getOrDefault(dto.getDataSourceNumber(), new LinkedList());
            if ("left join".equals(dto.getConditonNumber()) || "inner join".equals(dto.getConditonNumber())) {
                joinDtos.add(dto);
                continue;
            }
            group.add(dto);
            dataSource2FilterDto.put(dto.getDataSourceNumber(), group);
        }
        return joinDtos;
    }

    private static void setOtherFilter(Map<String, String> fieldMap, List<QFilter> filterList, BussinessParamsVo bussinessParams) {
        String month;
        String monthField;
        String year;
        String dataField = fieldMap.get("datastate");
        if (null != dataField) {
            if (bussinessParams.getStartDate() != null) {
                QFilter startFilter = new QFilter(dataField, ">=", (Object)bussinessParams.getStartDate());
                filterList.add(startFilter);
            }
            if (bussinessParams.getEndDate() != null) {
                QFilter endFilter = new QFilter(dataField, "<=", (Object)bussinessParams.getEndDate());
                filterList.add(endFilter);
            }
        }
        String yearField = fieldMap.get("yearstate");
        String taxperiod = bussinessParams.getTaxPeriod();
        if (null == taxperiod) {
            return;
        }
        if (null != yearField && StringUtils.isNotBlank((CharSequence)(year = taxperiod.substring(0, 4)))) {
            filterList.add(new QFilter(yearField, "=", (Object)year));
        }
        if (null != (monthField = fieldMap.get("monthstate")) && StringUtils.isNotBlank((CharSequence)(month = taxperiod.substring(5, 7)))) {
            QFilter q1 = new QFilter(monthField, "=", (Object)month);
            int value = Integer.parseInt(month);
            QFilter q2 = new QFilter(monthField, "=", (Object)String.valueOf(value));
            if (value < 10) {
                filterList.add(q1.or(q2));
            } else {
                filterList.add(q1);
            }
        }
    }

    public static void calAmount(DynamicObject setting, String mainTable, ConcurrentHashMap<String, List<QFilter>> filterMap, ConcurrentHashMap<Long, Object> calResult, List<FilterDto> joinDtos) {
        if (null == setting || null == calResult) {
            return;
        }
        StringBuilder selectFieldwithid = new StringBuilder();
        HashMap<String, StringBuilder> fieldsMap = new HashMap<String, StringBuilder>();
        RuleSettingUtils.dealDistinctFields(Collections.singletonList(mainTable), Collections.singletonList(setting.getDynamicObject(DISTINCT_FIELD).getLong("id")), fieldsMap, selectFieldwithid);
        for (Map.Entry<String, List<QFilter>> entry : filterMap.entrySet()) {
            StringBuilder qFilterDesc = new StringBuilder();
            qFilterDesc.append(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u67e5\u8be2\uff0c\u6570\u636e\u6e90\u4e3a\uff1a\u3010%s\u3011, \u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a", (String)"RuleSettingUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entry.getKey()));
            for (QFilter qFilter : entry.getValue()) {
                qFilterDesc.append(qFilter).append(',');
            }
            logger.info(qFilterDesc.toString());
        }
        if (CollectionUtils.isNotEmpty(joinDtos)) {
            StringBuilder selectField = new StringBuilder();
            Set mainSelectFieldList = joinDtos.stream().map(o -> o.getFieldNumber()).collect(Collectors.toSet());
            StringBuilder mainField = new StringBuilder();
            for (FilterDto joinDto : joinDtos) {
                if (!fieldsMap.containsKey(joinDto.getDataSourceNumber())) continue;
                if (mainField.length() > 0) {
                    mainField.append(CommonConstant.COMMA).append((CharSequence)fieldsMap.get(joinDto.getDataSourceNumber()));
                    continue;
                }
                mainField = (StringBuilder)fieldsMap.get(joinDto.getDataSourceNumber());
            }
            String mainSelectFields = String.join((CharSequence)",", mainSelectFieldList);
            if (mainField.length() > 0) {
                mainSelectFields = mainField.append(CommonConstant.COMMA).append(mainSelectFields).toString();
            }
            HashSet<String> mainFieldSet = new HashSet<String>(Arrays.asList(mainSelectFields.split(",")));
            mainSelectFields = String.join((CharSequence)",", mainFieldSet);
            List<QFilter> mainFilter = filterMap.get(joinDtos.get(0).getDataSourceNumber());
            DataSet main = QueryServiceHelper.queryDataSet((String)RuleSettingUtils.class.getName(), (String)joinDtos.get(0).getDataSourceNumber(), (String)mainSelectFields, null == mainFilter ? null : mainFilter.toArray(new QFilter[mainFilter.size()]), null);
            DataSet result = null;
            for (FilterDto joinDto : joinDtos) {
                DynamicObject subSelectedField = RuleSettingUtils.getSubSelectedFields(joinDto);
                if (null == subSelectedField) continue;
                String subSelectFields = subSelectedField.getString(FIELD_NAME);
                String subTable = subSelectedField.getString(FIELD_SUB_NAME);
                StringBuilder subField = new StringBuilder();
                HashSet subFieldSet = new HashSet();
                HashMap duplicateMap = new HashMap();
                if (fieldsMap.containsKey(subTable) && StringUtils.isNotBlank((CharSequence)(subField = (StringBuilder)fieldsMap.get(subTable)))) {
                    ArrayList<String> newFields = new ArrayList<String>(subField.toString().split(",").length);
                    ArrayList<String> newSelectFields = new ArrayList<String>(subField.toString().split(",").length);
                    ArrayList<String> subFieldList = new ArrayList<String>(Arrays.asList(subField.toString().split(",")));
                    for (String field : subFieldList) {
                        String tempFields = field + " as " + subTable + "_" + field;
                        if (mainFieldSet.contains(field) || subFieldSet.contains(field)) {
                            if (!duplicateMap.containsKey(subTable)) {
                                duplicateMap.put(subTable, new ArrayList());
                            }
                            ((List)duplicateMap.get(subTable)).add(field);
                            newSelectFields.add(subTable + "_" + field);
                            field = tempFields;
                        } else {
                            newSelectFields.add(field);
                        }
                        newFields.add(field);
                    }
                    subFieldSet.addAll(newFields);
                    subField = new StringBuilder(String.join((CharSequence)",", newSelectFields));
                    subSelectFields = new StringBuilder(String.join((CharSequence)",", subFieldSet)) + CommonConstant.COMMA + "" + subSelectFields;
                }
                if (selectField.length() == 0) {
                    selectField.append(mainSelectFields).append(CommonConstant.COMMA).append(StringUtils.isNotBlank((CharSequence)subField) ? subField : "");
                } else {
                    selectField.append(CommonConstant.COMMA).append((CharSequence)subField);
                }
                List<QFilter> subFilter = filterMap.get(subTable);
                DataSet sub = QueryServiceHelper.queryDataSet((String)RuleSettingUtils.class.getName(), (String)subTable, (String)subSelectFields, null == subFilter ? null : subFilter.toArray(new QFilter[subFilter.size()]), null);
                if (null == main || null == sub || joinDto.getValue().size() == 0) continue;
                try {
                    JoinDataSet join = null;
                    join = result == null ? main.join(sub, RuleSettingUtils.getJoinType(joinDto)) : result.join(sub, RuleSettingUtils.getJoinType(joinDto));
                    result = join.on(joinDto.getFieldNumber(), subSelectedField.getString(FIELD_NAME)).select(selectField.toString().split(",")).finish();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage());
                }
            }
            if (result != null) {
                calResult.put(setting.getLong("id"), RuleSettingUtils.getResuleByFunc(result, selectFieldwithid.toString(), setting.getString("func")));
            }
        } else {
            DataSet result = QueryServiceHelper.queryDataSet((String)RuleSettingUtils.class.getName(), (String)mainTable, (String)selectFieldwithid.toString(), (QFilter[])filterMap.get(mainTable).toArray(new QFilter[0]), null);
            calResult.put(setting.getLong("id"), RuleSettingUtils.getResuleByFunc(result, selectFieldwithid.toString(), setting.getString("func")));
        }
    }

    private static DynamicObject getSubSelectedFields(FilterDto joinDto) {
        return QueryServiceHelper.queryOne((String)"bdtaxr_datasource_entry", (String)"fieldsubname,fieldname,tableid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(joinDto.getValue().get(0)))});
    }

    private static JoinType getJoinType(FilterDto filterDto) {
        return "left join".equals(filterDto.getConditonNumber()) ? JoinType.LEFT : JoinType.INNER;
    }

    private static Object getResuleByFunc(DataSet dataSet, String selectField, String func) {
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        if (!StringUtil.isEmpty((CharSequence)func)) {
            switch (func) {
                case "sum": {
                    for (Row row : dataSet.copy()) {
                        BigDecimal decimal = row.getBigDecimal(selectField);
                        if (null == decimal) continue;
                        detailTotalAmount = detailTotalAmount.add(decimal);
                    }
                    return detailTotalAmount;
                }
                case "count": {
                    return dataSet.copy().count(selectField, false);
                }
                case "max": {
                    return ((Row)dataSet.copy().orderBy(new String[]{selectField + " desc"}).iterator().next()).get(selectField);
                }
                case "min": {
                    return ((Row)dataSet.copy().orderBy(new String[]{selectField + " asc"}).iterator().next()).get(selectField);
                }
                case "distinct": {
                    HashSet<Object> filterSet = new HashSet<Object>();
                    for (Row row : dataSet) {
                        Object o = row.get(selectField);
                        if (null == o) continue;
                        filterSet.add(o);
                    }
                    return filterSet;
                }
                case "abs": {
                    for (Row row : dataSet) {
                        BigDecimal decimal = row.getBigDecimal(selectField);
                        if (null == decimal) continue;
                        detailTotalAmount = detailTotalAmount.add(decimal);
                    }
                    return detailTotalAmount.abs();
                }
            }
            return new Object();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Row row : dataSet) {
            Object o = row.get(selectField);
            if (null == o) continue;
            list.add(o);
        }
        return list;
    }

    public static Object getSubQueryValue(String ruleId) {
        DynamicObject[] ruleObjs = BusinessDataServiceHelper.load((String)"bdtaxr_rule_set", (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ruleId)});
        if (null == ruleObjs || ruleObjs.length == 0) {
            logger.warn("\u4f20\u5165\u7684\u89c4\u5219Id\u5747\u4e3a\u65e0\u6548\u503c.");
            return new ArrayList();
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u5b50\u67e5\u8be2\u5f00\u59cb\u6267\u884c\uff0c\u6267\u884c\u7684\u5b50\u67e5\u8be2ID:" + ruleId);
        long start = System.currentTimeMillis();
        ConcurrentHashMap<Long, Object> calResult = new ConcurrentHashMap<Long, Object>();
        ArrayList<Object> result = new ArrayList<Object>();
        RuleSettingUtils.calculate(Arrays.asList(ruleObjs), calResult, new BussinessParamsVo(), true);
        for (Map.Entry<Long, Object> entry : calResult.entrySet()) {
            if (entry.getValue() instanceof List) {
                result.addAll((Collection)entry.getValue());
                continue;
            }
            result.add(entry.getValue());
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u5b50\u67e5\u8be2\u6267\u884c\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return result;
    }

    public static void calculate(List<DynamicObject> ruleObjs, ConcurrentHashMap<Long, Object> calResult, BussinessParamsVo bussinessParams, boolean isSubquery) {
        for (DynamicObject setting : ruleObjs) {
            List<Object> dataSourceIds;
            Long distinctFieldId = setting.getDynamicObject(DISTINCT_FIELD).getLong("id");
            if (distinctFieldId == null || (dataSourceIds = RuleSettingUtils.getDataSourceIdByField(Collections.singletonList(distinctFieldId))) == null || dataSourceIds.size() <= 0) continue;
            DynamicObject table = BusinessDataServiceHelper.loadSingleFromCache((Object)dataSourceIds.get(0), (String)"bdtaxr_custom_datasource");
            ConcurrentHashMap<String, Map<String, String>> fieldMap = RuleConfigUtils.get(new DynamicObject[]{table});
            ArrayList<FilterDto> joinDtos = new ArrayList<FilterDto>();
            ConcurrentHashMap<String, List<QFilter>> filterMap = RuleSettingUtils.getFilter(fieldMap, bussinessParams, setting, isSubquery, Collections.singletonList(table.getString(ENTITY_NAME)), joinDtos);
            RuleSettingUtils.calAmount(setting, table.getString(ENTITY_NAME), filterMap, calResult, joinDtos);
        }
    }

    public static List<Map<String, Object>> batchCalculate(BussinessParamsVo bussinessParams, DynamicObject ruleObj) {
        DynamicObjectCollection collection = ruleObj.getDynamicObjectCollection(FIELDS);
        List<Long> distinctFieldIds = collection.stream().map(o -> o.getDynamicObject(DISTINCT_FIELD).getLong("id")).collect(Collectors.toList());
        List<Object> dataSourceIds = RuleSettingUtils.getDataSourceIdByField(distinctFieldIds);
        if (CollectionUtils.isEmpty(dataSourceIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<FilterDto> joinDtos = new ArrayList<FilterDto>();
        DynamicObject[] tables = BusinessDataServiceHelper.load((String)"bdtaxr_custom_datasource", (String)"entityname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate,entryentity.fieldname", (QFilter[])new QFilter[]{new QFilter("id", "in", dataSourceIds)});
        Map<String, Long> tableNames = Arrays.stream(tables).collect(Collectors.toMap(k -> k.getString(ENTITY_NAME), v -> v.getLong("id"), (m, n) -> m));
        ConcurrentHashMap<String, Map<String, String>> fieldMap = RuleConfigUtils.get(tables);
        ConcurrentHashMap<String, List<QFilter>> filterMap = RuleSettingUtils.getFilter(fieldMap, bussinessParams, ruleObj, false, new ArrayList<String>(tableNames.keySet()), joinDtos);
        String number = "";
        try {
            number = ruleObj.getString("number");
            return RuleSettingUtils.batchCalAmount(ruleObj, tableNames, filterMap, joinDtos);
        }
        catch (Throwable e) {
            logger.error("\u6279\u91cf\u7533\u62a5\u9879\u76ee\u89c4\u5219\u914d\u7f6e\u53d6\u6570\u9519\u8bef:" + number, e);
            return new ArrayList<Map<String, Object>>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> batchCalAmount(DynamicObject setting, Map<String, Long> mainTables, ConcurrentHashMap<String, List<QFilter>> filterMap, List<FilterDto> joinDtos) {
        DynamicObjectCollection collection = setting.getDynamicObjectCollection(FIELDS);
        ArrayList<Long> fieldsIds = new ArrayList<Long>();
        Map<String, String> field2Func = RuleSettingUtils.buildFuncMap(collection, fieldsIds, mainTables);
        HashMap<String, StringBuilder> fieldsMap = new HashMap<String, StringBuilder>();
        StringBuilder selectFieldwithid = new StringBuilder();
        ArrayList<String> maintableNames = new ArrayList<String>(mainTables.keySet());
        RuleSettingUtils.dealDistinctFields(maintableNames, fieldsIds, fieldsMap, selectFieldwithid);
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        Map<Long, Set<String>> groupFieldMap = new HashMap<Long, Set<String>>();
        RuleSettingUtils.recordLog(filterMap);
        if (CollectionUtils.isNotEmpty(joinDtos)) {
            Long mainTableId;
            StringBuilder joinSelectField = new StringBuilder();
            Set mainSelectFieldList = joinDtos.stream().map(o -> o.getFieldNumber()).collect(Collectors.toSet());
            StringBuilder mainField = new StringBuilder();
            ArrayList<String> subTables = new ArrayList<String>();
            for (FilterDto joinDto : joinDtos) {
                DynamicObject subSelectedField;
                if (fieldsMap.containsKey(joinDto.getDataSourceNumber())) {
                    if (mainField.length() > 0) {
                        mainField.append(CommonConstant.COMMA).append((CharSequence)fieldsMap.get(joinDto.getDataSourceNumber()));
                    } else {
                        mainField = mainField.append((CharSequence)fieldsMap.get(joinDto.getDataSourceNumber()));
                    }
                }
                if ((subSelectedField = RuleSettingUtils.getSubSelectedFields(joinDto)) == null) continue;
                subTables.add(subSelectedField.getString(FIELD_SUB_NAME));
            }
            String mainSelectFields = String.join((CharSequence)",", mainSelectFieldList);
            if ((groupFieldMap = RuleSettingUtils.getGroupFields(setting, maintableNames, subTables, groupFieldMap)).containsKey(mainTableId = joinDtos.get(0).getDataSource())) {
                HashSet<String> selectFieldSet = new HashSet<String>(Arrays.asList(mainField.toString().split(",")));
                selectFieldSet.addAll((Collection<String>)groupFieldMap.get(mainTableId));
                mainField = new StringBuilder(String.join((CharSequence)",", selectFieldSet));
            }
            if (mainField.length() > 0) {
                mainSelectFields = mainField.append(CommonConstant.COMMA).append(mainSelectFields).toString();
            }
            HashSet<String> mainFieldSet = new HashSet<String>(Arrays.asList(mainSelectFields.split(",")));
            mainSelectFields = String.join((CharSequence)",", mainFieldSet);
            List<QFilter> mainFilter = filterMap.get(joinDtos.get(0).getDataSourceNumber());
            HashMap<String, List<String>> duplicateMap = new HashMap<String, List<String>>();
            DataSet main = QueryServiceHelper.queryDataSet((String)RuleSettingUtils.class.getName(), (String)joinDtos.get(0).getDataSourceNumber(), (String)mainSelectFields, null == mainFilter ? null : mainFilter.toArray(new QFilter[mainFilter.size()]), null);
            DataSet result = null;
            DataSet sub = null;
            try {
                HashSet subFieldSet = new HashSet();
                for (FilterDto joinDto : joinDtos) {
                    DynamicObject subSelectedField = RuleSettingUtils.getSubSelectedFields(joinDto);
                    if (null == subSelectedField) continue;
                    String subSelectFields = subSelectedField.getString(FIELD_NAME);
                    String subTable = subSelectedField.getString(FIELD_SUB_NAME);
                    StringBuilder subField = (StringBuilder)fieldsMap.get(subTable);
                    Long subTableId = subSelectedField.getLong("tableid");
                    if (groupFieldMap.containsKey(subTableId)) {
                        HashSet<String> selectFieldSet = new HashSet<String>(Arrays.asList(subField.toString().split(",")));
                        selectFieldSet.addAll((Collection<String>)groupFieldMap.get(subTableId));
                        subField = new StringBuilder(String.join((CharSequence)",", selectFieldSet));
                    }
                    if (StringUtils.isNotBlank((CharSequence)subField)) {
                        ArrayList<String> newFields = new ArrayList<String>(subField.toString().split(",").length);
                        HashSet<String> newSelectFields = new HashSet<String>(subField.toString().split(",").length);
                        ArrayList<String> subFieldList = new ArrayList<String>(Arrays.asList(subField.toString().split(",")));
                        for (String field : subFieldList) {
                            if (mainFieldSet.contains(field) || subFieldSet.contains(field)) {
                                String tempFields = field + " as " + subTable + "_" + field;
                                if (!duplicateMap.containsKey(subTable)) {
                                    duplicateMap.put(subTable, new ArrayList());
                                }
                                ((List)duplicateMap.get(subTable)).add(field);
                                if (groupFieldMap.containsKey(subTableId)) {
                                    Set<String> filedList = groupFieldMap.get(subTableId);
                                    ArrayList<String> groupList = new ArrayList<String>(16);
                                    for (String s : filedList) {
                                        if (StringUtils.equals((CharSequence)field, (CharSequence)s)) {
                                            groupList.add(subTable + "_" + s);
                                            continue;
                                        }
                                        groupList.add(s);
                                    }
                                    groupFieldMap.put(subTableId, new HashSet(groupList));
                                }
                                newSelectFields.add(tempFields);
                                newFields.add(subTable + "_" + field);
                                continue;
                            }
                            newSelectFields.add(field);
                            newFields.add(field);
                        }
                        subFieldSet.addAll(newFields);
                        newSelectFields.add(subSelectFields);
                        subField = new StringBuilder(String.join((CharSequence)",", newSelectFields));
                        subSelectFields = subField.toString();
                    }
                    List<QFilter> subFilter = filterMap.get(subTable);
                    sub = QueryServiceHelper.queryDataSet((String)RuleSettingUtils.class.getName(), (String)subTable, (String)subSelectFields, null == subFilter ? null : subFilter.toArray(new QFilter[subFilter.size()]), null);
                    String subFinalField = Arrays.stream(sub.getRowMeta().getFields()).map(a -> a.getName()).collect(Collectors.joining(CommonConstant.COMMA + ""));
                    if (joinSelectField.length() == 0) {
                        String mainFinalField = Arrays.stream(main.getRowMeta().getFields()).map(a -> a.getName()).collect(Collectors.joining(CommonConstant.COMMA + ""));
                        joinSelectField.append(mainFinalField).append(CommonConstant.COMMA).append(subFinalField);
                    } else {
                        joinSelectField.append(CommonConstant.COMMA).append(subFinalField);
                    }
                    if (null == main || null == sub || joinDto.getValue().size() == 0) continue;
                    JoinDataSet join = null;
                    join = result == null ? main.join(sub, RuleSettingUtils.getJoinType(joinDto)) : result.join(sub, RuleSettingUtils.getJoinType(joinDto));
                    Set<String> selectFieldSet = Arrays.stream(joinSelectField.toString().split(",")).collect(Collectors.toSet());
                    result = join.on(joinDto.getFieldNumber(), subSelectedField.getString(FIELD_NAME)).select(selectFieldSet.toArray(new String[selectFieldSet.size()]), null).finish();
                }
                if (groupFieldMap.size() > 0) {
                    Set<String> groupFields = groupFieldMap.entrySet().stream().flatMap(o -> ((Set)o.getValue()).stream()).collect(Collectors.toSet());
                    result = RuleSettingUtils.dealGroupDataSet(field2Func, result, groupFields);
                }
                RuleSettingUtils.getResultByLine(field2Func, res, result, duplicateMap);
            }
            finally {
                if (main != null) {
                    main.close();
                }
                if (result != null) {
                    result.close();
                }
                if (sub != null) {
                    sub.close();
                }
            }
        }
        try (DataSet result = null;){
            Set<String> groupFields = null;
            RuleSettingUtils.getGroupFields(setting, maintableNames, new ArrayList<String>(), groupFieldMap);
            if (groupFieldMap.size() > 0) {
                HashSet<String> selectFieldSet = new HashSet<String>(Arrays.asList(selectFieldwithid.toString().split(",")));
                groupFields = groupFieldMap.entrySet().stream().flatMap(o -> ((Set)o.getValue()).stream()).collect(Collectors.toSet());
                selectFieldSet.addAll(groupFields);
                selectFieldwithid = new StringBuilder(String.join((CharSequence)",", selectFieldSet));
            }
            result = QueryServiceHelper.queryDataSet((String)RuleSettingUtils.class.getName(), (String)maintableNames.get(0), (String)selectFieldwithid.toString(), (QFilter[])filterMap.get(maintableNames.get(0)).toArray(new QFilter[0]), null);
            if (CollectionUtils.isNotEmpty(groupFields)) {
                result = RuleSettingUtils.dealGroupDataSet(field2Func, result, groupFields);
                RuleSettingUtils.getResultByLine(field2Func, res, result, new HashMap<String, List<String>>());
            } else {
                RuleSettingUtils.dealResult(field2Func, res, result);
            }
        }
        return res;
    }

    private static void recordLog(ConcurrentHashMap<String, List<QFilter>> filterMap) {
        for (Map.Entry<String, List<QFilter>> entry : filterMap.entrySet()) {
            StringBuilder qFilterDesc = new StringBuilder();
            qFilterDesc.append(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u67e5\u8be2\uff0c\u6570\u636e\u6e90\u4e3a\uff1a\u3010%s\u3011, \u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a", (String)"RuleSettingUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entry.getKey()));
            for (QFilter qFilter : entry.getValue()) {
                qFilterDesc.append(qFilter).append(',');
            }
            logger.info(qFilterDesc.toString());
        }
    }

    private static void dealDistinctFields(List<String> mainTables, List<Long> fieldsIds, Map<String, StringBuilder> fieldsMap, StringBuilder selectFieldwithid) {
        DynamicObject[] distinctfields = BusinessDataServiceHelper.load((String)"bdtaxr_datasource_entry", (String)"fieldsubname,tableid", (QFilter[])new QFilter[]{new QFilter("id", "in", fieldsIds)});
        Map<Long, List<DynamicObject>> fieldEntryMap = Arrays.stream(distinctfields).collect(Collectors.groupingBy(o -> o.getLong("tableid")));
        ArrayList<Long> ids = new ArrayList<Long>(fieldEntryMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : fieldEntryMap.entrySet()) {
            ids.add(entry.getKey());
        }
        DynamicObject[] datasourceObjs = BusinessDataServiceHelper.load((String)"bdtaxr_custom_datasource", (String)"id,entityname", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Map<Long, String> datasourceMap = Arrays.stream(datasourceObjs).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString(ENTITY_NAME)));
        for (Map.Entry<Long, List<DynamicObject>> entry : fieldEntryMap.entrySet()) {
            StringBuilder selectField = new StringBuilder();
            for (DynamicObject distinctfield : entry.getValue()) {
                String amountField = distinctfield.getString(FIELD_NAME);
                String fieldsubname = distinctfield.getString(FIELD_SUB_NAME);
                if (!mainTables.contains(fieldsubname)) {
                    String field = fieldsubname + "." + amountField + " as " + amountField;
                    selectField.append(field).append(CommonConstant.COMMA);
                    selectFieldwithid.append(field).append(CommonConstant.COMMA);
                    continue;
                }
                selectField.append(amountField).append(CommonConstant.COMMA);
                selectFieldwithid.append(amountField).append(CommonConstant.COMMA);
            }
            selectField.deleteCharAt(selectField.length() - 1);
            fieldsMap.put(datasourceMap.get(entry.getKey()), selectField);
        }
        selectFieldwithid.deleteCharAt(selectFieldwithid.length() - 1);
    }

    private static Map<String, String> buildFuncMap(DynamicObjectCollection collection, List<Long> fieldsIds, Map<String, Long> mainTables) {
        Map<Long, String> idMap = mainTables.entrySet().stream().collect(Collectors.toMap(k -> (Long)k.getValue(), v -> (String)v.getKey(), (m, n) -> m));
        HashMap<String, String> field2Func = new HashMap<String, String>();
        for (DynamicObject dyo : collection) {
            String key;
            String field = dyo.getDynamicObject(DISTINCT_FIELD).getString(FIELD_NAME);
            String fieldsubname = dyo.getDynamicObject(DISTINCT_FIELD).getString(FIELD_SUB_NAME);
            Long maintableid = dyo.getDynamicObject(DISTINCT_FIELD).getLong("tableid");
            if (!mainTables.containsKey(fieldsubname) && maintableid != null && idMap.containsKey(maintableid)) {
                fieldsubname = idMap.get(maintableid);
            }
            if (!field2Func.containsKey(key = fieldsubname + '#' + field)) {
                fieldsIds.add(dyo.getDynamicObject(DISTINCT_FIELD).getLong("id"));
            }
            field2Func.put(key, dyo.getString("func"));
        }
        return field2Func;
    }

    private static void dealResult(Map<String, String> field2Func, List<Map<String, Object>> res, DataSet result) {
        if (result != null && !result.isEmpty()) {
            boolean onlyOneRow = false;
            for (Map.Entry<String, String> fieldFunc : field2Func.entrySet()) {
                if (!"count".equals(fieldFunc.getValue()) && !"sum".equals(fieldFunc.getValue()) && !"max".equals(fieldFunc.getValue()) && !"min".equals(fieldFunc.getValue())) continue;
                onlyOneRow = true;
                break;
            }
            if (onlyOneRow) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                for (Map.Entry<String, String> fieldFunc : field2Func.entrySet()) {
                    String key = fieldFunc.getKey();
                    String fieldName = key.split("#")[1];
                    String filedKey = key.split("#")[0];
                    if (fieldName.split("\\.").length > 1) {
                        key = filedKey + '#' + fieldName.split("\\.")[1];
                    }
                    DataSet copy = result.copy();
                    if (StringUtils.isEmpty((CharSequence)fieldFunc.getValue())) {
                        Iterator it = copy.iterator();
                        if (it.hasNext()) {
                            temp.put(key, ((Row)it.next()).get(fieldName));
                            continue;
                        }
                        temp.put(key, new Object());
                        continue;
                    }
                    temp.put(key, RuleSettingUtils.getResuleByFunc(copy, fieldName, fieldFunc.getValue()));
                }
                res.add(temp);
            } else {
                RuleSettingUtils.getResultByLine(field2Func, res, result, new HashMap<String, List<String>>());
            }
        }
    }

    private static DataSet dealGroupDataSet(Map<String, String> field2Func, DataSet result, Set<String> groupFields) {
        GroupbyDataSet groupbyDataSet = result.groupBy(groupFields.toArray(new String[groupFields.size()]));
        for (Map.Entry<String, String> entry : field2Func.entrySet()) {
            String fieldName = entry.getKey().split("#")[1];
            if (groupFields.contains(fieldName) || "distinct".equals(entry.getValue())) continue;
            if ("count".equals(entry.getValue())) {
                groupbyDataSet.count(fieldName);
                continue;
            }
            if ("sum".equals(entry.getValue())) {
                groupbyDataSet.sum(fieldName);
                continue;
            }
            if ("max".equals(entry.getValue())) {
                groupbyDataSet.max(fieldName);
                continue;
            }
            if (!"min".equals(entry.getValue())) continue;
            groupbyDataSet.min(fieldName);
        }
        result = groupbyDataSet.finish();
        return result;
    }

    private static Map<Long, Set<String>> getGroupFields(DynamicObject setting, List<String> mainTables, List<String> joinTables, Map<Long, Set<String>> groupFieldMap) {
        DynamicObjectCollection groupCollection = setting.getDynamicObjectCollection(GROUP_FIELDS);
        if (CollectionUtils.isNotEmpty((Collection)groupCollection)) {
            groupCollection.stream().forEach(o -> {
                String fieldsubname = o.getDynamicObject("fbasedataid").getString(FIELD_SUB_NAME);
                String groupField = o.getDynamicObject("fbasedataid").getString(FIELD_NAME);
                Long tableId = o.getDynamicObject("fbasedataid").getLong("tableid");
                if (!groupFieldMap.containsKey(tableId)) {
                    groupFieldMap.put(tableId, new HashSet());
                }
                if (!mainTables.contains(fieldsubname) && !joinTables.contains(fieldsubname)) {
                    ((Set)groupFieldMap.get(tableId)).add(fieldsubname + "." + groupField);
                } else {
                    ((Set)groupFieldMap.get(tableId)).add(groupField);
                }
            });
        }
        return groupFieldMap;
    }

    private static void getResultByLine(Map<String, String> field2Func, List<Map<String, Object>> res, DataSet dataSet, Map<String, List<String>> duplicateMap) {
        for (Row row : dataSet) {
            HashMap<String, Object> lineResult = new HashMap<String, Object>(field2Func.size());
            for (Map.Entry<String, String> fieldFunc : field2Func.entrySet()) {
                String key = fieldFunc.getKey();
                String filedKey = key.split("#")[0];
                String field = key.split("#")[1];
                if (field.split("\\.").length > 1) {
                    key = filedKey + '#' + field.split("\\.")[1];
                }
                if ("abs".equals(fieldFunc.getValue())) {
                    if (duplicateMap.containsKey(filedKey)) {
                        Iterator<String> iterator = duplicateMap.get(key).iterator();
                        if (!iterator.hasNext()) continue;
                        String fieldName = iterator.next();
                        if (StringUtils.equals((CharSequence)field, (CharSequence)fieldName)) {
                            lineResult.put(key, row.getBigDecimal(filedKey + "_" + field).abs());
                            continue;
                        }
                        lineResult.put(key, row.getBigDecimal(field).abs());
                        continue;
                    }
                    lineResult.put(key, row.getBigDecimal(fieldFunc.getKey().split("#")[1]).abs());
                    continue;
                }
                if (duplicateMap.containsKey(filedKey)) {
                    for (String fieldName : duplicateMap.get(filedKey)) {
                        if (StringUtils.equals((CharSequence)field, (CharSequence)fieldName)) {
                            lineResult.put(key, row.get(filedKey + "_" + field));
                            continue;
                        }
                        lineResult.put(key, row.get(field));
                    }
                    continue;
                }
                lineResult.put(key, row.get(field));
            }
            res.add(lineResult);
        }
    }

    private static List<Object> getDataSourceIdByField(List<Long> distinctFieldIds) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bdtaxr_datasource_entry", (String)"tableid", (QFilter[])new QFilter[]{new QFilter("id", "in", distinctFieldIds)});
        if (CollectionUtils.isEmpty((Collection)objs)) {
            return null;
        }
        List ids = objs.stream().map(o -> o.getLong("tableid")).collect(Collectors.toList());
        DynamicObjectCollection dataSources = QueryServiceHelper.query((String)"bdtaxr_custom_datasource", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (CollectionUtils.isNotEmpty((Collection)dataSources)) {
            return dataSources.stream().map(o -> o.get("id")).collect(Collectors.toList());
        }
        return null;
    }
}

