/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.showpage;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;

public class PageShowCommon {
    public static final String FORM = "Form";
    public static final String BILL = "Bill";
    public static final String BILL_LIST = "BillList";

    public static void showForm(ShowType showType, String pageName, IFormView view, Map<String, Object> customParams, IFormPlugin plugin) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(pageName);
        if (customParams == null) {
            param.setCustomParams(new HashMap());
        } else {
            param.setCustomParams(customParams);
        }
        if (customParams != null && customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(showType);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, pageName);
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }

    public static void showForm(ShowType showType, StyleCss styleCss, String pageName, IFormView view, Map<String, Object> customParams, IFormPlugin plugin) {
        PageShowCommon.showForm(OperationStatus.ADDNEW, showType, styleCss, pageName, view, customParams, plugin);
    }

    public static void showForm(OperationStatus operationStatus, ShowType showType, String pageName, IFormView view, Map<String, Object> customParams, IFormPlugin plugin) {
        PageShowCommon.showForm(operationStatus, showType, null, pageName, view, customParams, plugin);
    }

    public static void showForm(OperationStatus operationStatus, ShowType showType, StyleCss styleCss, String pageName, IFormView view, Map<String, Object> customParams, IFormPlugin plugin) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(pageName);
        if (customParams == null) {
            param.setCustomParams(new HashMap());
        } else {
            param.setCustomParams(customParams);
        }
        if (customParams != null && customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(showType);
        if (showType == ShowType.Modal && styleCss != null) {
            param.getOpenStyle().setInlineStyleCss(styleCss);
        }
        CloseCallBack closeCallBack = new CloseCallBack(plugin, pageName);
        param.setCloseCallBack(closeCallBack);
        param.setStatus(operationStatus);
        view.showForm(param);
    }

    public static void showForm(String targetKey, String pageName, IFormView view, Map<String, Object> customParams) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(pageName);
        if (customParams == null) {
            param.setCustomParams(new HashMap());
        } else {
            param.setCustomParams(customParams);
        }
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(targetKey);
        view.showForm(param);
    }

    public static String showBillList(ShowType showType, String pageName, IFormView view, Map<String, Object> customParams) {
        return PageShowCommon.showBillList(showType, pageName, view, customParams, null);
    }

    public static String showBillList(ShowType showType, String pageName, IFormView view, Map<String, Object> customParams, String title) {
        return PageShowCommon.showBillList("bos_list", showType, pageName, view, customParams, title);
    }

    public static String showBillList(String formId, ShowType showType, String pageName, IFormView view, Map<String, Object> customParams, String title) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId(formId);
        if (customParams == null) {
            listShowParameter.setCustomParams(new HashMap());
        } else {
            listShowParameter.setCustomParams(customParams);
        }
        listShowParameter.getOpenStyle().setShowType(showType);
        if (title != null) {
            listShowParameter.setCaption(title);
        }
        view.showForm((FormShowParameter)listShowParameter);
        return listShowParameter.getPageId();
    }

    public static String showBillList(String targetKey, String pageName, IFormView view, Map<String, Object> customParams) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId("bos_list");
        if (customParams == null) {
            listShowParameter.setCustomParams(new HashMap());
        } else {
            listShowParameter.setCustomParams(customParams);
        }
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        view.showForm((FormShowParameter)listShowParameter);
        return listShowParameter.getPageId();
    }

    public static void showBillList(ShowType showType, String pageName, IFormView view, Map<String, Object> customParams, String title, QFilter filter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId("bos_list");
        if (customParams == null) {
            listShowParameter.setCustomParams(new HashMap());
        } else {
            listShowParameter.setCustomParams(customParams);
        }
        if (filter != null) {
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
        listShowParameter.getOpenStyle().setShowType(showType);
        if (title != null) {
            listShowParameter.setCaption(title);
        }
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void showBillList(ShowType showType, String pageName, String pagetId, IFormView view, Map<String, Object> customParams, LinkQueryPkIdCollection linkQueryPkIdCollection) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId("bos_list");
        if (null != pagetId) {
            listShowParameter.setPageId(pagetId);
        }
        if (customParams == null) {
            listShowParameter.setCustomParams(new HashMap());
        } else {
            listShowParameter.setCustomParams(customParams);
        }
        if (null != linkQueryPkIdCollection) {
            listShowParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        }
        listShowParameter.getOpenStyle().setShowType(showType);
        view.showForm((FormShowParameter)listShowParameter);
    }

    @Deprecated
    public static void showBill(ShowType showType, String formId, Object pkId, IFormView view, Map<String, Object> customParams, BillOperationStatus status) {
        PageShowCommon.showBill(showType, formId, pkId, view, customParams, OperationStatus.forValue((int)status.getValue()), null);
    }

    public static void showBill(ShowType showType, String formId, Object pkId, IFormView view, Map<String, Object> customParams, OperationStatus status) {
        PageShowCommon.showBill(showType, formId, pkId, view, customParams, status, null);
    }

    public static void showBill(ShowType showType, String pageName, Object pkId, IFormView view, Map<String, Object> customParams) {
        PageShowCommon.showBill(showType, pageName, pkId, view, customParams, OperationStatus.VIEW, null);
    }

    public static void showBill(ShowType showType, String formId, Object pkId, IFormView view, Map<String, Object> customParams, OperationStatus status, IFormPlugin plugin) {
        BillShowParameter billShowParameter = new BillShowParameter();
        if (customParams == null) {
            billShowParameter.setCustomParams(new HashMap());
        } else {
            billShowParameter.setCustomParams(customParams);
        }
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
        }
        billShowParameter.setStatus(status);
        billShowParameter.setFormId(formId);
        if (plugin != null) {
            CloseCallBack closeCallBack = new CloseCallBack(plugin, formId);
            billShowParameter.setCloseCallBack(closeCallBack);
        }
        billShowParameter.getOpenStyle().setShowType(showType);
        view.showForm((FormShowParameter)billShowParameter);
    }

    public static String getMetadataNumberByView(IFormView view) {
        String formId = "";
        if (view != null) {
            formId = view.getEntityId();
            if (view instanceof ListView) {
                formId = ((ListView)view).getBillFormId();
            }
        }
        return formId;
    }
}

