/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.crypto.HashUtil;
import kd.taxc.bdtaxr.common.util.crypto.MD5;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static Pattern REGEX_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");
    private static String SPECIAL_REGEX = "[^a-zA-Z0-9]";

    public static String getMatchContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Matcher matcher = REGEX_PATTERN.matcher(content);
        StringBuilder info = new StringBuilder();
        while (matcher.find()) {
            info.append(matcher.group(1));
            info.append(',');
        }
        if (info.length() > 0) {
            info.deleteCharAt(info.length() - 1);
        } else {
            info.append(content);
        }
        return info.toString();
    }

    public static String fillCharAtLeft(Object obj, int length, char fillChar) {
        return StringUtil.fillCharByPosition(obj, length, fillChar, "left");
    }

    public static String fillCharAtRight(Object obj, int length, char fillChar) {
        return StringUtil.fillCharByPosition(obj, length, fillChar, "right");
    }

    public static String fillCharByPosition(Object obj, int length, char fillChar, String type) {
        if (EmptyCheckUtils.isEmpty(obj)) {
            return String.valueOf(obj);
        }
        String str = String.valueOf(obj);
        if (str.trim().length() >= length) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int fillLength = length - str.length();
        for (int i = 0; i < fillLength; ++i) {
            sb.append(fillChar);
        }
        return "left".equalsIgnoreCase(type) ? sb.append(str).toString() : sb.insert(0, str).toString();
    }

    public static String getMd5(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            content = "";
        }
        content = content.toLowerCase().replaceAll("\\s*", "");
        return MD5.md5(content);
    }

    public static boolean eqNull(String content) {
        return "null".equals(content);
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isNumeric(String str) {
        if (null == str) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(\\-|\\+)?\\d+(\\.\\d+)?$");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static Double toNumber(String text) {
        double value = 0.0;
        try {
            value = StringUtil.isNumeric(text) ? Double.parseDouble(text) : value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static Object zeroToBlank(Object text) {
        if ("0".equals(String.valueOf(text))) {
            return "";
        }
        return text;
    }

    public static String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.toString()).append('\t').append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    public static String formatFormulaStr(String formula) {
        if (StringUtil.isNotEmpty((CharSequence)formula)) {
            return formula.replace("\n", "").replace("\t", "").replace("\r", "").replace(" ", "").trim().toLowerCase();
        }
        return "";
    }

    public static String formatStringNoBlank(String str) {
        if (StringUtil.isNotEmpty((CharSequence)str)) {
            return str.replace("\n", "").replace("\t", "").replace("\r", "").replace(" ", "").trim();
        }
        return "";
    }

    public static String removeSpecialCharacter(String str) {
        if (StringUtil.isEmpty((CharSequence)str)) {
            return str;
        }
        return str.replaceAll(SPECIAL_REGEX, "");
    }

    public static String hashFormulaStr(String formula) {
        if (StringUtil.isNotEmpty((CharSequence)formula)) {
            return ("key" + HashUtil.strHash(StringUtil.formatFormulaStr(formula))).replaceAll("-", "f");
        }
        return "";
    }

    public static String dealWithSensitive(String text) {
        if (StringUtil.isNotBlank((CharSequence)text)) {
            StringBuilder sb = new StringBuilder();
            if (text.length() > 6) {
                String startStr = text.substring(0, 3);
                String end = text.substring(text.length() - 3);
                int hideLen = text.length() - 6;
                sb.append(startStr);
                for (int i = 0; i < hideLen; ++i) {
                    sb.append("*");
                }
                sb.append(end);
            } else {
                for (int i = 0; i < text.length(); ++i) {
                    sb.append("*");
                }
            }
            return sb.toString();
        }
        return text;
    }

    public static String trimContainsChineseSpace(String input) {
        if (StringUtil.isNotBlank((CharSequence)input)) {
            return input.replaceAll("(^[ \\u00A0]*|[ \\u00A0]*$)", "").replaceAll("(^[ \\u0020]*|[ \\u0020]*$)", "").replaceAll("(^[ \\u3000]*|[ \\u3000]*$)", "");
        }
        return input;
    }

    public static String escapeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        boolean flag = text.contains("&amp;");
        int i = 0;
        while (flag) {
            text = text.replaceAll("&amp;", "&");
            flag = text.contains("&amp;") && ++i < 100;
        }
        if (text.contains("&lt;")) {
            text = text.replaceAll("&lt;", "<");
        }
        return text;
    }

    public static boolean isAnyNotBlank(String css) {
        if (StringUtil.isBlank((CharSequence)css)) {
            return false;
        }
        String[] stringArray = css.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringUtil.isNotBlank((CharSequence)stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.fillCharAtLeft(2L, 2, '0'));
    }
}

