/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.accrual;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcret.business.accrual.AccrualRequestValidator;
import kd.taxc.tcret.business.accrual.AccrualServiceHelper;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.mservice.api.AccrualService;

public class AccrualServiceImpl
implements AccrualService {
    private static Log logger = LogFactory.getLog(AccrualServiceImpl.class);
    public static final String BAD_REQUEST = "400";
    public static final String SERVICE_ERROR = "500";
    private static final String CCXWS = "TCRET_ACCRUAL_LOCK_";

    @Override
    public String generate(String request) {
        EngineResponse response = EngineResponse.success((String)ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u751f\u6210\u6210\u529f", (String)"AccrualServiceImpl_0", (String)"taxc-tcret-mservice", (Object[])new Object[0]), null);
        AccrualCalcDto accrualCalcDto = new AccrualCalcDto();
        try {
            AccrualRequest requestVo = (AccrualRequest)SerializationUtils.fromJsonString((String)request, AccrualRequest.class);
            accrualCalcDto = AccrualServiceHelper.buildAccrualCalcDto((AccrualRequest)requestVo);
            try (DLock lock = DLock.create((String)(CCXWS + requestVo.getOrgId() + DateUtils.format((Date)requestVo.getSkssqq()) + DateUtils.format((Date)requestVo.getSkssqz()) + requestVo.getCategory()));){
                if (lock.tryLock(30000L)) {
                    AccrualRequestValidator.validateAndSetDefault((AccrualCalcDto)accrualCalcDto);
                    AccrualServiceHelper.generate((AccrualCalcDto)accrualCalcDto);
                    this.setResponseData(response, accrualCalcDto);
                } else {
                    response = EngineResponse.failByMsgCode((String)ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u751f\u6210\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u4efb\u52a1\u6b63\u5728\u6267\u884c", (String)"AccrualServiceImpl_1", (String)"taxc-tcret-mservice", (Object[])new Object[0]), (String)BAD_REQUEST);
                    this.setResponseData(response, accrualCalcDto);
                }
            }
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
            response = EngineResponse.failByMsgCode((String)e.getMessage(), (String)BAD_REQUEST);
            this.setResponseData(response, accrualCalcDto);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            response = EngineResponse.failByMsgCode((String)e.getMessage(), (String)SERVICE_ERROR);
            this.setResponseData(response, accrualCalcDto);
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    private void setResponseData(EngineResponse response, AccrualCalcDto accrualCalcDto) {
        if (EmptyCheckUtils.isNotEmpty((Object)accrualCalcDto)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("skssqq", DateUtils.format((Date)accrualCalcDto.getSkssqq()));
            data.put("skssqz", DateUtils.format((Date)accrualCalcDto.getSkssqz()));
            response.setData(data);
        }
    }
}

