/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.declare;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcret.business.declare.DeclareServiceHelper;
import kd.taxc.tcret.business.declare.RequestValidator;
import kd.taxc.tcret.business.taxsource.HouseRentServiceHelper;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.business.taxsource.YhsTaxSourceServiceHelper;
import kd.taxc.tcret.mservice.api.DeclareService;
import org.apache.commons.lang.StringUtils;

public class DeclareServiceImpl
implements DeclareService {
    private static Log logger = LogFactory.getLog(DeclareServiceImpl.class);
    private DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    public static final String BAD_REQUEST = "400";
    public static final String SERVICE_ERROR = "500";
    private static final String CCXWS = "CCXWS_DECLARESERVICEIMPL_";

    @Override
    public String generate(String request) {
        EngineResponse response = EngineResponse.success((String)ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u7533\u62a5\u4efb\u52a1\u751f\u6210\u6210\u529f", (String)"DeclareServiceImpl_1", (String)"taxc-tcret-mservice", (Object[])new Object[0]), null);
        try {
            DeclareRequest requestVo = (DeclareRequest)SerializationUtils.fromJsonString((String)request, DeclareRequest.class);
            String startdate = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)requestVo.getExecuteTime()));
            try (DLock lock = DLock.create((String)(CCXWS + requestVo.getOrgId() + startdate + requestVo.getTaxauthority() + requestVo.getCategory()));){
                if (lock.tryLock(30000L)) {
                    HashSet<String> messages = new HashSet<String>();
                    RequestValidator.validateDeclareRequest((DeclareRequest)requestVo);
                    this.gatherTaxSource(requestVo.getOrgId(), requestVo.getExecuteTime(), requestVo.getTaxcatetory(), requestVo.getTaxauthority(), messages);
                    Map paramMap = DeclareServiceHelper.generate((DeclareRequest)requestVo);
                    if (messages.size() > 0) {
                        response.setMessage(StringUtil.join(messages, (String)""));
                    }
                    response.setData((Object)paramMap);
                } else {
                    response = EngineResponse.failByMsgCode((String)ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u7533\u62a5\u4efb\u52a1\u751f\u6210\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u4efb\u52a1\u6b63\u5728\u6267\u884c", (String)"DeclareServiceImpl_2", (String)"taxc-tcret-mservice", (Object[])new Object[0]), (String)BAD_REQUEST);
                }
            }
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
            response = EngineResponse.failByMsgCode((String)e.getMessage(), (String)BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            response = EngineResponse.failByMsgCode((String)e.getMessage(), (String)SERVICE_ERROR);
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    @Override
    public Map<String, Object> getProcessedDeclareData(Long modelId, Long sbbId) {
        HashMap result = new HashMap();
        TaxResult taxResult = DeclareDataServiceHelper.queryDeclareData((Long)modelId, (Long)sbbId);
        if (taxResult == null || !taxResult.isSuccess() || taxResult.getData() == null) {
            return ServiceResultUtils.returnResultHandler((boolean)true, (String)"200", (String)"", result);
        }
        DeclareResponseModel declareResponseModel = (DeclareResponseModel)taxResult.getData();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)sbbId, (String)"tcvat_nsrxx");
        DeclareCustomParamsHelper.setDeclareRequestData((DynamicObject)object, result);
        DeclareRequestModel requestModel = this.declareRequestService.build((String)result.get("declareRequestData"));
        Map typeMap = DeclareReportHelpService.getEntityFieldsByMetadata((DeclareRequestModel)requestModel, (List)declareResponseModel.getDynRowList());
        result.putAll(declareResponseModel.getData());
        List dynRowList = declareResponseModel.getDynRowList();
        if (CollectionUtils.isEmpty((Collection)dynRowList)) {
            return ServiceResultUtils.returnResultHandler((boolean)true, (String)"200", (String)"", result);
        }
        HashMap<String, Map<String, String>> zbMap = new HashMap<String, Map<String, String>>();
        HashMap jmResult = new HashMap();
        for (DynamicRowModel dynamicRowModel : dynRowList) {
            List rowList = dynamicRowModel.getRowList();
            if ("tcret_ccxws_zb_hb#1".equals(dynamicRowModel.getDynRowNo())) {
                this.setZbMapData(declareResponseModel, zbMap, dynamicRowModel, rowList);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)rowList)) continue;
            HashSet<String> jmxzdmList = new HashSet<String>(16);
            ArrayList<HashMap<String, String>> jmList = new ArrayList<HashMap<String, String>>(8);
            String jmResultKey = null;
            for (Map jmCol : rowList) {
                this.handlePrecision(jmCol, typeMap);
                HashMap<String, String> hashMap = new HashMap<String, String>(8);
                for (Map.Entry entry : jmCol.entrySet()) {
                    String key2 = (String)entry.getKey();
                    String[] split = key2.split("#");
                    jmResultKey = split[0];
                    hashMap.put(split[2], (String)entry.getValue());
                    if (!"jmxzdm".equals(split[2])) continue;
                    this.doSetJmInfo(hashMap, jmxzdmList, (String)entry.getValue());
                }
                jmList.add(hashMap);
            }
            DynamicObjectCollection jmObjs = QueryServiceHelper.query((String)"tpo_taxdeduction", (String)"number,secondcode,name", (QFilter[])new QFilter[]{new QFilter("number", "in", jmxzdmList)});
            if (!CollectionUtils.isEmpty((Collection)jmObjs)) {
                for (Map map : jmList) {
                    jmObjs.stream().filter(j -> j.getString("number").equals(jmCol.get("jmxzdm")) && j.getString("name").equals(jmCol.get("jmxzshowdata"))).findFirst().ifPresent(dynamicObject -> jmCol.put("swsxdm", dynamicObject.getString("secondcode")));
                }
            }
            jmResult.put(jmResultKey, jmList);
        }
        ArrayList zbList = new ArrayList(8);
        HashMap zbResult = new HashMap(8);
        for (Map zbCol : zbMap.values()) {
            this.handlePrecision(zbCol, typeMap);
            HashMap zbListMap = new HashMap();
            zbCol.forEach((key, value) -> {
                String[] split = key.split("#");
                zbListMap.put(split[2], value);
            });
            zbList.add(zbListMap);
        }
        zbResult.put("tcret_ccxws_zb_hb", zbList);
        result.put("zbData", zbResult);
        result.put("jmData", jmResult);
        return ServiceResultUtils.returnResultHandler((boolean)true, (String)"200", (String)"", result);
    }

    private void handlePrecision(Map<String, String> jmCol, Map<String, EntityField> typeMap) {
        jmCol.forEach((k, v) -> {
            EntityField entityField = (EntityField)typeMap.get(k);
            if (entityField != null && "Decimal".equals(entityField.getFieldType())) {
                try {
                    if (StringUtil.isEmpty((CharSequence)v)) {
                        v = BigDecimal.ZERO.toString();
                    }
                    BigDecimal bd = new BigDecimal((String)v);
                    bd = bd.setScale(2, RoundingMode.HALF_UP);
                    jmCol.put((String)k, bd.toPlainString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void doSetJmInfo(Map<String, String> jmListMap, Set<String> jmxzdmList, String jmxzdm) {
        if (StringUtil.isEmpty((CharSequence)jmxzdm)) {
            return;
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(jmxzdm);
        if (m.find()) {
            String dm = m.group();
            jmListMap.put("jmxzdm", dm);
            jmxzdmList.add(dm);
            jmListMap.put("jmxzshowdata", jmxzdm.substring(dm.length()));
        }
    }

    private void setZbMapData(DeclareResponseModel declareResponseModel, Map<String, Map<String, String>> zbMap, DynamicRowModel dynamicRowModel, List<Map<String, String>> rowList) {
        HashMap<String, Integer> firstKeyRowIndexMap = new HashMap<String, Integer>(8);
        DynamicObjectCollection declareQueryCollection = QueryServiceHelper.query((String)"tcret_declare_main", (String)"id, entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)declareResponseModel.getId())});
        for (int i = 0; i < rowList.size(); ++i) {
            String sm;
            int currentRowIndex;
            Map<String, String> rowMap = rowList.get(i);
            String taxType = rowMap.get(this.getZbKey(currentRowIndex = this.getCurrentRowIndex(rowMap, dynamicRowModel.getStartRow().intValue(), rowList.size()), "taxtype"));
            String firstKey = taxType.concat(sm = rowMap.get(this.getZbKey(currentRowIndex, "sm")));
            if (zbMap.containsKey(firstKey)) {
                this.addToFirstKeyRow(zbMap, firstKey, (Integer)firstKeyRowIndexMap.get(firstKey), rowMap, currentRowIndex);
                continue;
            }
            DynamicObject temp = declareQueryCollection.stream().filter(d -> this.isTaxTypeAndSmMatched(d.getString("taxtype"), taxType, sm)).findFirst().orElse(null);
            if (temp != null) {
                rowMap.put(this.getZbKey(currentRowIndex, "startdate"), temp.getString("skssqq"));
                rowMap.put(this.getZbKey(currentRowIndex, "enddate"), temp.getString("skssqz"));
            }
            zbMap.put(firstKey, rowMap);
            firstKeyRowIndexMap.put(firstKey, currentRowIndex);
        }
    }

    private boolean isTaxTypeAndSmMatched(String taxSourceTaxType, String declareTaxType, String sm) {
        if ("fcscj".equals(taxSourceTaxType) && DeclareTaxType.FCS.getLocalTaxName().equals(declareTaxType) && ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsFetchDataService_2", (String)"taxc-tcret", (Object[])new Object[0]).equals(sm)) {
            return true;
        }
        if ("fcscz".equals(taxSourceTaxType) && DeclareTaxType.FCS.getLocalTaxName().equals(declareTaxType) && ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsFetchDataService_1", (String)"taxc-tcret", (Object[])new Object[0]).equals(sm)) {
            return true;
        }
        return "cztdsys".equals(taxSourceTaxType) && DeclareTaxType.CZTDSYS.getLocalTaxName().equals(declareTaxType);
    }

    private int getCurrentRowIndex(Map<String, String> rowMap, int startRow, int size) {
        for (int i = 0; i < size; ++i) {
            if (!rowMap.containsKey(this.getZbKey(startRow + i, "taxtype"))) continue;
            return startRow + i;
        }
        return 0;
    }

    private void addToFirstKeyRow(Map<String, Map<String, String>> zbMap, String key, int firstKeyRowIndex, Map<String, String> rowMap, long currentRowIndex) {
        Map<String, String> originKeyMap = zbMap.get(key);
        originKeyMap.put(this.getZbKey(firstKeyRowIndex, "jsyj"), BigDecimalUtil.addObject((Object)originKeyMap.get(this.getZbKey(firstKeyRowIndex, "jsyj")), (Object)rowMap.get(this.getZbKey(currentRowIndex, "jsyj"))).toString());
        originKeyMap.put(this.getZbKey(firstKeyRowIndex, "ynse"), BigDecimalUtil.addObject((Object)originKeyMap.get(this.getZbKey(firstKeyRowIndex, "ynse")), (Object)rowMap.get(this.getZbKey(currentRowIndex, "ynse"))).toString());
        originKeyMap.put(this.getZbKey(firstKeyRowIndex, "jmse"), BigDecimalUtil.addObject((Object)originKeyMap.get(this.getZbKey(firstKeyRowIndex, "jmse")), (Object)rowMap.get(this.getZbKey(currentRowIndex, "jmse"))).toString());
        originKeyMap.put(this.getZbKey(firstKeyRowIndex, "yjse"), BigDecimalUtil.addObject((Object)originKeyMap.get(this.getZbKey(firstKeyRowIndex, "yjse")), (Object)rowMap.get(this.getZbKey(currentRowIndex, "yjse"))).toString());
        originKeyMap.put(this.getZbKey(firstKeyRowIndex, "ybse"), BigDecimalUtil.addObject((Object)originKeyMap.get(this.getZbKey(firstKeyRowIndex, "ybse")), (Object)rowMap.get(this.getZbKey(currentRowIndex, "ybse"))).toString());
    }

    private String getZbKey(long l, String field) {
        return "tcret_ccxws_zb_hb#" + l + "#" + field;
    }

    private void gatherTaxSource(String orgId, Date declareMonth, String taxcatetory, Long taxauthority, Set<String> messages) {
        Date date = DateUtils.addMonth((Date)declareMonth, (int)-1);
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)date);
        Date skssqz = DateUtils.getLastDateOfMonth1((Date)date);
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(orgId));
        boolean hasLicense = LicenseCheckServiceHelper.check((Object)orgId, null, (String)"tcret");
        List<Object> taxcatetoryList = new ArrayList();
        if (StringUtils.isNotBlank((String)taxcatetory)) {
            taxcatetoryList = Arrays.stream(taxcatetory.split(",")).collect(Collectors.toList());
        }
        if ((taxcatetory == null || taxcatetoryList.contains(String.valueOf(BaseTaxCategory.FCS))) && !hasLicense) {
            HouseRentServiceHelper.gatherHouseRent((String)orgId, (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (Long)taxauthority);
        }
        if (taxcatetory == null || taxcatetoryList.contains(String.valueOf(BaseTaxCategory.YHS))) {
            for (String taxLimit : TaxConstant.TAX_LIMITS) {
                Map skssqzMap = DateUtils.getSkssqzMap((Date)declareMonth, (String)taxLimit);
                if (skssqzMap == null) continue;
                if (zeroDeclare) {
                    YhsTaxSourceServiceHelper.gatherZeroDeclareTaxSource((long)Long.parseLong(orgId), (Date)((Date)skssqzMap.get("skssqq")), (Date)((Date)skssqzMap.get("skssqz")));
                    continue;
                }
                if (hasLicense) continue;
                YhsAccountServiceHelper.createAccount((Long)Long.parseLong(orgId), (Date)((Date)skssqzMap.get("skssqq")), (Date)((Date)skssqzMap.get("skssqz")));
                YhsTaxSourceServiceHelper.gatherTaxSource((Long)Long.parseLong(orgId), (Date)((Date)skssqzMap.get("skssqq")), (Date)((Date)skssqzMap.get("skssqz")), (List)Lists.newArrayList(), (boolean)false, messages, (String)taxLimit);
            }
        }
    }
}

