/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class FcsAccrualdetailUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(FcsAccrualdetailUpgradeService.class);
    private static final String SQL_SELECT1 = "select f.forgid,m.fitemno,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)";
    private static final String SQL_SELECT2 = "select fid,ftaxpaylimit,forg,fnumber from t_tdm_fcs_basic_info";
    private static final String SQL_SELECT3 = "select f.forgid,m.fitemno,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)";
    private static final String SQL_SELECT4 = "select fid,ffcsbyhirelimit,forg,fleasecontractno from t_tdm_house_rental_info";
    private static final String SQL_SELECT5 = "select f.forgid,m.fprojectname,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)";
    private static final String SQL_SELECT6 = "select f.fid,f.ftaxpaylimit,f.forg,m.fname from t_tdm_fcs_basic_info f inner join t_tdm_fcs_basic_info_l m on f.fid = m.fid where m.flocaleid = 'zh_CN'";
    private static final String SQL_SELECT7 = "select f.forgid,m.fprojectname,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)";
    private static final String SQL_SELECT8 = "select f.fid,f.ffcsbyhirelimit,f.forg,m.fbuildingname from t_tdm_house_rental_info f inner join t_tdm_house_rental_info_l m on f.fid = m.fid where m.flocaleid = 'zh_CN'";
    private static final String SQL_SELECT9 = "select f.forgid,m.fitemno,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 9 and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)";
    private static final String SQL_SELECT10 = "select fid,ftaxtimelimit,forgid,fnumber from t_tdm_tds_basic_info";
    private static final String SQL_SELECT11 = "select f.forgid,m.fprojectname,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 9 and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)";
    private static final String SQL_SELECT12 = "select f.fid,f.ftaxtimelimit,f.forgid,m.fname from t_tdm_tds_basic_info f inner join t_tdm_tds_basic_info_l m on f.fid = m.fid where m.flocaleid = 'zh_CN'";
    private static final String SQL_UPDATE1 = "update t_tcret_accrual_entry set ftaxsourceid = ?,ftaxlimit = ? where fentryid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String czjz = ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsAccrualdetailUpgradeService_0", (String)"taxc-tcret-mservice", (Object[])new Object[0]);
        String cjjz = ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsAccrualdetailUpgradeService_1", (String)"taxc-tcret-mservice", (Object[])new Object[0]);
        this.updateTable("t_tdm_fcs_basic_info", "select f.forgid,m.fitemno,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)", cjjz, SQL_SELECT2, "FNUMBER", "FTAXPAYLIMIT", "FITEMNO", "FORG");
        this.updateTable("t_tdm_house_rental_info", "select f.forgid,m.fitemno,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)", czjz, SQL_SELECT4, "FLEASECONTRACTNO", "FFCSBYHIRELIMIT", "FITEMNO", "FORG");
        this.updateTable("t_tdm_fcs_basic_info", "select f.forgid,m.fprojectname,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)", cjjz, SQL_SELECT6, "FNAME", "FTAXPAYLIMIT", "FPROJECTNAME", "FORG");
        this.updateTable("t_tdm_house_rental_info", "select f.forgid,m.fprojectname,m.fentryid from t_tpo_declare_main_tsd f inner join t_tcret_accrual_entry m on f.fid = m.fid where f.ftaxtype = 7 and m.ftaxitem = '%s' and (m.ftaxsourceid = 0 or m.ftaxsourceid is null)", czjz, SQL_SELECT8, "FBUILDINGNAME", "FFCSBYHIRELIMIT", "FPROJECTNAME", "FORG");
        this.updateTable("t_tdm_tds_basic_info", SQL_SELECT9, "", SQL_SELECT10, "FNUMBER", "FTAXTIMELIMIT", "FITEMNO", "FORGID");
        this.updateTable("t_tdm_tds_basic_info", SQL_SELECT11, "", SQL_SELECT12, "FNAME", "FTAXTIMELIMIT", "FPROJECTNAME", "FORGID");
    }

    private void updateTable(String tableName, String sql1, String item, String sql2, String number, String taxlimit, String field, String orgfield) {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tpo_declare_main_tsd") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)tableName)) {
            List query1 = DBUtils.query((String)String.format(sql1, item));
            List query2 = DBUtils.query((String)sql2);
            if (EmptyCheckUtils.isNotEmpty((Object)query1)) {
                Map<String, Object> idMap = query2.stream().collect(Collectors.toMap(a -> a.get(orgfield) + "" + a.get(number) + "", b -> b.get("FID"), (m, n) -> m));
                Map<String, Object> taxlimitMap = query2.stream().collect(Collectors.toMap(a -> a.get(orgfield) + "" + a.get(number) + "", b -> b.get(taxlimit), (m, n) -> m));
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (Map row : query1) {
                    if (idMap.get(row.get("FORGID") + "" + row.get(field) + "") == null) continue;
                    Object fid = idMap.get(row.get("FORGID") + "" + row.get(field) + "");
                    Object ftaxlimit = taxlimitMap.get(row.get("FORGID") + "" + row.get(field) + "");
                    Object fentryid = row.get("FENTRYID");
                    paramList.add(new Object[]{fid, ftaxlimit, fentryid});
                }
                try (TXHandle h = TX.required();){
                    try {
                        if (EmptyCheckUtils.isNotEmpty(paramList)) {
                            DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE1, paramList);
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
        }
    }
}

