/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class SolidWasteSourceUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SolidWasteSourceUpgradeService.class);
    private static final String SQL_SELECT_SOLID_WASTE = "select fid,fnumber from t_tdm_solid_waste_info where fpollutiondataid = 0 or fpollutiondataid is null";
    private static final String SQL_SELECT_POLLUTION = "select fid,fnumber from t_tcret_pollution_basedat where fnumber in (%s)";
    private static final String SQL_SELECT_SOLID_WASTE_TP = "select fid,fnumber from t_tdm_solidwaste_info_tp where fpollutiondataid = 0 or fpollutiondataid is null";
    private static final String SQL_UPDATE_SOLID_WASTE = "update t_tdm_solid_waste_info set fpollutiondataid = ? where fid = ?";
    private static final String SQL_UPDATE_SOLID_WASTE_TP = "update t_tdm_solidwaste_info_tp set fpollutiondataid = ? where fid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
            this.updateTp();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tdm_solid_waste_info") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcret_pollution_basedat") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_SOLID_WASTE)))) {
            List numbers = needUpdateDatas.stream().map(s -> s.get("FNUMBER")).map(s -> "'" + s + "'").collect(Collectors.toList());
            List pollutionDatas = DBUtils.query((String)String.format(SQL_SELECT_POLLUTION, StringUtils.join((Object[])numbers.toArray(), (String)",")));
            Map<String, Object> idMap = pollutionDatas.stream().collect(Collectors.toMap(a -> a.get("FNUMBER") + "", b -> b.get("FID"), (m, n) -> m));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : needUpdateDatas) {
                if (idMap.get(row.get("FNUMBER") + "") == null) continue;
                Object fid = row.get("FID");
                Object fpollutiondataid = idMap.get(row.get("FNUMBER") + "");
                paramList.add(new Object[]{fpollutiondataid, fid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE_SOLID_WASTE, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }

    private void updateTp() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tdm_solidwaste_info_tp") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcret_pollution_basedat") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_SOLID_WASTE_TP)))) {
            List numbers = needUpdateDatas.stream().map(s -> s.get("FNUMBER")).map(s -> "'" + s + "'").collect(Collectors.toList());
            List pollutionDatas = DBUtils.query((String)String.format(SQL_SELECT_POLLUTION, StringUtils.join((Object[])numbers.toArray(), (String)",")));
            Map<String, Object> idMap = pollutionDatas.stream().collect(Collectors.toMap(a -> a.get("FNUMBER") + "", b -> b.get("FID"), (m, n) -> m));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : needUpdateDatas) {
                if (idMap.get(row.get("FNUMBER") + "") == null) continue;
                Object fid = row.get("FID");
                Object fpollutiondataid = idMap.get(row.get("FNUMBER") + "");
                paramList.add(new Object[]{fpollutiondataid, fid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE_SOLID_WASTE_TP, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

