/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TcretCcxwsInfoDateUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcretCcxwsInfoDateUpgradeService.class);
    private static final String SQL_SELECT_CCXWS_INFO = "select fid,fsbbid,fskssqq,fskssqz from t_tcret_ccxws_info where fislslf = '1' and fskssqq is null and fskssqz is null";
    private static final String SQL_SELECT_CCXWS_ZB = "select fid,fsbbid,fstartdate,fenddate from t_tcret_ccxws_zb_hb where fsbbid in (%s)";
    private static final String SQL_UPDATE = "update t_tcret_ccxws_info set fskssqq = ?,fskssqz = ? where fid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcret_ccxws_zb_hb") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcret_ccxws_info") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_CCXWS_INFO)))) {
            List sbbIds = needUpdateDatas.stream().map(s -> s.get("FSBBID")).map(s -> "'" + s + "'").collect(Collectors.toList());
            List declareMainDatas = DBUtils.query((String)String.format(SQL_SELECT_CCXWS_ZB, StringUtils.join((Object[])sbbIds.toArray(), (String)",")));
            Map<Object, List<Map>> sbbidMap = declareMainDatas.stream().collect(Collectors.groupingBy(a -> a.get("FSBBID")));
            HashMap sbbidDateMap = new HashMap(10);
            for (Map.Entry<Object, List<Map>> entry : sbbidMap.entrySet()) {
                HashMap dateMap = new HashMap(10);
                List startDates = entry.getValue().stream().filter(a -> a.get("FSTARTDATE") != null).map(a -> (Date)a.get("FSTARTDATE")).collect(Collectors.toList());
                List endDates = entry.getValue().stream().filter(a -> a.get("FENDDATE") != null).map(a -> (Date)a.get("FENDDATE")).collect(Collectors.toList());
                dateMap.put("FSTARTDATE", Collections.min(startDates));
                dateMap.put("FENDDATE", Collections.max(endDates));
                sbbidDateMap.put(entry.getKey(), dateMap);
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : needUpdateDatas) {
                if (sbbidDateMap.get(row.get("FSBBID") + "") == null) continue;
                Object fid = row.get("FID");
                Object fskssqq = ((Map)sbbidDateMap.get(row.get("FSBBID") + "")).get("FSTARTDATE");
                Object fskssqz = ((Map)sbbidDateMap.get(row.get("FSBBID") + "")).get("FENDDATE");
                paramList.add(new Object[]{fskssqq, fskssqz, fid});
            }
            try (TXHandle tXHandle = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE, paramList);
                    }
                }
                catch (Exception e) {
                    tXHandle.markRollback();
                }
            }
        }
    }
}

