/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TcretQueryReportUpgradeNewPlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcretQueryReportUpgradeNewPlugin.class);
    private static final String SEPARATOR = "_";
    private final Map<String, String> taxTypeMap = new HashMap<String, String>(){
        {
            this.put(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"TcretQueryReportUpgradePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), "cztdsys");
            this.put(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TcretQueryReportUpgradePlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), "yhs");
            this.put(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"TcretQueryReportUpgradePlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), "fcs");
            this.put(ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"TcretQueryReportUpgradePlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), "hbs");
            this.put(ResManager.loadKDString((String)"\u8f66\u8239\u7a0e", (String)"TcretQueryReportUpgradePlugin_4", (String)"taxc-tcret", (Object[])new Object[0]), "ccs");
            this.put(ResManager.loadKDString((String)"\u5951\u7a0e", (String)"TcretQueryReportUpgradePlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), "qs");
            this.put(ResManager.loadKDString((String)"\u8015\u5730\u5360\u7528\u7a0e", (String)"TcretQueryReportUpgradePlugin_6", (String)"taxc-tcret", (Object[])new Object[0]), "gdzys");
            this.put(ResManager.loadKDString((String)"\u8d44\u6e90\u7a0e", (String)"TcretQueryReportUpgradePlugin_7", (String)"taxc-tcret", (Object[])new Object[0]), "zys");
            this.put(ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e", (String)"TcretQueryReportUpgradePlugin_8", (String)"taxc-tcret", (Object[])new Object[0]), "tdzzs");
            this.put(ResManager.loadKDString((String)"\u70df\u53f6\u7a0e", (String)"TcretQueryReportUpgradePlugin_9", (String)"taxc-tcret", (Object[])new Object[0]), "yys");
        }
    };

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.logs.append(this.update());
        }
        catch (Throwable t) {
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.info(ERROR_INFO, (Object)t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(true);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private String update() {
        String exists = "select fid from t_tctb_declare_main where fid not in (select fid from t_tcret_declare_entry) and fnsrtype = 'ccxws'";
        String insertSql = "insert into t_tcret_declare_entry (fentryid,fid,ftaxtype,fskssqq,fskssqz,fynse,fjmse,fyjse,fbqybtse) values (?,?,?,?,?,?,?,?,?)";
        String tcretQuerySql = "select fsbbid,ftaxtype,fstartdate,fenddate,fynse,fjmse,fyjse,fybse from t_tcret_ccxws_zb_hb where fsbbid in (%s)";
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_main")) {
            StringBuilder stringBuilder = new StringBuilder();
            List needUpdateDatas = DBUtils.query((String)exists);
            if (EmptyCheckUtils.isNotEmpty((Object)needUpdateDatas)) {
                String fsbbidStr = needUpdateDatas.stream().map(e -> String.valueOf(e.get("FID"))).collect(Collectors.joining("','"));
                List tcretEntrys = DBUtils.query((String)"taxc", (String)String.format(tcretQuerySql, "'" + fsbbidStr + "'"));
                if (EmptyCheckUtils.isNotEmpty((Object)tcretEntrys)) {
                    Map<Object, List<Map>> tcretEntrysMap = tcretEntrys.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FSBBID")) + SEPARATOR + StringUtil.formatStringNoBlank((String)String.valueOf(d.get("FTAXTYPE"))) + SEPARATOR + String.valueOf(d.get("FSTARTDATE")) + SEPARATOR + String.valueOf(d.get("FENDDATE"))));
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                    for (Map.Entry<Object, List<Map>> map : tcretEntrysMap.entrySet()) {
                        if (!EmptyCheckUtils.isNotEmpty(map.getValue())) continue;
                        List<Map> list = map.getValue();
                        String taxtype = StringUtil.formatStringNoBlank((String)String.valueOf(list.get(0).get("FTAXTYPE")));
                        if (this.taxTypeMap.get(taxtype) == null) {
                            stringBuilder.append(taxtype).append("\n");
                            continue;
                        }
                        long fentryid = DBUtils.getLongId((String)"t_tcret_declare_entry");
                        long fsbbid = Long.parseLong((String)list.get(0).get("FSBBID"));
                        String ftaxtype = this.taxTypeMap.get(taxtype);
                        Object fskssqq = list.get(0).get("FSTARTDATE");
                        Object fskssqz = list.get(0).get("FENDDATE");
                        BigDecimal fynse = BigDecimal.ZERO;
                        BigDecimal fjmse = BigDecimal.ZERO;
                        BigDecimal fyjse = BigDecimal.ZERO;
                        BigDecimal fybse = BigDecimal.ZERO;
                        for (Map objectMap : list) {
                            fynse = fynse.add((BigDecimal)objectMap.get("FYNSE"));
                            fjmse = fjmse.add((BigDecimal)objectMap.get("FJMSE"));
                            fyjse = fyjse.add((BigDecimal)objectMap.get("FYJSE"));
                            fybse = fybse.add((BigDecimal)objectMap.get("FYBSE"));
                        }
                        paramList.add(new Object[]{fentryid, fsbbid, ftaxtype, fskssqq, fskssqz, fynse, fjmse, fyjse, fybse});
                    }
                    try (TXHandle h = TX.required();){
                        try {
                            if (EmptyCheckUtils.isNotEmpty(paramList)) {
                                DBUtils.executeBatch((String)"taxc", (String)insertSql, paramList);
                            }
                        }
                        catch (Exception e2) {
                            h.markRollback();
                            LOGGER.error("update Error!", (Throwable)e2);
                            String string = String.format(ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u540c\u6b65\u5931\u8d25,\u5f02\u5e38\u7a0e\u79cd\u540d\u79f0\uff1a", (String)"TcretQueryReportUpgradeNewPlugin_0", (String)"taxc-tcret-mservice", (Object[])new Object[0]), stringBuilder);
                            if (h != null) {
                                if (var11_11 != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable) {
                                        var11_11.addSuppressed(throwable);
                                    }
                                } else {
                                    h.close();
                                }
                            }
                            return string;
                        }
                    }
                    return String.format(ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u540c\u6b65\u6210\u529f,\u5f02\u5e38\u7a0e\u79cd\u540d\u79f0\uff1a", (String)"TcretQueryReportUpgradeNewPlugin_1", (String)"taxc-tcret-mservice", (Object[])new Object[0]), stringBuilder);
                }
            }
            return ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u65e0\u9700\u540c\u6b65", (String)"TcretQueryReportUpgradeNewPlugin_2", (String)"taxc-tcret-mservice", (Object[])new Object[0]);
        }
        return String.format("The %s is not exist!", "t_tctb_declare_main");
    }
}

