/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TcretQueryReportUpgradePlugin
implements IUpgradeService {
    private static final Map<String, String> taxTypeMap = new HashMap<String, String>(){
        {
            this.put(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"TcretQueryReportUpgradePlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), "cztdsys");
            this.put(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TcretQueryReportUpgradePlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), "yhs");
            this.put(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"TcretQueryReportUpgradePlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), "fcs");
            this.put(ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"TcretQueryReportUpgradePlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), "hbs");
            this.put(ResManager.loadKDString((String)"\u8f66\u8239\u7a0e", (String)"TcretQueryReportUpgradePlugin_4", (String)"taxc-tcret", (Object[])new Object[0]), "ccs");
            this.put(ResManager.loadKDString((String)"\u5951\u7a0e", (String)"TcretQueryReportUpgradePlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), "qs");
            this.put(ResManager.loadKDString((String)"\u8015\u5730\u5360\u7528\u7a0e", (String)"TcretQueryReportUpgradePlugin_6", (String)"taxc-tcret", (Object[])new Object[0]), "gdzys");
            this.put(ResManager.loadKDString((String)"\u8d44\u6e90\u7a0e", (String)"TcretQueryReportUpgradePlugin_7", (String)"taxc-tcret", (Object[])new Object[0]), "zys");
            this.put(ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e", (String)"TcretQueryReportUpgradePlugin_8", (String)"taxc-tcret", (Object[])new Object[0]), "tdzzs");
            this.put(ResManager.loadKDString((String)"\u70df\u53f6\u7a0e", (String)"TcretQueryReportUpgradePlugin_9", (String)"taxc-tcret", (Object[])new Object[0]), "yys");
        }
    };

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(this.update());
        return result;
    }

    private String update() {
        try {
            String exists = "select fid from t_tctb_declare_main where fid not in (select fid from t_tcret_declare_entry) and fnsrtype = 'ccxws'";
            String insertSql = "insert into t_tcret_declare_entry (fentryid,fid,ftaxtype,fskssqq,fskssqz,fynse,fjmse,fyjse,fbqybtse) values (?,?,?,?,?,?,?,?,?)";
            String tcretQuerySql = "select fsbbid,ftaxtype,fstartdate,fenddate,sum(fynse) as fynse,sum(fjmse) as fjmse,sum(fyjse) as fyjse,sum(fybse) as fybse from t_tcret_ccxws_zb_hb group by fsbbid,ftaxtype,fstartdate,fenddate ";
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_main")) {
                return String.format("The %s is not exist!", "t_tctb_declare_main");
            }
            List existsData = DBUtils.query((String)"taxc", (String)exists);
            if (existsData.size() == 0) {
                return ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u5df2\u88ab\u540c\u6b65\u8fc7", (String)"TcretQueryReportUpgradePlugin_10", (String)"taxc-tcret", (Object[])new Object[0]);
            }
            Set ids = existsData.stream().map(a -> a.get("FID")).collect(Collectors.toSet());
            List tcretEntrys = DBUtils.query((String)"taxc", (String)tcretQuerySql);
            if (!CollectionUtils.isEmpty((Collection)tcretEntrys)) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (Map row : tcretEntrys) {
                    if (!ids.contains(Long.parseLong((String)row.get("FSBBID")))) continue;
                    long fentryid = DBUtils.getLongId((String)"t_tcret_declare_entry");
                    long fsbbid = Long.parseLong((String)row.get("FSBBID"));
                    String ftaxtype = taxTypeMap.get(row.get("FTAXTYPE").toString());
                    Object fskssqq = row.get("FSTARTDATE");
                    Object fskssqz = row.get("FENDDATE");
                    Object fynse = row.get("FYNSE");
                    Object fjmse = row.get("FJMSE");
                    Object fyjse = row.get("FYJSE");
                    Object fybse = row.get("FYBSE");
                    paramList.add(new Object[]{fentryid, fsbbid, ftaxtype, fskssqq, fskssqz, fynse, fjmse, fyjse, fybse});
                }
                try (TXHandle h = TX.required();){
                    try {
                        if (EmptyCheckUtils.isNotEmpty(paramList)) {
                            DBUtils.executeBatch((String)"taxc", (String)insertSql, paramList);
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
            return ResManager.loadKDString((String)"\u8d22\u884c\u7a0e\u5206\u5f55\u7a0e\u79cd\u6570\u636e\u540c\u6b65\u6210\u529f", (String)"TcretQueryReportUpgradePlugin_11", (String)"taxc-tcret", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }
}

