/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import org.apache.commons.collections.CollectionUtils;

public class TdzzsWpxsUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TdzzsWpxsUpgradePlugin.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String queryFidSql = "select fid from  t_tdm_tdzzs_wpxssw  where fid not in (select fid from t_tctb_declare_main)";
        List needUpdateFidList = DBUtils.query((String)queryFidSql);
        if (CollectionUtils.isNotEmpty((Collection)needUpdateFidList)) {
            List updateMainIds = needUpdateFidList.stream().map(s -> s.get("FID")).collect(Collectors.toList());
            DynamicObject[] tdzzsWpxsswdjs = BusinessDataServiceHelper.load((Object[])updateMainIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_tdzzs_wpxsswdj"));
            ArrayList<DynamicObject> tcvatNsrxxList = new ArrayList<DynamicObject>(tdzzsWpxsswdjs.length);
            ArrayList<DynamicObject> baseTaxList = new ArrayList<DynamicObject>(tdzzsWpxsswdjs.length);
            ArrayList wpsyTaxList = Lists.newArrayList();
            ArrayList jmmsgList = Lists.newArrayList();
            ArrayList ysgxObjList = Lists.newArrayList();
            for (DynamicObject tdzzsWpxsswdj : tdzzsWpxsswdjs) {
                Object entry2;
                DynamicObject tcvatNsrxx = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_nsrxx");
                this.setNsrxx(tdzzsWpxsswdj, tcvatNsrxx);
                tcvatNsrxxList.add(tcvatNsrxx);
                DynamicObject baseTax = BusinessDataServiceHelper.newDynamicObject((String)"tcret_tdzzs_base_tax");
                baseTax.set("ewblxh", (Object)"1");
                baseTax.set("ewblname", (Object)"1");
                baseTax.set("sbbid", (Object)tdzzsWpxsswdj.getString("id"));
                baseTax.set("pronumber", tdzzsWpxsswdj.get("tdzzsxm.number"));
                baseTax.set("proname", tdzzsWpxsswdj.get("tdzzsxm.name"));
                baseTax.set("proaddress", tdzzsWpxsswdj.get("tdzzsxm.address"));
                baseTaxList.add(baseTax);
                DynamicObjectCollection entryentity = tdzzsWpxsswdj.getDynamicObjectCollection("entryentity");
                for (Object entry2 : entryentity) {
                    DynamicObject wpsyTax = BusinessDataServiceHelper.newDynamicObject((String)"tcret_tdzzs_wpsy_tax");
                    wpsyTax.set("ewblxh", (Object)entry2.getString("seq"));
                    wpsyTax.set("sbbid", (Object)tdzzsWpxsswdj.getString("id"));
                    wpsyTax.set("ptzz", entry2.get("ptzz"));
                    wpsyTax.set("fptzz", entry2.get("fptzz"));
                    wpsyTax.set("qtlxfc", entry2.get("qtlxfc"));
                    String hjStr = entry2.getString("hj");
                    try {
                        wpsyTax.set("hj", (Object)BigDecimalUtil.toBigDecimal((Object)hjStr));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    wpsyTaxList.add(wpsyTax);
                }
                DynamicObjectCollection jmentry = tdzzsWpxsswdj.getDynamicObjectCollection("jmentry");
                entry2 = jmentry.iterator();
                while (entry2.hasNext()) {
                    DynamicObject jmen = (DynamicObject)entry2.next();
                    DynamicObject jmmsg = BusinessDataServiceHelper.newDynamicObject((String)"tcret_wp_jm_entry");
                    jmmsg.set("houtype", jmen.get("houtype"));
                    jmmsg.set("taxdeduction", jmen.get("taxdeduction.id"));
                    jmmsg.set("sbbid", (Object)tdzzsWpxsswdj.getLong("id"));
                    jmmsg.set("jmse", ((DynamicObject)entryentity.get(22)).get(jmen.getString("houtype")));
                    jmmsgList.add(jmmsg);
                }
                if (tcvatNsrxx.get("sbbid") == null) continue;
                DynamicObject ysgxObj = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_source_mapping");
                ysgxObj.set("sbbid", tcvatNsrxx.get("sbbid"));
                ysgxObj.set("taxsourcetype", (Object)"tcvat_nsrxx");
                ysgxObj.set("taxsourceid", (Object)tcvatNsrxx.getLong("id"));
                ysgxObj.set("taxtype", (Object)"tdzzs");
                ysgxObjList.add(ysgxObj);
            }
            SaveServiceHelper.save((DynamicObject[])tcvatNsrxxList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])baseTaxList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])wpsyTaxList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])jmmsgList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])ysgxObjList.toArray(new DynamicObject[0]));
        }
    }

    private void setNsrxx(DynamicObject tdzzsWpxsswdj, DynamicObject tcvatNsrxx) {
        DynamicObject sbbNsrxx;
        tcvatNsrxx.set("id", tdzzsWpxsswdj.get("id"));
        tcvatNsrxx.set("org", (Object)tdzzsWpxsswdj.getLong("org.id"));
        tcvatNsrxx.set("type", (Object)"latwp");
        tcvatNsrxx.set("skssqq", tdzzsWpxsswdj.get("startdate"));
        tcvatNsrxx.set("skssqz", tdzzsWpxsswdj.get("enddate"));
        tcvatNsrxx.set("bqybtse", tdzzsWpxsswdj.get("ybtse"));
        tcvatNsrxx.set("maindataid", tdzzsWpxsswdj.get("maindataid"));
        tcvatNsrxx.set("taxsourceid", tdzzsWpxsswdj.get("tdzzsxm.id"));
        String sbbbillno = tdzzsWpxsswdj.getString("sbbbillno");
        if (StringUtils.isNotEmpty((CharSequence)sbbbillno) && (sbbNsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)sbbbillno)})) != null) {
            tcvatNsrxx.set("sbbid", sbbNsrxx.get("id"));
        }
        tcvatNsrxx.set("billno", tdzzsWpxsswdj.get("billno"));
        tcvatNsrxx.set("billstatus", tdzzsWpxsswdj.get("billstatus"));
        tcvatNsrxx.set("creator", tdzzsWpxsswdj.get("creator.id"));
        tcvatNsrxx.set("auditor", tdzzsWpxsswdj.get("auditor.id"));
        tcvatNsrxx.set("modifier", tdzzsWpxsswdj.get("modifier.id"));
        tcvatNsrxx.set("auditdate", tdzzsWpxsswdj.get("auditdate"));
        tcvatNsrxx.set("createtime", tdzzsWpxsswdj.get("createtime"));
        tcvatNsrxx.set("modifytime", tdzzsWpxsswdj.get("modifytime"));
        DynamicObject bastaxTaxorg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"taxpayer,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)tdzzsWpxsswdj.getLong("org.id"))});
        if (bastaxTaxorg != null) {
            tcvatNsrxx.set("nsrsbh", bastaxTaxorg.get("unifiedsocialcode"));
            tcvatNsrxx.set("nsrmc", bastaxTaxorg.get("taxpayer"));
        }
        tcvatNsrxx.set("ewblxh", (Object)"1");
        tcvatNsrxx.set("templateid", (Object)"1616046770893214720");
        tcvatNsrxx.set("taxlimit", tdzzsWpxsswdj.get("sblimit"));
        tcvatNsrxx.set("datatype", (Object)"1");
        tcvatNsrxx.set("sblx", (Object)"1");
        tcvatNsrxx.set("declaredate", tdzzsWpxsswdj.get("enddate"));
    }
}

