/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class YhsTaxSourceUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YhsTaxSourceUpgradePlugin.class);
    private static final String YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String YHS_TAX_ACCOUNT_FB = "tcret_yhs_tax_account_fb";
    private static final String YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String FIELDS = "id,datasource,org,taxitem,skssqq,skssqz,voucherno,voucherdate,deductioncode,calctaxamount,declaretype,taxation,verifyrate,verifybasis,serialno,taxlimit,gathernumber,maindataid,declarestatus,sbbbillstatus,sbbbillno";
    private static final String T_TCRET_YHS_TZ = "t_tcret_yhs_tz";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String MAINDATAID = "maindataid";
    private static final String TCRET_DECLARE_MAIN = "tcret_declare_main";
    private static final Long ZEROR = Long.valueOf("0");

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        for (String number : Arrays.asList(YHS_TAX_SOURCE_INFO, YHS_TAX_ACCOUNT, YHS_TAX_ACCOUNT_FB, TCVAT_NSRXX)) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        long l = System.currentTimeMillis();
        this.addLog(INFO, "select * from t_tcret_sycj_yhsxx where fdatasource in ('useradd','system')");
        QFilter qFilter = new QFilter("datasource", "in", Arrays.asList("useradd", "system"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)YHS_TAX_SOURCE_INFO, (String)FIELDS, (QFilter[])qFilter.toArray());
        long l1 = System.currentTimeMillis();
        this.addLog(INFO, String.format("Result Size: %d", load == null ? 0 : load.length));
        this.addLog(INFO, String.format("Use Time(ms): %d", l1 - l));
        if (load == null || load.length == 0) {
            return;
        }
        ArrayList accounts = new ArrayList();
        ArrayList accounts_fb = new ArrayList();
        Arrays.stream(load).filter(b -> Objects.equals(b.getString("datasource"), "system")).forEach(a -> {
            this.buildAccount((DynamicObject)a, accounts_fb, accounts);
            a.set("datasource", (Object)"fromacc");
        });
        long l2 = System.currentTimeMillis();
        this.addLog(INFO, "select * from t_tctb_declare_main where maindataid is not null and fnasrtype='ccxws'");
        QFilter and = QFilter.isNotNull((String)MAINDATAID).and(MAINDATAID, "!=", (Object)Long.parseLong("0")).and("type", "=", (Object)"ccxws");
        DynamicObject[] sbb = BusinessDataServiceHelper.load((String)TCVAT_NSRXX, (String)"id,maindataid,declarestatus,billstatus,billno", (QFilter[])and.toArray());
        Map<Long, DynamicObject> idMap = Arrays.stream(sbb).collect(Collectors.toMap(a -> a.getLong("id"), b -> b, (m, n) -> m));
        long l3 = System.currentTimeMillis();
        this.addLog(INFO, String.format("Result Size: %d", sbb == null ? 0 : sbb.length));
        this.addLog(INFO, String.format("Use Time(ms): %d", l3 - l2));
        this.addLog(INFO, "select * from t_tcret_declare_main where id is not null");
        DynamicObjectCollection tcretMains = QueryServiceHelper.query((String)TCRET_DECLARE_MAIN, (String)"id,sbbid", (QFilter[])new QFilter[]{QFilter.isNotNull((String)"id")});
        Map<Long, Object> tcretMainToSbbMap = tcretMains.stream().collect(Collectors.toMap(a -> a.getLong("id"), b -> b.get("sbbid"), (m, n) -> m));
        long l4 = System.currentTimeMillis();
        this.addLog(INFO, String.format("Result Size: %d", tcretMains.size()));
        this.addLog(INFO, String.format("Use Time(ms): %d", l4 - l3));
        Arrays.stream(load).forEach(c -> {
            if (c.get(MAINDATAID) != null && c.getLong(MAINDATAID) != 0L) {
                long declareid = c.getLong(MAINDATAID);
                Object sbbid = tcretMainToSbbMap.get(declareid);
                if (sbbid != null && !Objects.equals(sbbid, ZEROR)) {
                    DynamicObject object = (DynamicObject)idMap.get(sbbid);
                    if (object != null) {
                        c.set("declarestatus", object.get("declarestatus"));
                        c.set("sbbbillstatus", object.get("billstatus"));
                        c.set("sbbbillno", object.get("billno"));
                    } else {
                        this.clearSbbRelation((DynamicObject)c);
                    }
                } else {
                    this.clearSbbRelation((DynamicObject)c);
                }
            } else {
                this.clearSbbRelation((DynamicObject)c);
            }
        });
        try (TXHandle h = TX.requiresNew();){
            try {
                if (load != null && load.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])load);
                }
                if (accounts.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])accounts.toArray(new DynamicObject[accounts.size()]));
                }
                if (accounts_fb.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])accounts_fb.toArray(new DynamicObject[accounts_fb.size()]));
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(ERROR_INFO, t);
                throw new RuntimeException(t);
            }
        }
    }

    private void clearSbbRelation(DynamicObject c) {
        c.set(MAINDATAID, (Object)ZEROR);
        c.set("declarestatus", (Object)"");
        c.set("sbbbillstatus", (Object)"");
    }

    private void buildAccount(DynamicObject taxSource, ArrayList<DynamicObject> acounts_fb, ArrayList<DynamicObject> acounts) {
        Object orgId = taxSource.get("org.id");
        Object taxitemId = taxSource.get("taxitem.id");
        Object skssqq = taxSource.get(SKSSQQ);
        Object skssqz = taxSource.get(SKSSQZ);
        String gathernumber = taxSource.getString("gathernumber");
        String serialno = taxSource.getString("serialno");
        DynamicObject account = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YHS_TAX_ACCOUNT));
        account.set(ORG, orgId);
        account.set("taxitem", taxitemId);
        account.set(SKSSQQ, skssqq);
        account.set(SKSSQZ, skssqz);
        account.set("billstatus", (Object)"A");
        account.set("voucherno", taxSource.get("voucherno"));
        account.set("voucherdate", taxSource.get("voucherdate"));
        account.set("declaretype", (Object)"aqsb");
        account.set("taxlimit", taxSource.get("taxlimit"));
        account.set("taxation", taxSource.get("taxation"));
        account.set("verifyrate", taxSource.get("verifyrate"));
        account.set("calctaxamount", taxSource.get("calctaxamount"));
        account.set("deductioncode", taxSource.get("deductioncode"));
        account.set("createtime", (Object)new Date());
        account.set("datasource", (Object)"system");
        account.set("serialno", (Object)serialno);
        account.set("gathernumber", (Object)gathernumber);
        long tzid = DBUtils.getLongId((String)T_TCRET_YHS_TZ);
        account.set("id", (Object)tzid);
        acounts.add(account);
        String new_gathernumber = UUID.randomUUID();
        DynamicObject account_fb = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YHS_TAX_ACCOUNT_FB));
        account_fb.set(ORG, orgId);
        account_fb.set("taxitem", taxitemId);
        account_fb.set(SKSSQQ, skssqq);
        account_fb.set(SKSSQZ, skssqz);
        account_fb.set("voucherno", taxSource.get("voucherno"));
        account_fb.set("voucherdate", taxSource.get("voucherdate"));
        account_fb.set("declaretype", (Object)"aqsb");
        account_fb.set("taxlimit", taxSource.get("taxlimit"));
        account_fb.set("taxation", taxSource.get("taxation"));
        account_fb.set("verifyrate", taxSource.get("verifyrate"));
        account_fb.set("calctaxamount", taxSource.get("calctaxamount"));
        account_fb.set("deductioncode", taxSource.get("deductioncode"));
        account_fb.set("taxsourceno", (Object)new_gathernumber);
        account_fb.set("orignalid", (Object)tzid);
        account_fb.set("createtime", (Object)new Date());
        acounts_fb.add(account_fb);
        taxSource.set("gathernumber", (Object)new_gathernumber);
    }
}

